/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datalake.hadoop;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZetStream;
import io.intino.ness.datalake.Datalake;
import io.intino.ness.datalake.hadoop.HadoopSetTank;
import io.intino.ness.datalake.hadoop.SetSequenceWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopSetStore
implements Datalake.SetStore {
    public static final String SetExtension = ".seq";
    public static final String MetadataFilename = ".metadata";
    private final FileSystem fs;
    private final Path root;

    public HadoopSetStore(FileSystem fs, Path root) {
        this.fs = fs;
        this.root = root;
    }

    public Stream<Datalake.SetStore.Tank> tanks() {
        try {
            return Arrays.stream(this.fs.listStatus(this.root)).filter(FileStatus::isDir).map(s -> new HadoopSetTank(s.getPath()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public Datalake.SetStore.Tank tank(String name) {
        return null;
    }

    public void put(ZetStream stream, String name) {
        try {
            new SetSequenceWriter(this.fs, name).write(stream);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

