/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datalake.hadoop;

import io.intino.alexandria.logger.Logger;
import io.intino.ness.datalake.hadoop.HadoopDatalake;
import io.intino.ness.datalake.hadoop.HadoopStage;
import io.intino.ness.datalake.hadoop.SessionSealer;
import io.intino.ness.ingestion.Session;
import io.intino.ness.ingestion.SessionManager;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopSessionManager
implements SessionManager {
    private final HadoopStage stage;
    private final FileSystem fs;
    private final Path sessionsPath;
    private final HadoopDatalake datalake;

    public HadoopSessionManager(HadoopDatalake datalake, FileSystem fs, Path treatedSessionsPath) {
        this.datalake = datalake;
        this.fs = fs;
        this.sessionsPath = treatedSessionsPath;
        this.mkdirs(treatedSessionsPath);
        this.stage = new HadoopStage(fs, datalake.stagePath(), treatedSessionsPath);
    }

    private void mkdirs(Path sessionsPath) {
        try {
            if (!this.fs.exists(sessionsPath)) {
                this.fs.mkdirs(sessionsPath);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void push(Stream<Session> sessions) {
        this.stage.push(sessions);
    }

    public void seal() {
        new SessionSealer(this.fs, this.stage, this.datalake.eventStorePath(), this.datalake.setStorePath(), this.tempPath()).seal();
        this.stage.clear();
    }

    private Path tempPath() {
        return new Path(this.sessionsPath, "temp");
    }
}

