/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datalake.hadoop;

import io.intino.alexandria.inl.Message;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zim.ZimStream;
import io.intino.ness.datalake.Datalake;
import io.intino.ness.datalake.hadoop.HadoopEventTank;
import io.intino.ness.datalake.hadoop.MessageSequenceWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopEventStore
implements Datalake.EventStore {
    public static final String EventExtension = ".seq";
    public static final String SessionExtension = ".event.seq";
    private final FileSystem fs;
    private final Path root;

    public HadoopEventStore(FileSystem fs, Path root) {
        this.fs = fs;
        this.root = root;
    }

    public Stream<Datalake.EventStore.Tank> tanks() {
        try {
            return Arrays.stream(this.fs.listStatus(this.root)).filter(FileStatus::isDir).map(s -> new HadoopEventTank(s.getPath()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public Datalake.EventStore.Tank tank(String name) {
        Path path = new Path(this.tankPath(name));
        try {
            if (!this.fs.exists(path)) {
                this.fs.mkdirs(path);
            }
            return new HadoopEventTank(path);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    void put(ZimStream stream, String blob) {
        while (stream.hasNext()) {
            this.put(Collections.singletonList(stream.next()), this.zimFile(blob));
        }
    }

    private void put(List<Message> messages, String tank) {
        try {
            new MessageSequenceWriter(this.fs, this.root.toString().replace(this.fs.getUri().toString(), "") + "/" + tank).write("session_" + UUID.randomUUID(), messages);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String tankPath(String tank) {
        return this.root.toString() + tank;
    }

    private String zimFile(String blob) {
        String fingerprint = blob.substring(0, blob.indexOf("#"));
        return fingerprint.replace("-", "/") + ".zim";
    }
}

