/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datalake.hadoop;

import io.intino.alexandria.logger.Logger;
import io.intino.ness.datalake.Datalake;
import io.intino.ness.datalake.hadoop.HadoopEventStore;
import io.intino.ness.datalake.hadoop.HadoopSetStore;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopDatalake
implements Datalake {
    private final FileSystem fs;
    private final Path root;

    public HadoopDatalake(FileSystem fs) {
        this.root = new Path(fs.getWorkingDirectory(), "datalake");
        this.fs = fs;
        this.mkdirs();
    }

    public Datalake.EventStore eventStore() {
        return new HadoopEventStore(this.fs, this.eventStorePath());
    }

    public Datalake.SetStore setStore() {
        return new HadoopSetStore(this.fs, this.setStorePath());
    }

    Path stagePath() {
        return this.stagePath(this.root);
    }

    Path eventStorePath() {
        return this.eventStorePath(this.root);
    }

    Path setStorePath() {
        return this.setStorePath(this.root);
    }

    private void mkdirs() {
        try {
            if (!this.fs.exists(this.root)) {
                this.fs.mkdirs(this.root);
            }
            if (!this.fs.exists(this.stagePath(this.root))) {
                this.fs.mkdirs(this.stagePath(this.root));
            }
            if (!this.fs.exists(this.setStorePath(this.root))) {
                this.fs.mkdirs(this.setStorePath(this.root));
            }
            if (!this.fs.exists(this.eventStorePath(this.root))) {
                this.fs.mkdirs(this.eventStorePath(this.root));
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private Path setStorePath(Path root) {
        return new Path(root, "sets");
    }

    private Path eventStorePath(Path root) {
        return new Path(root, "events");
    }

    private Path stagePath(Path root) {
        return new Path(root, "stage.seq");
    }
}

