/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.datamarts;

import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.datamarts.ConceptRenderer;
import io.intino.ness.datahubterminalplugin.datamarts.ExpressionHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StructFrameFactory
implements ConceptRenderer {
    private static final String DOT = ".";
    public static final String STRUCT_INTERNAL_CLASS_SEP = "$";
    private final Datamart datamart;
    private final String workingPackage;

    public StructFrameFactory(Datamart datamart, String workingPackage) {
        this.datamart = datamart;
        this.workingPackage = workingPackage;
    }

    public Map<String, Frame> create(Struct struct) {
        return this.create(struct, null);
    }

    public Map<String, Frame> create(Struct struct, String ownerName) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(1);
        map.put(this.calculateStructPath(struct, this.workingPackage), this.frameOf(struct, ownerName).toFrame());
        return map;
    }

    private FrameBuilder frameOf(Struct struct, String ownerName) {
        boolean internalClass = ownerName != null;
        String name = ownerName + STRUCT_INTERNAL_CLASS_SEP + struct.name$();
        List attributes = this.attributesOf(struct).stream().map(this::attrFrameOf).map(FrameBuilder::toFrame).collect(Collectors.toList());
        FrameBuilder builder = new FrameBuilder(new String[]{"struct", "class"}).add("package", (Object)this.workingPackage).add("name", (Object)struct.name$()).add("definitionname", (Object)name).add("datamart", (Object)this.datamart.name$()).add("parent", (Object)(this.workingPackage + DOT + StringFormatters.firstUpperCase().format((Object)this.datamart.name$()) + "Struct")).add("expression", struct.methodList().stream().map(e -> ExpressionHelper.exprFrameOf((Expression)e, this.workingPackage)).toArray(Frame[]::new)).add("struct", struct.structList().stream().map(s -> this.frameOf((Struct)s, name)).map(FrameBuilder::toFrame).toArray(Frame[]::new));
        if (struct.multiple()) {
            builder.add("multiple");
        }
        if (internalClass) {
            builder.add("static", (Object)" static");
        } else {
            builder.add("standalone", (Object)this.header());
        }
        struct.structList().stream().map(s -> this.attrFrameOf(this.attrOf(struct.core$(), (Struct)s)).toFrame()).forEach(attributes::add);
        builder.add("attribute", attributes.toArray(Frame[]::new));
        return builder;
    }

    private Frame header() {
        return new FrameBuilder(new String[]{"standalone"}).add("package", (Object)this.workingPackage).add("datamart", (Object)this.datamart.name$()).toFrame();
    }

    @Override
    public Datamart datamart() {
        return this.datamart;
    }

    @Override
    public String workingPackage() {
        return this.workingPackage;
    }

    private String calculateStructPath(Struct struct, String thePackage) {
        return thePackage + ".structs." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)struct.name$()).toString());
    }
}

