/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.terminal;

import io.intino.Configuration;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Reel;
import io.intino.datahub.model.Resource;
import io.intino.datahub.model.Sensor;
import io.intino.datahub.model.Terminal;
import io.intino.datahub.model.Timeline;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Layer;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.datamarts.DatamartsRenderer;
import io.intino.ness.datahubterminalplugin.terminal.TerminalTemplate;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class TerminalRenderer {
    private final Terminal terminal;
    private final File srcDir;
    private final String rootPackage;
    private final Configuration conf;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private final String ontologyPackage;
    private final Set<Datalake.Tank.Message> messageTanks = new HashSet<Datalake.Tank.Message>();
    private final Set<Datalake.Tank.Measurement> measurementTanks = new HashSet<Datalake.Tank.Measurement>();
    private final Set<Datalake.Tank.Resource> resourceTanks = new HashSet<Datalake.Tank.Resource>();

    TerminalRenderer(Terminal terminal, File srcDir, String rootPackage, Configuration conf, PrintStream logger, PluginLauncher.Notifier notifier, String ontologyPackage) {
        this.terminal = terminal;
        this.srcDir = srcDir;
        this.rootPackage = rootPackage;
        this.conf = conf;
        this.logger = logger;
        this.notifier = notifier;
        this.ontologyPackage = ontologyPackage;
    }

    void render() {
        File packageFolder = new File(this.srcDir, this.rootPackage.replace(".", File.separator));
        Commons.writeFrame(packageFolder, Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString(), this.template().render((Object)this.createTerminalFrame()));
    }

    private Frame createTerminalFrame() {
        Datalake datalake = this.terminal.graph().datalake();
        FrameBuilder builder = new FrameBuilder(new String[]{"terminal"}).add("package", (Object)this.rootPackage).add("name", (Object)this.terminal.name$());
        if (datalake != null) {
            builder.add("datalake", (Object)"").add("scale", (Object)datalake.scale().name());
        }
        if (this.terminal.publish() != null) {
            this.addPublish(builder);
        }
        if (this.terminal.subscribe() != null) {
            this.addSubscribe(builder);
        }
        if (this.terminal.bpm() != null) {
            this.addBpm(builder);
        }
        if (this.terminal.datamarts() != null) {
            this.renderDatamarts(builder);
            this.addSubscribeForThedevents(builder);
        }
        if (!this.messageTanks.isEmpty()) {
            builder.add("message", (Object)this.messageFrames());
        }
        if (!this.measurementTanks.isEmpty()) {
            builder.add("measurement", (Object)this.measurementFrames());
        }
        if (!this.resourceTanks.isEmpty()) {
            builder.add("resource", (Object)this.resourceFrames());
        }
        return builder.toFrame();
    }

    private void addSubscribe(FrameBuilder builder) {
        this.terminal.subscribe().messageTanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Message)tank)));
        this.terminal.subscribe().measurementTanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Measurement)tank)));
    }

    private void addSubscribeForThedevents(FrameBuilder builder) {
        HashSet<String> tanksAlreadySubscribedTo = new HashSet<String>();
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().messageTanks().stream().map(Layer::name$).forEach(tanksAlreadySubscribedTo::add);
            this.terminal.subscribe().measurementTanks().stream().map(Layer::name$).forEach(tanksAlreadySubscribedTo::add);
            this.terminal.subscribe().resourceTanks().stream().map(Layer::name$).forEach(tanksAlreadySubscribedTo::add);
        }
        for (Datamart datamart : this.terminal.datamarts().list()) {
            this.addSubscribersForEntityEvents(builder, tanksAlreadySubscribedTo, datamart);
            this.addSubscribersForTimelineEvents(builder, tanksAlreadySubscribedTo, datamart);
            this.addSubscriberForReelEvents(builder, tanksAlreadySubscribedTo, datamart);
        }
    }

    private void addSubscriberForReelEvents(FrameBuilder builder, Set<String> tanksAlreadySubscribedTo, Datamart datamart) {
        datamart.reelList().stream().map(Reel::tank).filter(Objects::nonNull).distinct().filter(tank -> tanksAlreadySubscribedTo.add(tank.name$())).forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Message)tank)));
    }

    private void addSubscribersForTimelineEvents(FrameBuilder builder, Set<String> tanksAlreadySubscribedTo, Datamart datamart) {
        datamart.timelineList().stream().map(Timeline::tank).filter(Objects::nonNull).distinct().filter(tank -> tanksAlreadySubscribedTo.add(tank.name$())).forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Measurement)tank)));
    }

    private void addSubscribersForEntityEvents(FrameBuilder builder, Set<String> tanksAlreadySubscribedTo, Datamart datamart) {
        datamart.entityList().stream().map(Entity::from).filter(Objects::nonNull).distinct().filter(tank -> tanksAlreadySubscribedTo.add(tank.name$())).forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Message)tank)));
    }

    private void addPublish(FrameBuilder builder) {
        this.terminal.publish().messageTanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Message)tank)));
        this.terminal.publish().measurementTanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Measurement)tank)));
    }

    private void renderDatamarts(FrameBuilder builder) {
        for (Datamart datamart : this.terminal.datamarts().list()) {
            builder.add("datamart", (Object)this.frameOf(datamart));
        }
        new DatamartsRenderer(this.srcDir, this.terminal.graph(), this.conf, this.logger, this.notifier, this.ontologyPackage).render(this.terminal, this.rootPackage);
    }

    private FrameBuilder frameOf(Datamart datamart) {
        return new FrameBuilder(new String[]{"datamart"}).add("name", (Object)datamart.name$()).add("terminal", (Object)this.terminal.name$()).add("package", (Object)(this.ontologyPackage + ".datamarts." + Formatters.javaValidName().format((Object)datamart.name$().toLowerCase()).toString())).add("devent", (Object)this.eventsOf(datamart));
    }

    private FrameBuilder[] eventsOf(Datamart datamart) {
        HashMap<String, FrameBuilder> events = new HashMap<String, FrameBuilder>();
        events.putAll(this.entityEventsOf(datamart));
        events.putAll(this.timelineEventsOf(datamart));
        events.putAll(this.reelEventsOf(datamart));
        return (FrameBuilder[])events.values().toArray(FrameBuilder[]::new);
    }

    private Map<String, FrameBuilder> reelEventsOf(Datamart datamart) {
        return datamart.reelList().stream().map(s -> s.tank().message()).filter(Objects::nonNull).distinct().collect(Collectors.toMap(Layer::name$, tank -> this.frameOf((Message)tank, datamart)));
    }

    private Map<String, FrameBuilder> timelineEventsOf(Datamart datamart) {
        return datamart.timelineList().stream().map(Timeline::tank).filter(Objects::nonNull).map(Datalake.Tank.Measurement::sensor).distinct().collect(Collectors.toMap(Layer::name$, tank -> this.frameOf((Sensor)tank, datamart)));
    }

    private Map<String, FrameBuilder> entityEventsOf(Datamart datamart) {
        return datamart.entityList().stream().map(Entity::from).filter(Objects::nonNull).map(Datalake.Tank.Message::message).distinct().collect(Collectors.toMap(Layer::name$, tank -> this.frameOf((Message)tank, datamart)));
    }

    private FrameBuilder frameOf(Sensor sensor, Datamart datamart) {
        return new FrameBuilder(new String[]{"devent"}).add("message", (Object)sensor.name$()).add("namespaceQn", (Object)this.namespace((Layer)sensor).replace(".", "")).add("datamart", (Object)datamart.name$());
    }

    private FrameBuilder frameOf(Message message, Datamart datamart) {
        return new FrameBuilder(new String[]{"devent"}).add("message", (Object)message.name$()).add("namespaceQn", (Object)this.namespace((Layer)message).replace(".", "")).add("datamart", (Object)datamart.name$());
    }

    private Frame[] messageFrames() {
        return (Frame[])this.messageTanks.stream().map(Datalake.Tank.Message::message).distinct().map(m -> new FrameBuilder(new String[]{"message"}).add("namespace", (Object)this.namespace((Layer)m)).add("namespaceQn", (Object)this.namespace((Layer)m).replace(".", "")).add("name", (Object)m.name$()).add("typename", (Object)Formatters.firstUpperCase(m.name$())).add("type", (Object)(this.messagePackage((Message)m) + "." + Formatters.firstUpperCase(m.name$()))).toFrame()).toArray(Frame[]::new);
    }

    private Frame[] measurementFrames() {
        return (Frame[])this.measurementTanks.stream().map(Datalake.Tank.Measurement::sensor).distinct().map(m -> new FrameBuilder(new String[]{"measurement"}).add("namespace", (Object)this.namespace((Layer)m)).add("namespaceQn", (Object)this.namespace((Layer)m).replace(".", "")).add("name", (Object)m.name$()).add("typename", (Object)Formatters.firstUpperCase(m.name$())).add("type", (Object)(this.measurementPackage((Sensor)m) + "." + Formatters.firstUpperCase(m.name$()))).toFrame()).toArray(Frame[]::new);
    }

    private Frame[] resourceFrames() {
        return (Frame[])this.resourceTanks.stream().map(Datalake.Tank.Resource::resourceEvent).distinct().map(r -> new FrameBuilder(new String[]{"resource"}).add("namespace", (Object)this.namespace((Layer)r)).add("namespaceQn", (Object)this.namespace((Layer)r).replace(".", "")).add("name", (Object)r.name$()).add("typename", (Object)Formatters.firstUpperCase(r.name$())).add("type", (Object)(this.resourcePackage((Resource)r) + "." + Formatters.firstUpperCase(r.name$()))).toFrame()).toArray(Frame[]::new);
    }

    private void addBpm(FrameBuilder builder) {
        String statusQn = this.terminal.bpm().processStatusClass();
        String processStatusQName = statusQn.substring(statusQn.lastIndexOf(".") + 1);
        String namespace = Optional.ofNullable(this.terminal.bpm().namespace()).orElse("");
        String channel = namespace.isEmpty() ? processStatusQName : namespace + "." + processStatusQName;
        FrameBuilder bpmBuilder = new FrameBuilder(new String[]{"default", "bpm"}).add("type", (Object)statusQn).add("namespaceQn", (Object)statusQn).add("typeName", (Object)processStatusQName).add("message", (Object)processStatusQName).add("channel", (Object)channel);
        builder.add("event", (Object)new FrameBuilder(new String[]{"event"}).add("type", (Object)statusQn).add("name", (Object)processStatusQName).add("typename", (Object)processStatusQName).toFrame());
        builder.add("processstatus", (Object)new FrameBuilder(new String[]{"event"}).add("type", (Object)statusQn).add("name", (Object)processStatusQName).add("typename", (Object)processStatusQName).add("channel", (Object)channel).toFrame());
        builder.add("subscribe", (Object)bpmBuilder);
        builder.add("publish", (Object)bpmBuilder);
    }

    private Frame frameOf(Datalake.Tank.Message tank) {
        this.messageTanks.add(tank);
        String messagesPackage = this.messagePackage(tank.message());
        String namespace = this.namespace((Layer)tank.message());
        return new FrameBuilder(new String[]{"message"}).add("type", (Object)(messagesPackage + "." + Formatters.firstUpperCase(tank.message().name$()))).add("message", (Object)tank.message().name$()).add("typeName", (Object)tank.name$()).add("namespace", (Object)namespace).add("namespaceQn", (Object)namespace.replace(".", "")).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(tank.name$()))).add("channel", (Object)tank.qn()).toFrame();
    }

    private Frame frameOf(Datalake.Tank.Resource tank) {
        this.resourceTanks.add(tank);
        String messagesPackage = this.resourcePackage(tank.resourceEvent());
        String namespace = this.namespace((Layer)tank.resourceEvent());
        return new FrameBuilder(new String[]{"measurement"}).add("type", (Object)(messagesPackage + "." + Formatters.firstUpperCase(tank.resourceEvent().name$()))).add("message", (Object)tank.resourceEvent().name$()).add("typeName", (Object)tank.name$()).add("namespace", (Object)namespace).add("namespaceQn", (Object)namespace.replace(".", "")).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(tank.name$()))).add("channel", (Object)tank.qn()).toFrame();
    }

    private Frame frameOf(Datalake.Tank.Measurement tank) {
        this.measurementTanks.add(tank);
        String messagesPackage = this.measurementPackage(tank.sensor());
        String namespace = this.namespace((Layer)tank.sensor());
        return new FrameBuilder(new String[]{"measurement"}).add("type", (Object)(messagesPackage + "." + Formatters.firstUpperCase(tank.sensor().name$()))).add("message", (Object)tank.sensor().name$()).add("typeName", (Object)tank.name$()).add("namespace", (Object)namespace).add("namespaceQn", (Object)namespace.replace(".", "")).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(tank.name$()))).add("channel", (Object)tank.qn()).toFrame();
    }

    private String messagePackage(Message event) {
        String aPackage = this.rootPackage + ".messages";
        if (event.core$().owner().is(Namespace.class)) {
            aPackage = aPackage + "." + this.namespace((Layer)event);
        }
        return aPackage;
    }

    private String measurementPackage(Sensor event) {
        String aPackage = this.rootPackage + ".measurements";
        if (event.core$().owner().is(Namespace.class)) {
            aPackage = aPackage + "." + this.namespace((Layer)event);
        }
        return aPackage;
    }

    private String resourcePackage(Resource event) {
        String aPackage = this.rootPackage + ".resources";
        if (event.core$().owner().is(Namespace.class)) {
            aPackage = aPackage + "." + this.namespace((Layer)event);
        }
        return aPackage;
    }

    private String namespace(Layer event) {
        return event.core$().owner().is(Namespace.class) ? ((Namespace)event.core$().ownerAs(Namespace.class)).qn().toLowerCase() : "";
    }

    private Template template() {
        return Formatters.customize(new TerminalTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

