/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.datamarts;

import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.Expression;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.datamarts.ConceptAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ExpressionHelper {
    public static final String DEFAULT_ITR_INDENTATION = "        ";

    public static Frame exprFrameOf(Expression expr, String ontologyPackage) {
        FrameBuilder builder = new FrameBuilder(new String[]{"expression"});
        builder.add("modifier", (Object)(expr.isPrivate() ? "private" : "public"));
        builder.add("name", (Object)expr.name$().trim());
        builder.add("returnType", (Object)ExpressionHelper.returnTypeOf(expr, ontologyPackage));
        builder.add("expr", (Object)ExpressionHelper.expressionOf(expr));
        List<Frame> parameters = ExpressionHelper.parametersOf(expr, ontologyPackage);
        if (!parameters.isEmpty()) {
            builder.add("parameter", parameters.toArray(Frame[]::new));
        }
        return builder.toFrame();
    }

    private static String expressionOf(Expression expr) {
        return ExpressionHelper.decorateExpr(expr, ExpressionHelper.rawExpressionOf(expr));
    }

    private static String decorateExpr(Expression expr, String exprStr) {
        if (StringUtils.countMatches((CharSequence)(exprStr = exprStr.replace("System.out.", "java.lang.System.out.")), (CharSequence)"\n") == 0) {
            return ExpressionHelper.formatOneLineMethod(expr, exprStr);
        }
        return ExpressionHelper.formatMultilineMethod(exprStr);
    }

    private static String formatMultilineMethod(String exprStr) {
        if (exprStr.startsWith("\n")) {
            exprStr = exprStr.substring(1);
        }
        if (exprStr.endsWith("\n")) {
            exprStr = exprStr.substring(0, exprStr.length() - 1);
        }
        String[] lines = exprStr.split("\n", -1);
        String indentation = ExpressionHelper.indentationOf(lines);
        return Arrays.stream(lines).map(line -> ExpressionHelper.removeFirstIndentation(line, indentation)).collect(Collectors.joining("\n"));
    }

    private static String formatOneLineMethod(Expression expr, String exprStr) {
        exprStr = ((String)exprStr).trim();
        if (!expr.isRoutine() && !((String)exprStr).startsWith("return")) {
            exprStr = "return " + (String)exprStr;
        }
        if (!((String)exprStr).endsWith(";")) {
            exprStr = (String)exprStr + ";";
        }
        return exprStr;
    }

    private static String removeFirstIndentation(String line, String indentation) {
        return line.startsWith(indentation) ? line.substring(indentation.length()) : line;
    }

    private static String indentationOf(String[] lines) {
        return ExpressionHelper.indentationOf(Arrays.stream(lines).filter(l -> l.endsWith(";") && Character.isWhitespace(l.charAt(0))).findFirst().orElse(""));
    }

    private static String indentationOf(String line) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (Character.isWhitespace(line.charAt(i))) {
            sb.append(line.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    private static String rawExpressionOf(Expression expr) {
        try {
            List expression = (List)expr.core$().variables().get("expression");
            return (String)expression.get(0);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot read expression of " + expr.name$());
        }
    }

    private static List<Frame> parametersOf(Expression expr, String ontologyPackage) {
        if (expr.isGetter()) {
            return Collections.emptyList();
        }
        return expr.core$().componentList().stream().filter(c -> c.is(Expression.Function.Parameter.class) || c.is(Expression.Routine.Parameter.class)).map(c -> ExpressionHelper.frameOfParameter((EntityData)c.as(EntityData.class), ontologyPackage)).collect(Collectors.toList());
    }

    private static Frame frameOfParameter(EntityData data, String ontologyPackage) {
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter"});
        builder.add("type", (Object)ExpressionHelper.type(new ConceptAttribute(data, null), ontologyPackage));
        builder.add("name", (Object)data.name$());
        return builder.toFrame();
    }

    private static String returnTypeOf(Expression expr, String ontologyPackage) {
        if (expr.isFunction()) {
            return ExpressionHelper.type(new ConceptAttribute(expr.asFunction().returnType(), expr.core$()), ontologyPackage);
        }
        if (expr.isDoubleGetter()) {
            return "Double";
        }
        if (expr.isIntegerGetter()) {
            return "Integer";
        }
        if (expr.isLongGetter()) {
            return "Long";
        }
        if (expr.isBooleanGetter()) {
            return "Boolean";
        }
        if (expr.isTextGetter()) {
            return "String";
        }
        if (expr.isDateGetter()) {
            return "LocalDate";
        }
        if (expr.isDateTimeGetter()) {
            return "LocalDateTime";
        }
        if (expr.isInstantGetter()) {
            return "Instant";
        }
        return "void";
    }

    private static String type(ConceptAttribute attr, String ontologyPackage) {
        Object type = attr.type();
        if (attr.isEntity()) {
            type = ontologyPackage + ".entities." + (String)type;
        } else if (attr.isStruct()) {
            type = ontologyPackage + ".structs." + (String)type;
        } else if (attr.isWord()) {
            type = Formatters.firstUpperCase((String)type);
        }
        if (attr.isList()) {
            return "List<" + (String)type + ">";
        }
        if (attr.isSet()) {
            return "Set<" + (String)type + ">";
        }
        return type;
    }
}

