/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.ontology;

import io.intino.Configuration;
import io.intino.datahub.model.NessGraph;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.datahubterminalplugin.ArtifactoryConnector;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.PomTemplate;
import io.intino.ness.datahubterminalplugin.ontology.OntologyRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class OntologyPublisher {
    private final File root;
    private final NessGraph graph;
    private final Configuration conf;
    private final List<File> sourceDirectories;
    private final Map<String, String> versions;
    private final PluginLauncher.SystemProperties systemProperties;
    private final String basePackage;
    private final PluginLauncher.Phase invokedPhase;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private final StringBuilder errorStream;

    public OntologyPublisher(File root, NessGraph graph, Configuration configuration, PluginLauncher.ModuleStructure moduleStructure, Map<String, String> versions, PluginLauncher.SystemProperties systemProperties, PluginLauncher.Phase invokedPhase, PrintStream logger, PluginLauncher.Notifier notifier) {
        this.root = root;
        this.graph = graph;
        this.conf = configuration;
        this.sourceDirectories = moduleStructure.sourceDirectories;
        this.versions = versions;
        this.systemProperties = systemProperties;
        this.basePackage = configuration.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifact().name()).toString().toLowerCase();
        this.invokedPhase = invokedPhase;
        this.logger = logger;
        this.notifier = notifier;
        this.errorStream = new StringBuilder();
    }

    public boolean publish() {
        try {
            if (this.invokedPhase.equals((Object)PluginLauncher.Phase.DISTRIBUTE) && !this.isSnapshotVersion() && this.isDistributed(this.conf.artifact())) {
                this.logger.println("This Version Already Exists");
                this.notifier.notifyError("The Version " + this.conf.artifact().version() + " is Already Distributed.");
                return false;
            }
            if (!new OntologyRenderer(this.graph, this.conf, this.sourceDirectory(), this.basePackage, this.logger, this.notifier).render()) {
                return false;
            }
            this.logger.println("Publishing ontology...");
            this.mvn(this.invokedPhase == PluginLauncher.Phase.INSTALL ? "install" : "deploy");
            this.logger.println("Ontology published!");
        }
        catch (Exception e) {
            this.logger.println(e.getMessage());
            this.logger.println(this.errorStream.toString());
            return false;
        }
        return true;
    }

    private boolean isDistributed(Configuration.Artifact artifact) {
        String identifier = this.basePackage + ":ontology";
        if (artifact.distribution() == null) {
            return false;
        }
        List<String> versions = ArtifactoryConnector.versions(artifact.distribution().release(), identifier);
        return versions.contains(artifact.version());
    }

    private File sourceDirectory() {
        return new File(this.root, "src");
    }

    private void mvn(String goal) throws IOException, MavenInvocationException {
        File pom = this.createPom(this.root, this.basePackage, this.conf.artifact().version());
        InvocationResult result = this.invoke(pom, goal);
        if (result != null && result.getExitCode() != 0) {
            this.fail(result);
        } else if (result == null) {
            throw new IOException("Failed to publish accessor. Maven HOME not found");
        }
    }

    private void fail(InvocationResult result) throws IOException {
        this.logger.println(this.errorStream.toString());
        if (result.getExecutionException() != null) {
            throw new IOException("Failed to publish accessor.", (Throwable)result.getExecutionException());
        }
        throw new IOException("Failed to publish accessor. Exit code: " + result.getExitCode());
    }

    private InvocationResult invoke(File pom, String goal) throws MavenInvocationException {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        if (!goal.isEmpty()) {
            goals.add(goal);
        }
        InvocationRequest request = new DefaultInvocationRequest().setPomFile(pom).setGoals(goals);
        request.setInputStream(InputStream.nullInputStream());
        Invoker invoker = new DefaultInvoker().setMavenHome(this.systemProperties.mavenHome);
        this.log(request);
        this.config(request, this.systemProperties.mavenHome);
        return invoker.execute(request);
    }

    private void log(InvocationRequest request) {
        request.setErrorHandler(this.logger::println);
        request.setOutputHandler(s -> this.errorStream.append(s).append("\n"));
    }

    private void config(InvocationRequest request, File mavenHome) {
        File mvn = new File(mavenHome, "bin" + File.separator + "mvn");
        mvn.setExecutable(true);
        request.setJavaHome(this.systemProperties.javaHome);
    }

    private File createPom(File root, String group, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)"ontology").add("version", (Object)version);
        this.conf.repositories().forEach(r -> this.buildRepoFrame(builder, (Configuration.Repository)r));
        if (this.conf.artifact().distribution() != null) {
            if (this.isSnapshotVersion()) {
                this.buildDistroFrame(builder, this.conf.artifact().distribution().snapshot());
            } else {
                this.buildDistroFrame(builder, this.conf.artifact().distribution().release());
            }
        }
        this.addSourceDirectories(builder);
        this.addDependencies(builder);
        File pomFile = new File(root, "pom.xml");
        Commons.write(pomFile.toPath(), new PomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    private void addDependencies(FrameBuilder builder) {
        builder.add("event", (Object)new FrameBuilder().add("version", (Object)this.versions.get("event")));
        builder.add("master", (Object)new FrameBuilder().add("version", (Object)this.versions.get("master")));
        builder.add("chronos", (Object)new FrameBuilder().add("version", (Object)this.versions.get("chronos")));
    }

    private void addSourceDirectories(FrameBuilder builder) {
        builder.add("sourceDirectory", (Object)this.sourceDirectory().getAbsolutePath());
        for (File sourceDirectory : this.sourceDirectories) {
            if (!sourceDirectory.getName().equals("shared")) continue;
            builder.add("sourceDirectory", (Object)sourceDirectory.getAbsolutePath());
        }
    }

    private boolean dependsOnMaster() {
        return !this.graph.datamartList().isEmpty();
    }

    private boolean dependsOnChronos() {
        return this.graph.datamartList().stream().anyMatch(d -> !d.timelineList().isEmpty() || !d.reelList().isEmpty());
    }

    private boolean isSnapshotVersion() {
        return this.conf.artifact().version().contains("SNAPSHOT");
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).toFrame());
    }

    private void buildDistroFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).add("distribution").toFrame());
    }

    private FrameBuilder createRepositoryFrame(Configuration.Repository repository) {
        return new FrameBuilder(new String[]{"repository", repository.getClass().getSimpleName()}).add("name", (Object)repository.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repository.url());
    }
}

