/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.measurement;

import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Sensor;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.measurement.MeasurementTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MeasurementRenderer {
    private final Sensor sensor;
    private final File destination;
    private final String rootPackage;

    public MeasurementRenderer(Sensor sensor, File destination, String rootPackage) {
        this.sensor = sensor;
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render() {
        String rootPackage = this.rootPackage();
        File packageFolder = new File(this.destination, rootPackage.replace(".", File.separator));
        Frame frame = this.createMeasurementFrame(this.sensor, rootPackage);
        Commons.writeFrame(packageFolder, this.sensor.name$(), this.template().render((Object)frame));
    }

    private Frame createMeasurementFrame(Sensor sensor, String packageName) {
        FrameBuilder eventFrame = new FrameBuilder(new String[]{"measurement"}).add("name", (Object)sensor.name$()).add("size", (Object)sensor.magnitudeList().size()).add("package", (Object)packageName);
        ArrayList<Frame> list = new ArrayList<Frame>();
        List magnitudes = sensor.magnitudeList();
        for (int i = 0; i < magnitudes.size(); ++i) {
            list.add(MeasurementRenderer.frame(sensor.name$(), (Sensor.Magnitude)magnitudes.get(i), i));
        }
        eventFrame.add("value", (Object)list.toArray(new Frame[0]));
        return eventFrame.toFrame();
    }

    private static Frame frame(String measurement, Sensor.Magnitude magnitude, int i) {
        FrameBuilder fb = new FrameBuilder(new String[]{"value"}).add("index", (Object)i).add("id", (Object)magnitude.id()).add("name", (Object)magnitude.name$()).add("owner", (Object)measurement);
        if (!magnitude.attributeList().isEmpty()) {
            fb.add("attribute", (Object)MeasurementRenderer.toString(magnitude.attributeList()));
        }
        return fb.toFrame();
    }

    private static String[] toString(List<Sensor.Magnitude.Attribute> attributes) {
        return (String[])attributes.stream().map(a -> a.name$() + "=" + a.value()).toArray(String[]::new);
    }

    private String rootPackage() {
        Object rootPackage = this.measurementsPackage();
        if (this.sensor.core$().owner().is(Namespace.class)) {
            rootPackage = (String)rootPackage + "." + ((Namespace)this.sensor.core$().ownerAs(Namespace.class)).qn();
        }
        return rootPackage;
    }

    private String measurementsPackage() {
        return this.rootPackage + ".measurements";
    }

    private Template template() {
        return Formatters.customize(new MeasurementTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

