/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.Configuration;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Reel;
import io.intino.datahub.model.Struct;
import io.intino.datahub.model.Terminal;
import io.intino.datahub.model.Timeline;
import io.intino.datahub.model.rules.SnapshotScale;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Node;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.AttributesTemplate;
import io.intino.ness.datahubterminalplugin.master.ConceptAttribute;
import io.intino.ness.datahubterminalplugin.master.ConceptRenderer;
import io.intino.ness.datahubterminalplugin.master.DatamartTemplate;
import io.intino.ness.datahubterminalplugin.master.EntityBaseTemplate;
import io.intino.ness.datahubterminalplugin.master.EntityFrameFactory;
import io.intino.ness.datahubterminalplugin.master.EntityMounterFrameFactory;
import io.intino.ness.datahubterminalplugin.master.EntityMounterTemplate;
import io.intino.ness.datahubterminalplugin.master.EntityTemplate;
import io.intino.ness.datahubterminalplugin.master.NodeImplTemplate;
import io.intino.ness.datahubterminalplugin.master.StructBaseTemplate;
import io.intino.ness.datahubterminalplugin.master.StructFrameFactory;
import io.intino.ness.datahubterminalplugin.master.StructTemplate;
import io.intino.ness.datahubterminalplugin.util.ErrorUtils;
import io.intino.plugin.PluginLauncher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DatamartsRenderer
implements ConceptRenderer {
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private final File srcFolder;
    private final NessGraph model;
    private final Configuration conf;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private String modelPackage;
    private final Templates templates;

    public DatamartsRenderer(File srcDir, NessGraph model, Configuration conf, PrintStream logger, PluginLauncher.Notifier notifier, String basePackage) {
        this.srcFolder = srcDir;
        this.model = model;
        this.conf = conf;
        this.logger = logger;
        this.notifier = notifier;
        this.srcFolder.mkdirs();
        this.modelPackage = basePackage;
        this.templates = new Templates();
    }

    public void render(Terminal terminal, String terminalPackage) {
        TerminalInfo terminalInfo = new TerminalInfo(terminal, terminalPackage);
        String basePackage = this.modelPackage + ".datamarts";
        for (Datamart datamart : terminal.datamarts().list()) {
            this.modelPackage = basePackage + DOT + datamart.name$().toLowerCase();
            this.renderDatamart(datamart, terminalInfo);
        }
    }

    private void renderDatamart(Datamart datamart, TerminalInfo terminalInfo) {
        try {
            this.write(this.renderImplementationOf(datamart, terminalInfo));
            this.write(this.entityMounterClassesOf(datamart, terminalInfo));
        }
        catch (Throwable e) {
            this.notifier.notifyError("Error during java className generation: " + ErrorUtils.getMessage(e));
            throw new RuntimeException(e);
        }
    }

    public void render() {
        String basePackage = this.modelPackage + ".datamarts";
        for (Datamart datamart : this.model.datamartList()) {
            this.modelPackage = basePackage + DOT + datamart.name$().toLowerCase();
            this.renderDatamart(datamart);
            this.renderOntologyClassesOf(datamart);
        }
    }

    private void renderDatamart(Datamart datamart) {
        try {
            this.write(this.renderInterfaceOf(datamart));
        }
        catch (Throwable e) {
            this.notifier.notifyError("Error during java className generation: " + ErrorUtils.getMessage(e));
            throw new RuntimeException(e);
        }
    }

    private void renderOntologyClassesOf(Datamart datamart) {
        try {
            this.logger.println("Rendering entities and structs of " + datamart.name$() + "...");
            this.write(this.structClassesOf(datamart));
            this.write(this.entityClassesOf(datamart));
        }
        catch (Exception e) {
            this.notifier.notifyError("Error during java className generation: " + ErrorUtils.getMessage(e));
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> entityMounterClassesOf(Datamart datamart, TerminalInfo terminalInfo) {
        HashMap<String, String> outputs = new HashMap<String, String>();
        outputs.put(this.destination(this.baseEntityMounterName(datamart, terminalInfo)), this.templates.entityMounter.render((Object)this.entityMounterInterface(datamart, terminalInfo)));
        datamart.entityList().forEach(e -> outputs.putAll(this.renderEntityMounter((Entity)e, datamart, terminalInfo)));
        return outputs;
    }

    private String baseEntityMounterName(Datamart datamart, TerminalInfo terminalInfo) {
        return terminalInfo.terminalPackage + DOT + this.subPackageOf(datamart) + DOT + this.firstUpperCase(datamart.name$()) + "Mounter";
    }

    private FrameBuilder entityMounterInterface(Datamart datamart, TerminalInfo terminalInfo) {
        return new FrameBuilder(new String[]{"mounter", "interface"}).add("package", (Object)(terminalInfo.terminalPackage + this.subPackageOf(datamart))).add("ontologypackage", (Object)this.modelPackage).add("datamart", (Object)datamart.name$());
    }

    private String subPackageOf(Datamart datamart) {
        return ".datamarts." + Formatters.javaValidName().format((Object)datamart.name$().toLowerCase());
    }

    private Map<String, String> entityClassesOf(Datamart datamart) {
        HashMap<String, String> outputs = new HashMap<String, String>();
        this.renderEntityBase(datamart, outputs);
        datamart.entityList().forEach(e -> outputs.putAll(this.renderEntity((Entity)e, datamart)));
        return outputs;
    }

    private void renderEntityBase(Datamart datamart, Map<String, String> outputs) {
        outputs.put(this.entityDestination(this.entityBaseName(datamart)), this.templates.entityBase.render((Object)this.entityBaseBuilder(datamart)));
    }

    private String entityBaseName(Datamart datamart) {
        return this.modelPackage + DOT + Formatters.javaValidName().format((Object)(this.firstUpperCase(datamart.name$()) + "Entity")).toString();
    }

    private FrameBuilder entityBaseBuilder(Datamart datamart) {
        return new FrameBuilder(new String[]{"entity", "base"}).add("package", (Object)this.modelPackage).add("datamart", (Object)datamart.name$());
    }

    private Map<String, String> structClassesOf(Datamart datamart) {
        HashMap<String, String> output = new HashMap<String, String>();
        this.renderStructBase(datamart, output);
        datamart.structList().stream().map(struct -> this.renderStruct(datamart, (Struct)struct)).forEach(output::putAll);
        return output;
    }

    private void renderStructBase(Datamart datamart, Map<String, String> output) {
        output.put(this.destination(this.structBaseName(datamart)), this.templates.structBase.render((Object)this.structBaseBuilder(datamart)));
    }

    private String structBaseName(Datamart datamart) {
        return this.modelPackage + DOT + Formatters.javaValidName().format((Object)(this.firstUpperCase(datamart.name$()) + "Struct")).toString();
    }

    private FrameBuilder structBaseBuilder(Datamart datamart) {
        return new FrameBuilder(new String[]{"struct", "base"}).add("package", (Object)this.modelPackage).add("datamart", (Object)datamart.name$());
    }

    private Map<String, String> renderInterfaceOf(Datamart datamart) {
        String theInterface = this.modelPackage + DOT + this.firstUpperCase(Formatters.javaValidName().format((Object)(datamart.name$() + "Datamart")).toString());
        return Map.of(this.destination(theInterface), this.templates.datamart.render((Object)this.datamartInterfaceBuilder(datamart).toFrame()));
    }

    private Map<String, String> renderImplementationOf(Datamart datamart, TerminalInfo terminalInfo) {
        String theImplementation = this.modelPackage + DOT + this.firstUpperCase(Formatters.javaValidName().format((Object)(datamart.name$() + "DatamartImpl")).toString());
        return Map.of(this.destination(theImplementation), this.templates.datamart.render((Object)this.datamartImplBuilder(datamart, terminalInfo).toFrame()));
    }

    private FrameBuilder datamartInterfaceBuilder(Datamart datamart) {
        FrameBuilder builder = new FrameBuilder(new String[]{"datamart", "interface"});
        builder.add("package", (Object)this.modelPackage);
        builder.add("name", (Object)this.firstUpperCase(datamart.name$()));
        builder.add("entity", (Object)this.entitiesOf(datamart));
        if (!datamart.timelineList().isEmpty()) {
            builder.add("hasTimelines", (Object)"");
            builder.add("timeline", (Object)this.timelinesOf(datamart));
        }
        if (!datamart.reelList().isEmpty()) {
            builder.add("hasReels", (Object)"");
            builder.add("reel", (Object)this.reelsOf(datamart));
        }
        return builder;
    }

    private Frame reelNode() {
        FrameBuilder b = new FrameBuilder(new String[]{"reelNode", "default"});
        b.add("chronosObject", (Object)"Reel");
        return b.toFrame();
    }

    private String reelEvents(Datamart datamart) {
        return datamart.reelList().stream().flatMap(r -> r.signalList().stream()).map(s -> Formatters.quoted().format((Object)s.tank().message().name$()).toString()).distinct().collect(Collectors.joining(","));
    }

    private Frame[] reelsOf(Datamart datamart) {
        return (Frame[])datamart.reelList().stream().map(this::reelFrame).toArray(Frame[]::new);
    }

    private Frame reelFrame(Reel reel) {
        FrameBuilder b = new FrameBuilder(new String[]{"reel"});
        b.add("package", (Object)this.modelPackage);
        b.add("name", (Object)this.firstUpperCase(reel.name$()));
        b.add("sources", (Object)this.sourcesOf(reel));
        b.add("entity", (Object)this.firstUpperCase(reel.entity().name$()));
        return b.toFrame();
    }

    private String sourcesOf(Reel reel) {
        Set sources = reel.signalList().stream().map(s -> Formatters.quoted().format((Object)s.tank().message().name$()).toString()).collect(Collectors.toSet());
        if (reel.entity() != null && reel.entity().from() != null) {
            sources.add(Formatters.quoted().format((Object)reel.entity().from().message().name$()).toString());
        }
        return String.join((CharSequence)",", sources);
    }

    private Frame timelineNode() {
        FrameBuilder b = new FrameBuilder(new String[]{"timelineNode", "default"});
        b.add("chronosObject", (Object)"Timeline");
        return b.toFrame();
    }

    private String timelineEvents(Datamart datamart) {
        return datamart.timelineList().stream().map(t -> Formatters.quoted().format((Object)t.tank().sensor().name$()).toString()).collect(Collectors.joining(","));
    }

    private Frame[] timelinesOf(Datamart datamart) {
        return (Frame[])datamart.timelineList().stream().map(this::timelineFrame).toArray(Frame[]::new);
    }

    private Frame timelineFrame(Timeline timeline) {
        FrameBuilder b = new FrameBuilder(new String[]{"timeline"});
        b.add("package", (Object)this.modelPackage);
        b.add("name", (Object)this.firstUpperCase(timeline.name$()));
        b.add("sources", (Object)this.sourcesOf(timeline));
        b.add("entity", (Object)this.firstUpperCase(timeline.entity().name$()));
        return b.toFrame();
    }

    private String sourcesOf(Timeline timeline) {
        String sensor = Formatters.quoted().format((Object)timeline.tank().sensor().name$()).toString();
        if (timeline.entity() != null && timeline.entity().from() != null) {
            return sensor + "," + Formatters.quoted().format((Object)timeline.entity().from().message().name$()).toString();
        }
        return sensor;
    }

    private FrameBuilder datamartImplBuilder(Datamart datamart, TerminalInfo terminalInfo) {
        FrameBuilder builder = new FrameBuilder(new String[]{"datamart", "message", "impl"});
        builder.add("package", (Object)(terminalInfo.terminalPackage + this.subPackageOf(datamart)));
        Datamart.Snapshots snapshots = datamart.snapshots();
        builder.add("name", (Object)datamart.name$()).add("scale", (Object)(snapshots == null || snapshots.scale() == null ? SnapshotScale.None.name() : snapshots.scale().name()));
        builder.add("entity", (Object)this.entitiesOf(datamart));
        builder.add("struct", (Object)this.structsOf(datamart));
        builder.add("numEntities", (Object)datamart.entityList().size());
        builder.add("numStructs", (Object)datamart.structList().size());
        builder.add("ontologypackage", (Object)this.modelPackage);
        builder.add("terminal", (Object)String.format(terminalInfo.terminalPackage + DOT + this.firstUpperCase(Formatters.javaValidName().format((Object)terminalInfo.terminal.name$()).toString()), new Object[0]));
        if (!datamart.timelineList().isEmpty()) {
            builder.add("hasTimelines", (Object)"");
            builder.add("timelineEvents", (Object)this.timelineEvents(datamart));
            builder.add("timeline", (Object)this.timelinesOf(datamart));
            builder.add("timelineNode", (Object)this.timelineNode());
        }
        if (!datamart.reelList().isEmpty()) {
            builder.add("hasReels", (Object)"");
            builder.add("reelEvents", (Object)this.reelEvents(datamart));
            builder.add("reel", (Object)this.reelsOf(datamart));
            builder.add("reelNode", (Object)this.reelNode());
        }
        return builder;
    }

    private Frame[] structsOf(Datamart datamart) {
        List structFrames = datamart.structList().stream().flatMap(struct -> this.framesOf((Struct)struct, this.modelPackage + ".structs", null)).collect(Collectors.toList());
        for (Entity entity : datamart.entityList()) {
            entity.structList().stream().flatMap(struct -> this.framesOf((Struct)struct, this.modelPackage + ".entities." + entity.name$(), entity.name$())).forEach(structFrames::add);
        }
        return (Frame[])structFrames.toArray(Frame[]::new);
    }

    private Stream<Frame> framesOf(Struct struct, String thePackage, String owner) {
        final String fullname = owner == null ? this.fullNameOf(struct) : owner + "$" + this.fullNameOf(struct);
        FrameBuilder b = new FrameBuilder(new String[]{"struct"});
        b.add("package", (Object)thePackage);
        b.add("name", (Object)this.firstUpperCase(struct.name$()));
        b.add("fullName", (Object)fullname);
        b.add("attribute", (Object)this.attributeFrames(this.attributesOf(struct, (Object a, Node o) -> new ConceptAttribute(a, (Node)o){

            @Override
            public String ownerFullName() {
                return fullname.replace("$", DatamartsRenderer.DOT);
            }
        })));
        ArrayList<Frame> frames = new ArrayList<Frame>(1);
        frames.add(b.toFrame());
        for (Struct s : struct.structList()) {
            this.framesOf(s, thePackage + DOT + struct.name$(), fullname).forEach(frames::add);
        }
        return frames.stream();
    }

    private Frame[] entitiesOf(Datamart datamart) {
        return (Frame[])datamart.entityList().stream().map(entity -> {
            FrameBuilder b = new FrameBuilder(new String[]{"entity"}).add("package", (Object)this.modelPackage);
            b.add("name", (Object)this.firstUpperCase(entity.name$())).add("fullName", (Object)this.fullNameOf((Entity)entity));
            b.add("attribute", (Object)this.attributeFrames(this.attributesOf((Entity)entity)));
            if (entity.from() != null) {
                b.add("event", (Object)this.firstUpperCase(entity.from().message().name$()));
            }
            if (entity.isExtensionOf()) {
                b.add("parent", (Object)entity.asExtensionOf().entity().name$());
                b.add("ancestor", (Object)this.ancestorsOf((Entity)entity));
            } else {
                b.add("hasNoParents", (Object)"true");
            }
            if (entity.isAbstract()) {
                b.add("abstract");
            }
            b.add("isAbstract", (Object)entity.isAbstract());
            this.setDescendantsInfo(datamart, (Entity)entity, b);
            return b.toFrame();
        }).toArray(Frame[]::new);
    }

    @Override
    public List<ConceptAttribute> attributesOf(Entity entity) {
        List<ConceptAttribute> attributes = ConceptRenderer.super.attributesOf(entity);
        entity.structList().stream().map(struct -> this.attrOf(entity.core$(), (Struct)struct)).forEach(attributes::add);
        return attributes;
    }

    @Override
    public List<ConceptAttribute> attributesOf(Struct struct) {
        List<ConceptAttribute> attributes = ConceptRenderer.super.attributesOf(struct);
        struct.structList().stream().map(s -> this.attrOf(struct.core$(), (Struct)s)).forEach(attributes::add);
        return attributes;
    }

    private void setDescendantsInfo(Datamart datamart, Entity entity, FrameBuilder b) {
        Entity[] descendants = this.descendantsOf(entity, datamart);
        if (descendants.length == 0) {
            return;
        }
        b.add("superclass");
        b.add("descendant", Arrays.stream(descendants).map(e -> new FrameBuilder(new String[]{"descendant"}).add("entity").add("name", (Object)e.name$()).toFrame()).toArray(Frame[]::new));
        b.add("subclass", (Object)this.framesOfUpperLevelDescendants(entity, datamart));
    }

    private Frame[] ancestorsOf(Entity entity) {
        ArrayList<Frame> ancestors = new ArrayList<Frame>();
        Entity parent = entity.asExtensionOf().entity();
        while (parent != null) {
            ancestors.add(new FrameBuilder(new String[]{"ancestor", "entity"}).add("name", (Object)parent.name$()).toFrame());
            parent = parent.isExtensionOf() ? parent.asExtensionOf().entity() : null;
        }
        return (Frame[])ancestors.toArray(Frame[]::new);
    }

    private Frame[] attributeFrames(List<ConceptAttribute> attributes) {
        return (Frame[])attributes.stream().map(this::attributeFrameBuilder).map(FrameBuilder::toFrame).toArray(Frame[]::new);
    }

    private FrameBuilder attributeFrameBuilder(ConceptAttribute attr) {
        FrameBuilder b = new FrameBuilder(new String[]{"attribute"});
        if (attr.isList() || attr.isSet()) {
            this.setAttribCollectionInfo(attr, b);
        } else if (attr.isMap()) {
            b.add("type", (Object)"java.util.Map").add("collection").add("parameterTypeName", (Object)"java.lang.String").add("parameterType", (Object)"java.lang.String");
            b.add("parameter", (Object)new FrameBuilder(new String[]{"parameter"}));
        } else if (attr.isEntity()) {
            b.add("type", (Object)(this.modelPackage + ".entities." + attr.asEntity().entity().name$()));
        } else if (attr.isStruct()) {
            b.add("type", (Object)(this.modelPackage + ".entities." + attr.ownerFullName() + DOT + attr.asStruct().name$()));
        } else if (attr.isWord()) {
            b.add("type", (Object)(this.modelPackage + ".entities." + attr.ownerFullName() + DOT + attr.type()));
        } else {
            b.add("type", (Object)attr.type());
        }
        b.add("name", (Object)attr.name$());
        if (attr.inherited()) {
            b.add("inherited");
        }
        return b;
    }

    private void setAttribCollectionInfo(ConceptAttribute attr, FrameBuilder b) {
        b.add("type", (Object)(attr.isList() ? "java.util.List" : "java.util.Set"));
        b.add("collection");
        Object parameterType = attr.type();
        String parameterTypeName = parameterType;
        if (attr.isEntity()) {
            parameterType = this.modelPackage + ".entities." + this.firstUpperCase(attr.asEntity().entity().name$());
            parameterTypeName = this.firstUpperCase(attr.asEntity().entity().name$());
        } else if (attr.isStruct()) {
            parameterType = this.modelPackage + ".entities." + attr.ownerFullName() + DOT + this.firstUpperCase(attr.asStruct().name$());
            parameterTypeName = this.firstUpperCase(attr.asStruct().name$());
        } else if (attr.isWord()) {
            parameterType = this.modelPackage + ".entities." + this.firstUpperCase(attr.owner().name()) + DOT + (String)parameterType;
        }
        b.add("parameterType", parameterType);
        b.add("parameterTypeName", (Object)parameterTypeName);
        FrameBuilder param = new FrameBuilder(new String[]{"parameter"});
        if (attr.isEntity()) {
            param.add("entity");
        } else if (attr.isStruct()) {
            param.add("struct");
        } else if (attr.isWord()) {
            param.add("word");
        }
        if (attr.isStruct()) {
            param.add("name", (Object)(attr.ownerFullName() + "$" + this.firstUpperCase(attr.asStruct().name$())));
        } else {
            param.add("name", (Object)parameterTypeName);
        }
        b.add("parameter", (Object)param);
    }

    private String firstUpperCase(String name) {
        return Formatters.firstUpperCase(name);
    }

    private String fullNameOf(Entity e) {
        if (!e.isExtensionOf()) {
            return this.firstUpperCase(e.name$());
        }
        ArrayList<String> names = new ArrayList<String>(4);
        Entity parent = e.asExtensionOf().entity();
        while (parent != null) {
            names.add(this.firstUpperCase(parent.name$()));
            parent = parent.isExtensionOf() ? parent.asExtensionOf().entity() : null;
        }
        Collections.reverse(names);
        names.add(this.firstUpperCase(e.name$()));
        return String.join((CharSequence)DOT, names);
    }

    private String fullNameOf(Struct s) {
        return this.firstUpperCase(s.name$());
    }

    private Frame[] framesOfUpperLevelDescendants(Entity parent, Datamart datamart) {
        return (Frame[])Arrays.stream(this.upperLevelDescendantsOf(parent, datamart)).map(c -> new FrameBuilder(new String[]{"subclass"}).add("package", (Object)(this.modelPackage + ".master")).add("name", (Object)c.name$()).toFrame()).toArray(Frame[]::new);
    }

    private Entity[] descendantsOf(Entity parent, Datamart datamart) {
        return (Entity[])datamart.entityList(e -> DatamartsRenderer.isDescendantOf(e, parent)).toArray(Entity[]::new);
    }

    private Entity[] upperLevelDescendantsOf(Entity parent, Datamart datamart) {
        ArrayList<Entity> upperLevelDescendants = new ArrayList<Entity>();
        for (Entity entity : datamart.entityList(e -> DatamartsRenderer.isDescendantOf(e, parent) && !e.isAbstract())) {
            if (this.anAncestorOfThisEntityIsAlreadyPresent(entity, upperLevelDescendants)) continue;
            this.removeAnyDescendantOfThisEntityIfPresent(entity, upperLevelDescendants);
            upperLevelDescendants.add(entity);
        }
        return upperLevelDescendants.toArray(new Entity[0]);
    }

    private boolean anAncestorOfThisEntityIsAlreadyPresent(Entity entity, List<Entity> upperLevelDescendants) {
        return upperLevelDescendants.stream().anyMatch(ancestor -> DatamartsRenderer.isDescendantOf(entity, ancestor));
    }

    private void removeAnyDescendantOfThisEntityIfPresent(Entity ancestor, List<Entity> upperLevelDescendants) {
        upperLevelDescendants.removeIf(e -> DatamartsRenderer.isDescendantOf(e, ancestor));
    }

    private static boolean isDescendantOf(Entity node, Entity expectedParent) {
        if (!node.isExtensionOf()) {
            return false;
        }
        Entity parent = node.asExtensionOf().entity();
        return parent.equals(expectedParent) || DatamartsRenderer.isDescendantOf(parent, expectedParent);
    }

    private Map<String, String> renderEntity(Entity entity, Datamart datamart) {
        return new EntityFrameFactory(this.modelPackage, datamart).create(entity).entrySet().stream().collect(Collectors.toMap(e -> this.entityDestination((String)e.getKey()), e -> this.templates.entity.render(e.getValue())));
    }

    private Map<String, String> renderStruct(Datamart datamart, Struct struct) {
        return new StructFrameFactory(datamart, this.modelPackage).create(struct).entrySet().stream().collect(Collectors.toMap(e -> this.destination((String)e.getKey()), e -> this.templates.struct.render(e.getValue())));
    }

    private Map<String, String> renderEntityMounter(Entity entity, Datamart datamart, TerminalInfo terminalInfo) {
        return new EntityMounterFrameFactory(terminalInfo.terminalPackage + this.subPackageOf(datamart), this.modelPackage, datamart).create(entity).entrySet().stream().collect(Collectors.toMap(e -> this.entityDestination((String)e.getKey()), e -> this.templates.entityMounter.render(e.getValue())));
    }

    private void write(Map<String, String> outputsMap) {
        outputsMap.forEach((key, value) -> {
            File file = new File((String)key);
            if (value.isEmpty() || this.isUnderSource(file) && file.exists()) {
                return;
            }
            file.getParentFile().mkdirs();
            this.write(file, (String)value);
        });
    }

    private boolean isUnderSource(File file) {
        return file.getAbsolutePath().startsWith(this.srcFolder.getAbsolutePath());
    }

    private void write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
            fileWriter.write(text);
            fileWriter.close();
        }
        catch (IOException e) {
            this.notifier.notifyError(e.getMessage());
        }
    }

    private String destination(String path) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String entityDestination(String path) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    @Override
    public Datamart datamart() {
        return null;
    }

    @Override
    public String workingPackage() {
        return null;
    }

    private static class Templates {
        final Template datamart = Templates.append(Formatters.customize(new DatamartTemplate()), Formatters.customize(new NodeImplTemplate()));
        final Template entityBase = Formatters.customize(new EntityBaseTemplate());
        final Template entity = Templates.append(Formatters.customize(new EntityTemplate()), Formatters.customize(new StructTemplate()), Formatters.customize(new AttributesTemplate()));
        final Template entityMounter = Formatters.customize(new EntityMounterTemplate());
        final Template struct = Formatters.customize(new StructTemplate());
        final Template structBase = Templates.append(Formatters.customize(new StructBaseTemplate()), Formatters.customize(new AttributesTemplate()));

        private Templates() {
        }

        private static Template append(Template t1, Template ... others) {
            final RuleSet rules = new RuleSet();
            Templates.addRulesOf(t1, rules);
            for (Template t : others) {
                Templates.addRulesOf(t, rules);
            }
            return new Template(){

                protected RuleSet ruleSet() {
                    return rules;
                }
            };
        }

        private static void addRulesOf(Template t, RuleSet rules) {
            try {
                Method method = t.getClass().getDeclaredMethod("ruleSet", new Class[0]);
                method.setAccessible(true);
                RuleSet ruleSet = (RuleSet)method.invoke((Object)t, new Object[0]);
                ruleSet.forEach(xva$0 -> rules.add(new Rule[]{xva$0}));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public record TerminalInfo(Terminal terminal, String terminalPackage) {
    }
}

