/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.Struct;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.ness.datahubterminalplugin.Formatters;
import java.lang.reflect.Method;
import java.util.List;

public class ConceptAttribute {
    private final Object attribute;
    private final Node owner;
    private boolean inherited;

    public ConceptAttribute(Object attribute, Node owner) {
        this.attribute = attribute;
        this.owner = owner;
    }

    public String ownerFullName() {
        return this.owner.name();
    }

    public boolean inherited() {
        return this.inherited;
    }

    public ConceptAttribute inherited(boolean inherited) {
        this.inherited = inherited;
        return this;
    }

    public <T extends Node> T owner() {
        return (T)this.owner;
    }

    public String name$() {
        return this.getOrDefault("name$", this.getOrDefault("name", null));
    }

    public List<Concept> conceptList() {
        return this.core$().conceptList();
    }

    public boolean isList() {
        return this.getOrDefault("isList", false);
    }

    public boolean isSet() {
        return this.getOrDefault("isSet", false);
    }

    public boolean isReal() {
        return this.getOrDefault("isReal", false);
    }

    public boolean isLongInteger() {
        return this.getOrDefault("isLongInteger", false);
    }

    public boolean isBool() {
        return this.getOrDefault("isBool", false);
    }

    public boolean isText() {
        return this.getOrDefault("isText", false);
    }

    public boolean isDouble() {
        return this.getOrDefault("isDouble", false);
    }

    public boolean isInteger() {
        return this.getOrDefault("isInteger", false);
    }

    public boolean isLong() {
        return this.getOrDefault("isLong", false);
    }

    public boolean isBoolean() {
        return this.getOrDefault("isBoolean", false);
    }

    public boolean isString() {
        return this.getOrDefault("isString", false);
    }

    public boolean isDate() {
        return this.getOrDefault("isDate", false);
    }

    public boolean isDateTime() {
        return this.getOrDefault("isDateTime", false);
    }

    public boolean isInstant() {
        return this.getOrDefault("isInstant", false);
    }

    public boolean isWord() {
        return this.getOrDefault("isWord", false);
    }

    public boolean isStruct() {
        return this.attribute instanceof Struct;
    }

    public boolean isEntity() {
        return this.getOrDefault("isEntity", false);
    }

    public boolean isMap() {
        return this.getOrDefault("isMap", false);
    }

    public <T extends Layer> T asWord() {
        return (T)((Layer)this.getOrDefault("asWord", null));
    }

    public Struct asStruct() {
        return this.getOrDefault("asStruct", null);
    }

    public EntityData.Entity asEntity() {
        return this.getOrDefault("asEntity", null);
    }

    public String type() {
        if (this.isLongInteger() || this.isLong()) {
            return "Long";
        }
        if (this.isBool() || this.isBoolean()) {
            return "Boolean";
        }
        if (this.isText() || this.isString()) {
            return "String";
        }
        if (this.isDouble() || this.isReal()) {
            return "Double";
        }
        if (this.isInteger()) {
            return "Integer";
        }
        if (this.isDate()) {
            return "LocalDate";
        }
        if (this.isDateTime()) {
            return "LocalDateTime";
        }
        if (this.isInstant()) {
            return "Instant";
        }
        if (this.isWord()) {
            return Formatters.firstUpperCase(this.asWord().name$());
        }
        if (this.isStruct()) {
            return Formatters.firstUpperCase(this.asStruct().name$());
        }
        if (this.isEntity()) {
            return Formatters.firstUpperCase(this.asEntity().entity().name$());
        }
        if (this.isMap()) {
            return "Map";
        }
        throw new RuntimeException("Unknown type of " + this.name$());
    }

    public Node core$() {
        Node node = this.getOrDefault("core$", null);
        return node != null ? node : (Node)this.attribute;
    }

    public boolean shouldAddPackageBeforeName() {
        return true;
    }

    private <T> T getOrDefault(String name, T defValue) {
        try {
            Method method = this.attribute.getClass().getMethod(name, new Class[0]);
            return (T)method.invoke(this.attribute, new Object[0]);
        }
        catch (Exception e) {
            return defValue;
        }
    }
}

