/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Node;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.ConceptAttribute;
import io.intino.ness.datahubterminalplugin.master.ConceptRenderer;
import io.intino.ness.datahubterminalplugin.master.Parameter;
import java.util.HashMap;
import java.util.Map;

public class EntityMounterFrameFactory
implements ConceptRenderer {
    private static final String DOT = ".";
    private final String destinationPackage;
    private final String ontologyPackage;
    private final Datamart datamart;

    public EntityMounterFrameFactory(String destinationPackage, String ontologyPackage, Datamart datamart) {
        this.destinationPackage = destinationPackage;
        this.ontologyPackage = ontologyPackage;
        this.datamart = datamart;
    }

    public Map<String, Frame> create(Entity entity) {
        if (entity.isAbstract()) {
            return new HashMap<String, Frame>(0);
        }
        return Map.of(this.getMounterPath(entity, this.destinationPackage), this.frameOf(entity).toFrame());
    }

    private FrameBuilder frameOf(Entity entity) {
        Parameter parent;
        FrameBuilder builder = new FrameBuilder(new String[]{"mounter"}).add("message").add("package", (Object)this.destinationPackage).add("ontologypackage", (Object)this.ontologyPackage).add("datamart", (Object)this.datamart.name$()).add("name", (Object)entity.core$().name()).add("attribute", this.attributesOf(entity).stream().map(this::attrFrameOf).toArray(FrameBuilder[]::new)).add("struct", entity.structList().stream().map(s -> this.structFrameOf((Struct)s, entity.name$())).toArray(FrameBuilder[]::new));
        if (!this.datamart.structList().isEmpty()) {
            builder.add("hasStructs", (Object)new FrameBuilder().add("package", (Object)this.destinationPackage));
        }
        builder.add("parent", (Object)((parent = this.parameter(entity.core$(), "entity")) != null ? ((Entity)parent.values().get(0)).name$() : "io.intino.ness.master.model.Entity"));
        builder.add("normalizeId", (Object)new FrameBuilder(new String[]{"normalizeId", entity.isAbstract() || entity.isDecorable() ? "abstract" : ""}).add("package", (Object)this.destinationPackage).add("name", (Object)entity.name$()).toFrame());
        if (entity.isDecorable() || entity.isAbstract()) {
            builder.add("isAbstract", (Object)"abstract");
        }
        if (entity.isDecorable()) {
            builder.add("abstract", (Object)"abstract");
        }
        return builder;
    }

    private FrameBuilder structFrameOf(Struct struct, String ownerName) {
        FrameBuilder builder = new FrameBuilder(new String[]{"struct"});
        if (struct.multiple()) {
            builder.add("multiple");
        }
        String fullName = ownerName + DOT + struct.name$();
        builder.add("name", (Object)(ownerName.replace(DOT, "$") + "$" + struct.name$()));
        builder.add("attribName", struct.multiple() ? struct.name$() + "List" : struct.name$());
        builder.add("fullName", (Object)fullName);
        builder.add("type", (Object)fullName);
        builder.add("package", (Object)(this.ontologyPackage + ".entities"));
        builder.add("attribute", this.attributesOf(struct, (Object attribute, Node owner) -> this.attributeFromStruct(attribute, (Node)owner, fullName)).stream().map(this::attrFrameOf).toArray(FrameBuilder[]::new));
        builder.add("struct", struct.structList().stream().map(s -> this.structFrameOf((Struct)s, fullName)).toArray(FrameBuilder[]::new));
        return builder;
    }

    private ConceptAttribute attributeFromStruct(Object o, Node node, final String fullName) {
        return new ConceptAttribute(o, node){

            @Override
            public String ownerFullName() {
                return fullName;
            }
        };
    }

    public FrameBuilder attrFrameOf(String fullName, ConceptAttribute attr) {
        FrameBuilder builder = ConceptRenderer.super.attrFrameOf(attr);
        if (attr.isWord()) {
            builder.add("type", (Object)(fullName + DOT + Formatters.firstUpperCase(attr.type())));
        }
        return builder;
    }

    @Override
    public Datamart datamart() {
        return this.datamart;
    }

    @Override
    public String workingPackage() {
        return this.ontologyPackage;
    }

    private String getMounterPath(Entity entity, String aPackage) {
        return aPackage + ".mounters." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)(entity.core$().name() + "Mounter")).toString());
    }
}

