/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.datamarts.nodes;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class IndicatorImplTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"indicatorNode", "default"}), new Rule.Condition[]{this.trigger("nodeimpl")}).output(new Rule.Output[]{this.literal("private class IndicatorNodeImpl implements IndicatorNode {\n\tprivate final String id;\n\tprivate volatile File file;\n\tprivate volatile boolean hasDirectAccessToFile;\n\n\tprivate IndicatorNodeImpl(String id, File file) {\n\t\tthis.id = requireNonNull(id);\n\t\tthis.file = file;\n\t\tthis.hasDirectAccessToFile = file != null;\n\t}\n\n\t@Override\n\tpublic boolean exists() {\n\t\ttry {\n\t\t\treturn get() != null;\n\t\t} catch(IndicatorNotAvailableException e) {\n\t\t\treturn false;\n\t\t}\n\t}\n\n\t@Override\n\tpublic Indicator get() throws IndicatorNotAvailableException {\n\t\tsynchronized(this) {\n\t\t\ttry {\n\t\t\t\tif (hasDirectAccessToFile) return loadFile(this.file);\n\t\t\t\treturn downloadFromDatahub();\n\t\t\t} catch(Exception e) {\n\t\t\t\tthrow new IndicatorNotAvailableException(e);\n\t\t\t}\n\t\t}\n\t}\n\n\tpublic Indicator loadFile(File file) throws IOException {\n\t\tMap<String, Indicator.Shot> shots;\n\t\tif (!file.exists()) return new Indicator(new HashMap<>());\n\t\ttry (var stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)))) {\n\t\t\tint size = stream.readInt();\n\t\t\tshots = new HashMap<>(size);\n\t\t\tfor (int i = 0; i < size; i++)\n\t\t\t\tshots.put(stream.readUTF(), new Indicator.Shot(Instant.ofEpochMilli(stream.readLong()), stream.readDouble()));\n\t\t}\n\t\treturn new Indicator(shots);\n\t}\n\n\tprivate Indicator downloadFromDatahub() throws Exception {\n\t\tjavax.jms.Message response = requestResponseFromDatahub(\"get-indicator=\" + id, request(\"download\"));\n\t\tif (!response.getBooleanProperty(\"success\")) throw new IndicatorNotAvailableException(\"Could not get indicator \" + id + \" because datahub returned success=false in the response\");\n\t\treturn readFromBytes((javax.jms.BytesMessage) response);\n\t}\n\n\tprivate Indicator readFromBytes(javax.jms.BytesMessage m) throws Exception {\n\t\tint messageSize = m.getIntProperty(\"size\");\n\t\tbyte[] bytes = new byte[messageSize];\n\t\tm.readBytes(bytes, messageSize);\n\t\tMap<String, Indicator.Shot> shots;\n\t\ttry (var stream = new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(bytes)))) {\n\t\t\tint size = stream.readInt();\n\t\t\tshots = new HashMap<>(size);\n\t\t\tfor (int i = 0; i < size; i++)\n\t\t\t\tshots.put(stream.readUTF(), new Indicator.Shot(Instant.ofEpochMilli(stream.readLong()), stream.readDouble()));\n\t\t}\n\t\treturn new Indicator(shots);\n\t}\n\n\tprivate javax.jms.Message request(String mode) throws Exception {\n\t\tActiveMQTextMessage message = new ActiveMQTextMessage();\n\t\tmessage.setText(\"datamart=\" + name() + \";operation=get-indicator;id=\" + id + \";mode=\" + mode);\n\t\treturn message;\n\t}\n}")})});
    }
}

