/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.datamarts;

import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Node;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.datamarts.ConceptRenderer;
import io.intino.ness.datahubterminalplugin.datamarts.ExpressionHelper;
import io.intino.ness.datahubterminalplugin.datamarts.Parameter;
import io.intino.ness.datahubterminalplugin.datamarts.StructFrameFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EntityFrameFactory
implements ConceptRenderer {
    private static final String DOT = ".";
    private final String workingPackage;
    private final Datamart datamart;

    public EntityFrameFactory(String workingPackage, Datamart datamart) {
        this.workingPackage = workingPackage;
        this.datamart = datamart;
    }

    public Map<String, Frame> create(Entity entity) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(2);
        map.put(this.calculateEntityPath(entity, this.workingPackage), this.frameOf(entity).toFrame());
        if (entity.isDecorable()) {
            map.put(this.calculateDecorableEntityPath(entity.core$(), this.workingPackage), this.frameOf(entity).add("decorable").toFrame());
        }
        return map;
    }

    private FrameBuilder frameOf(Entity entity) {
        Parameter parent;
        List<Struct> structList = EntityFrameFactory.structListOf(entity);
        FrameBuilder builder = new FrameBuilder(new String[]{"entity", "class"}).add("package", (Object)this.workingPackage).add("datamart", (Object)this.datamart.name$()).add("name", (Object)entity.core$().name()).add("expression", entity.methodList().stream().map(m -> ExpressionHelper.exprFrameOf((Expression)m, this.workingPackage)).toArray(Frame[]::new)).add("struct", structList.stream().map(s -> this.structFrame((Struct)s, entity)).toArray(Frame[]::new));
        List attributes = this.attributesOf(entity).stream().map(this::attrFrameOf).map(FrameBuilder::toFrame).collect(Collectors.toList());
        structList.stream().map(struct -> this.attrFrameOf(this.attrOf(entity.core$(), (Struct)struct)).toFrame()).forEach(attributes::add);
        builder.add("attribute", attributes.toArray(Frame[]::new));
        if (!this.datamart.structList().isEmpty()) {
            builder.add("hasStructs", (Object)new FrameBuilder().add("package", (Object)this.workingPackage));
        }
        builder.add("parent", (Object)((parent = this.parameter(entity.core$(), "entity")) != null ? this.withFullPackage(((Entity)parent.values().get(0)).name$()) : this.baseEntityName()));
        builder.add("normalizeId", (Object)new FrameBuilder(new String[]{"normalizeId", entity.isAbstract() || entity.isDecorable() ? "abstract" : ""}).add("package", (Object)this.workingPackage).add("name", (Object)entity.name$()).toFrame());
        builder.add("isAbstract", (Object)(entity.isAbstract() ? " abstract" : ""));
        return builder;
    }

    public static List<Struct> structListOf(Entity entity) {
        return entity.structList();
    }

    private String withFullPackage(String parent) {
        return this.entitiesPackage() + parent;
    }

    private String baseEntityName() {
        return this.workingPackage + DOT + Formatters.firstUpperCase(this.datamart.name$()) + "Entity";
    }

    private Frame structFrame(Struct struct, Entity owner) {
        StructFrameFactory frameFactory = new StructFrameFactory(this.datamart, this.workingPackage);
        Map<String, Frame> frames = frameFactory.create(struct, owner.name$());
        return frames.values().stream().findFirst().get();
    }

    private String calculateEntityPath(Entity entity, String thePackage) {
        return thePackage + ".entities." + (entity.isDecorable() ? "Abstract" : "") + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)entity.core$().name()).toString());
    }

    private String calculateDecorableEntityPath(Node node, String aPackage) {
        return aPackage + ".entities." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)node.name()).toString());
    }

    @Override
    public Datamart datamart() {
        return this.datamart;
    }

    @Override
    public String workingPackage() {
        return this.workingPackage;
    }
}

