/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.datamarts;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class DatamartTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"datamart", "interface"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport java.util.List;\nimport java.util.Map;\nimport java.util.concurrent.ConcurrentHashMap;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\nimport java.time.Instant;\nimport java.util.Optional;\n\nimport io.intino.ness.master.Datamart;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.reflection.*;\n\npublic interface ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart extends Datamart {\n\n\tDatamartDefinition definition = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.DatamartDefinitionInternal();\n\n\tList<String> listSnapshots();\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart snapshot(String timetag);\n\n\tint sizeDisabled();\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"getterSignature"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasTimelines", new String[0])}).output(new Rule.Output[]{this.literal("Stream<TimelineNode> timelines(String id);")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("timeline", new String[]{"getterSignature"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasReels", new String[0])}).output(new Rule.Output[]{this.literal("Stream<ReelNode> reels(String id);")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("reel", new String[]{"getterSignature"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("indicator", new String[]{"getterSignature"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("default IndicatorNode indicator(String name) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\treturn switch(name) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\t")}).output(new Rule.Output[]{this.mark("indicator", new String[]{"case"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\tdefault -> null;")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t};")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("}")})}).output(new Rule.Output[]{this.literal("\n\n\tDictionary dictionary(String name);\n\n\tclass Entities {\n\t\tprivate final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart;\n\t\tprivate final Map<EntityDefinition, Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity>> entitiesByType;\n\t\tprivate final Map<EntityDefinition, Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity>> entitiesByTypeDisabled;\n\n\t\tpublic Entities(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart) {\n\t\t\tthis.datamart = datamart;\n\t\t\tthis.entitiesByType = new ConcurrentHashMap<>();\n\t\t\tthis.entitiesByTypeDisabled = new ConcurrentHashMap<>();\n\t\t\tdatamart.getDefinition().entities().stream().filter(e -> !e.isAbstract()).forEach(entity -> entitiesByType.put(entity, new ConcurrentHashMap<>()));\n\t\t\tdatamart.getDefinition().entities().stream().filter(e -> !e.isAbstract()).forEach(entity -> entitiesByTypeDisabled.put(entity, new ConcurrentHashMap<>()));\n\t\t}\n\n\t\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart() {\n\t\t\treturn datamart;\n\t\t}\n\n    \tpublic int size() {\n    \t\treturn entitiesByType.values().stream().mapToInt(Map::size).sum();\n    \t}\n\n    \tpublic int sizeDisabled() {\n    \t\treturn entitiesByTypeDisabled.values().stream().mapToInt(Map::size).sum();\n    \t}\n\n    \tpublic boolean exists(String id) {\n    \t\treturn contains(id) || containsDisabled(id);\n    \t}\n\n    \tpublic boolean contains(String id) {\n    \t\treturn get(id) != null;\n    \t}\n\n    \tpublic boolean containsDisabled(String id) {\n    \t\treturn getDisabled(id) != null;\n    \t}\n\n    \tpublic boolean exists(EntityDefinition definition, String id) {\n    \t\treturn contains(definition, id) || containsDisabled(definition, id);\n    \t}\n\n    \tpublic boolean contains(EntityDefinition definition, String id) {\n    \t\treturn get(definition, id) != null;\n    \t}\n\n    \tpublic boolean containsDisabled(EntityDefinition definition, String id) {\n    \t\treturn getDisabled(definition, id) != null;\n    \t}\n\n    \tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity get(String id) {\n    \t\treturn mapOf(id).map(map -> map.get(id)).orElse(null);\n    \t}\n\n    \tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity getDisabled(String id) {\n    \t\treturn mapOfDisabled(id).map(map -> map.get(id)).orElse(null);\n    \t}\n\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> T getDescendant(EntityDefinition definition, String id) {\n    \t\tT entity = get(definition, id);\n    \t\treturn entity != null ? entity: definition.descendants().stream()\n    \t\t\t.filter(descendant -> !descendant.isAbstract())\n    \t\t\t.map(descendant -> this.<T>get(descendant, id))\n    \t\t\t.filter(java.util.Objects::nonNull).findFirst().orElse(null);\n    \t}\n\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> T getDescendantDisabled(EntityDefinition definition, String id) {\n    \t\tT entity = getDisabled(definition, id);\n    \t\treturn entity != null ? entity: definition.descendants().stream()\n    \t\t\t.filter(descendant -> !descendant.isAbstract())\n    \t\t\t.map(descendant -> this.<T>getDisabled(descendant, id))\n    \t\t\t.filter(java.util.Objects::nonNull).findFirst().orElse(null);\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> T get(EntityDefinition type, String id) {\n    \t\treturn entitiesByType.containsKey(type) ? (T) entitiesByType.get(type).get(id) : null;\n        }\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> T getDisabled(EntityDefinition type, String id) {\n    \t\treturn entitiesByTypeDisabled.containsKey(type) ? (T) entitiesByTypeDisabled.get(type).get(id) : null;\n        }\n\n    \tpublic void add(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity entity) {\n    \t\tentitiesByType.get(entity.getDefinition()).put(entity.id(), entity);\n    \t}\n\n    \tpublic void addDisabled(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity entity) {\n    \t\tentitiesByTypeDisabled.get(entity.getDefinition()).put(entity.id(), entity);\n    \t}\n\n    \tpublic void disable(String id) {\n    \t\tmapOf(id).map(m -> m.remove(id)).ifPresent(this::addDisabled);\n    \t}\n\n    \tpublic void enable(String id) {\n    \t\tmapOfDisabled(id).map(m -> m.remove(id)).ifPresent(this::add);\n    \t}\n\n    \tpublic void delete(String id) {\n    \t\tmapOf(id).ifPresent(map -> map.remove(id));\n    \t\tmapOfDisabled(id).ifPresent(map -> map.remove(id));\n    \t}\n\n    \tpublic Stream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> stream() {\n    \t\treturn entitiesByType.values().stream().flatMap(map -> map.values().stream());\n    \t}\n\n    \tpublic Stream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> streamDisabled() {\n    \t\treturn entitiesByTypeDisabled.values().stream().flatMap(map -> map.values().stream());\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> Stream<T> stream(EntityDefinition type) {\n    \t\treturn (Stream<T>) (entitiesByType.containsKey(type) ? entitiesByType.get(type).values().stream() : Stream.empty());\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> Stream<T> streamDisabled(EntityDefinition type) {\n    \t\treturn (Stream<T>) (entitiesByTypeDisabled.containsKey(type) ? entitiesByTypeDisabled.get(type).values().stream() : Stream.empty());\n    \t}\n\n    \tpublic Stream<Entity> streamGeneric() {\n        \treturn entitiesByType.values().stream().flatMap(map -> map.values().stream());\n        }\n\n    \tpublic Stream<Entity> streamGenericDisabled() {\n        \treturn entitiesByTypeDisabled.values().stream().flatMap(map -> map.values().stream());\n        }\n\n    \tprivate java.util.Optional<Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity>> mapOf(String id) {\n    \t\treturn entitiesByType.values().stream().filter(map -> map.containsKey(id)).findFirst();\n    \t}\n\n    \tprivate java.util.Optional<Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity>> mapOfDisabled(String id) {\n    \t\treturn entitiesByTypeDisabled.values().stream().filter(map -> map.containsKey(id)).findFirst();\n    \t}\n    }\n\n\n    interface IndicatorNode {\n    \tboolean exists();\n    \tIndicator get() throws IndicatorNotAvailableException;\n\n    \tstatic IndicatorNode empty() {\n\t\t\treturn new IndicatorNode() {\n\t\t\t\tpublic boolean exists() {return false;}\n\t\t\t\tpublic Indicator get() throws IndicatorNotAvailableException {throw new IndicatorNotAvailableException();}\n\t\t\t};\n\t\t}\n    }\n\n    public record Indicator(Map<String, Shot> shots) {\n    \tpublic Shot get(String sensor) {\n    \t\treturn shots.get(sensor);\n    \t}\n\n    \tpublic record Shot(Instant ts, double value) {\n    \t}\n    }\n\n    interface ChronosNode {\n    \t/**<p>Returns the id of the chronos object</p>*/\n    \tString id();\n    \t/**<p>Returns the type of the chronos object, as defined in the model</p>*/\n    \tString type();\n    \t/**Clears this node's internal cache, if any, and notifies the datamart to unload this node from memory.*/\n    \tvoid dispose();\n    }\n\n    interface TimelineNode extends ChronosNode {\n    \tjava.util.concurrent.atomic.AtomicBoolean AlwaysDownloadFromDatahub = new java.util.concurrent.atomic.AtomicBoolean();\n\t\tboolean exists();\n\t\tio.intino.sumus.chronos.TimelineStore.TimeModel timeModel() throws TimelineNotAvailableException;\n\t\tio.intino.sumus.chronos.TimelineStore.SensorModel sensorModel() throws TimelineNotAvailableException;\n\t\tInstant first() throws TimelineNotAvailableException;\n\t\tInstant last() throws TimelineNotAvailableException;\n    \tio.intino.sumus.chronos.Timeline get() throws TimelineNotAvailableException;\n\n    \tvoid setChangeListener(ChangeListener listener);\n\n \t\tinterface ChangeListener {\n    \t\tvoid notifyChange(TimelineNode timeline);\n    \t}\n\n    \tstatic TimelineNode empty() {\n    \t\treturn new TimelineNode() {\n                public String id(){return \"\";}\n                public String type(){return \"\";}\n                public void dispose(){}\n            \tpublic boolean exists() {return false;}\n            \tpublic io.intino.sumus.chronos.TimelineStore.TimeModel timeModel() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.TimelineStore.SensorModel sensorModel() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic Instant first() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic Instant last() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Timeline get() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic void setChangeListener(ChangeListener listener) {}\n    \t\t};\n    \t}\n    }\n\n    interface ReelNode extends ChronosNode {\n\t\tboolean exists();\n    \tjava.time.Instant start() throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.State stateOf(String signal) throws ReelNotAvailableException;\n\t\tdefault List<io.intino.sumus.chronos.State> stateOf(List<String> signals) throws ReelNotAvailableException {return signals.isEmpty() ? java.util.Collections.emptyList() : stateOf(signals.stream());}\n\t\tList<io.intino.sumus.chronos.State> stateOf(Stream<String> signals) throws ReelNotAvailableException;\n\t\tio.intino.sumus.chronos.Shot lastShotOf(String signal) throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots() throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots(String group) throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots(io.intino.sumus.chronos.Group group) throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.Reel get(io.intino.sumus.chronos.Period period) throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.Reel get(java.time.Instant from, java.time.Instant to, io.intino.sumus.chronos.Period period) throws ReelNotAvailableException;\n    \tvoid setChangeListener(ChangeListener listener);\n\n \t\tinterface ChangeListener {\n    \t\tvoid notifyChange(ReelNode reel);\n    \t}\n\n    \tstatic ReelNode empty() {\n    \t\treturn new ReelNode() {\n    \t        public String id(){return \"\";}\n                public String type(){return \"\";}\n                public void dispose(){}\n    \t\t\tpublic boolean exists() {return false;}\n            \tpublic java.time.Instant start() throws ReelNotAvailableException {throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.State stateOf(String signal) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic List<io.intino.sumus.chronos.State> stateOf(Stream<String> signals) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Shot lastShotOf(String signal) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots() throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots(String group) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots(io.intino.sumus.chronos.Group group) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Reel get(io.intino.sumus.chronos.Period period) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Reel get(java.time.Instant from, java.time.Instant to, io.intino.sumus.chronos.Period period) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic void setChangeListener(ChangeListener listener) {}\n    \t\t};\n    \t}\n    }\n\n\tfinal class DatamartDefinitionInternal implements DatamartDefinition {\n\t\tprivate DatamartDefinition definition;\n\t\tprivate DatamartDefinitionInternal() {}\n\t\t@Override\n\t\tpublic String name() {return definition().name();}\n\t\t@Override\n\t\tpublic Datamart.Scale scale() {return definition().scale();}\n\t\t@Override\n\t\tpublic Query<EntityDefinition> entities() {return definition().entities();}\n\t\t@Override\n\t\tpublic Query<StructDefinition> structs() {return definition().structs();}\n\t\t@Override\n\t\tpublic Optional<EntityDefinition> entity(String fullName) {\n        \treturn definition().entity(fullName);\n        }\n        @Override\n        public Optional<StructDefinition> struct(String fullName) {\n        \treturn definition().struct(fullName);\n        }\n\t\tprivate DatamartDefinition definition() {\n\t\t\tif (definition == null) throw new IllegalStateException(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart is not initialized\");\n\t\t\treturn definition;\n\t\t}\n\t}\n\n\tpublic static class DatahubRequestException extends Exception {\n\t\tpublic DatahubRequestException() {}\n\t\tpublic DatahubRequestException(String message) {super(message);}\n\t\tpublic DatahubRequestException(String message, Throwable cause) {super(message, cause);}\n\t}\n\n\tpublic static class IndicatorNotAvailableException extends Exception {\n    \tpublic IndicatorNotAvailableException() {}\n    \tpublic IndicatorNotAvailableException(String message) {super(message);}\n    \tpublic IndicatorNotAvailableException(Throwable e) {super(e);}\n    }\n\n    public static class TimelineNotAvailableException extends Exception {\n\t\tpublic TimelineNotAvailableException() {}\n\t\tpublic TimelineNotAvailableException(String message) {super(message);}\n\t\tpublic TimelineNotAvailableException(Throwable e) {super(e);}\n\t}\n\n\tpublic static class ReelNotAvailableException extends Exception {\n    \tpublic ReelNotAvailableException() {}\n    \tpublic ReelNotAvailableException(String message) {super(message);}\n    \tpublic ReelNotAvailableException(Throwable e) {super(e);}\n    }\n}")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("gettersignature")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id);\n")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled(String id);\nStream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\nStream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled();\ndefault List<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("List() {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().collect(Collectors.toList());}\ndefault List<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("DisabledList() {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled().collect(Collectors.toList());}\ndefault java.util.Optional<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(java.util.function.Predicate<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> predicate) {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().filter(predicate).findFirst();}\ndefault java.util.Optional<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled(java.util.function.Predicate<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> predicate) {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("Disabled().filter(predicate).findFirst();}")}), this.rule().condition(this.type("timeline"), new Rule.Condition[]{this.trigger("gettersignature")}).output(new Rule.Output[]{this.literal("default TimelineNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Timeline(")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("entity", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" entity) {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Timeline(entity.id());}\nTimelineNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Timeline(String id);")}), this.rule().condition(this.type("reel"), new Rule.Condition[]{this.trigger("gettersignature")}).output(new Rule.Output[]{this.literal("default ReelNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Reel(")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("entity", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" entity) {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Reel(entity.id());}\nReelNode ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Reel(String id);\nStream<ReelNode> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Reels();")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("gettersignature")}).output(new Rule.Output[]{this.literal("IndicatorNode ")}).output(new Rule.Output[]{this.mark("label", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Indicator();")}), this.rule().condition(this.type("indicator"), new Rule.Condition[]{this.trigger("case")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\" -> ")}).output(new Rule.Output[]{this.mark("label", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Indicator();")})});
    }
}

