/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Struct;
import io.intino.datahub.model.Terminal;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Layer;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.EntitiesTemplate;
import io.intino.ness.datahubterminalplugin.master.EntityFrameCreator;
import io.intino.ness.datahubterminalplugin.master.EntityTemplate;
import io.intino.ness.datahubterminalplugin.master.StructFrameCreator;
import io.intino.ness.datahubterminalplugin.master.StructTemplate;
import io.intino.ness.datahubterminalplugin.master.ValidatorFrameCreator;
import io.intino.ness.datahubterminalplugin.master.ValidatorTemplate;
import io.intino.ness.datahubterminalplugin.util.ErrorUtils;
import io.intino.plugin.PluginLauncher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MasterRenderer {
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private final File srcFolder;
    private final NessGraph model;
    private final Configuration conf;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private final Template entityTemplate;
    private final Template validatorTemplate;
    private final Template structTemplate;
    private String modelPackage;

    public MasterRenderer(File srcDir, NessGraph model, Configuration conf, PrintStream logger, PluginLauncher.Notifier notifier, String basePackage) {
        this.srcFolder = srcDir;
        this.model = model;
        this.conf = conf;
        this.logger = logger;
        this.notifier = notifier;
        this.entityTemplate = Formatters.customize(new EntityTemplate());
        this.validatorTemplate = Formatters.customize(new ValidatorTemplate());
        this.structTemplate = Formatters.customize(new StructTemplate());
        this.srcFolder.mkdirs();
        this.modelPackage = basePackage;
    }

    public boolean renderOntology() {
        this.modelPackage = this.modelPackage + ".master";
        return this.renderMaster() && this.renderOntologyClasses();
    }

    public boolean renderTerminal(Terminal terminal) {
        try {
            this.write(this.entitiesImpl(terminal));
            return true;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public boolean renderMaster() {
        try {
            if (this.model.entityList().isEmpty()) {
                return false;
            }
            this.write(this.entitiesInterfaces());
            this.write(this.validationLayerClass());
            return true;
        }
        catch (Throwable e) {
            this.notifier.notifyError("Error during java className generation: " + ErrorUtils.getMessage(e));
            return false;
        }
    }

    public boolean renderOntologyClasses() {
        try {
            this.logger.println("Generating Entities...");
            this.write(this.structClasses());
            this.write(this.entityClasses());
            return true;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private Map<String, String> entityClasses() {
        HashMap<String, String> outputs = new HashMap<String, String>();
        this.model.entityList().forEach(e -> outputs.putAll(this.renderEntityAndValidator((Entity)e)));
        return outputs;
    }

    private Map<String, String> renderEntityAndValidator(Entity entity) {
        Map<String, String> map = this.renderEntityNode(entity);
        map.putAll(this.renderValidator(entity));
        return map;
    }

    private Map<String, String> structClasses() {
        return this.model.structList().stream().map(this::renderStructNode).flatMap(e -> e.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> validationLayerClass() {
        String module = "General";
        String qn = this.modelPackage + ".validators." + module + "RecordValidationLayer";
        return Map.of(this.destination(qn), Formatters.customize(new ValidatorTemplate()).render((Object)new FrameBuilder(new String[]{"validationLayer", "class"}).add("module", (Object)module).add("entity", (Object)this.entitiesForInterfaces("")).add("package", (Object)(this.modelPackage + ".validators")).toFrame()));
    }

    private Map<String, String> entitiesInterfaces() {
        String masterView = this.modelPackage + DOT + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)"EntitiesView").toString());
        String masterTerminal = this.modelPackage + DOT + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)"Entities").toString());
        return Map.of(this.destination(masterView), Formatters.customize(new EntitiesTemplate()).render((Object)this.entitiesInterfaceFrameBuilder("view").toFrame()), this.destination(masterTerminal), Formatters.customize(new EntitiesTemplate()).render((Object)this.entitiesInterfaceFrameBuilder("interface").toFrame()));
    }

    private Map<String, String> entitiesImpl(Terminal terminal) {
        String cachedEntities = this.modelPackage + DOT + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)"CachedEntities").toString());
        return Map.of(this.destination(cachedEntities), Formatters.customize(new EntitiesTemplate()).render((Object)this.entitiesImplFrameBuilder("cached", terminal).toFrame()));
    }

    private FrameBuilder entitiesImplFrameBuilder(String type, Terminal terminal) {
        FrameBuilder builder = new FrameBuilder(new String[]{"master"}).add("package", (Object)this.modelPackage);
        builder.add("entity", (Object)this.entities(type, terminal));
        builder.add(type);
        return builder;
    }

    private FrameBuilder entitiesInterfaceFrameBuilder(String type) {
        FrameBuilder builder = new FrameBuilder(new String[]{"master"}).add("package", (Object)this.modelPackage);
        builder.add("entity", (Object)this.entitiesForInterfaces(type));
        builder.add(type);
        return builder;
    }

    private Frame[] entities(String type, Terminal terminal) {
        Set<String> subscribeEntities = this.getSubscribeEntities(terminal);
        Set publishEntities = terminal.publish() == null ? Set.of() : terminal.publish().entityTanks().stream().map(e -> e.name$().toLowerCase()).collect(Collectors.toSet());
        return (Frame[])this.model.entityList().stream().map(c -> {
            FrameBuilder b = new FrameBuilder(new String[]{"entity"}).add("package", (Object)(this.modelPackage + ".master")).add("name", (Object)c.name$());
            if (c.isAbstract()) {
                b.add("abstract");
                Frame[] subclasses = this.subclassesOf((Entity)c);
                if (subclasses.length > 0) {
                    b.add("subclass", (Object)subclasses);
                }
            }
            b.add(type);
            if (this.findRecursivelyIn((Entity)c, subscribeEntities)) {
                b.add("subscribe");
            }
            if (this.findRecursivelyIn((Entity)c, publishEntities)) {
                b.add("publish");
            }
            return b.toFrame();
        }).toArray(Frame[]::new);
    }

    private boolean findRecursivelyIn(Entity entity, Set<String> entities) {
        if (entities.contains(entity.name$().toLowerCase())) {
            return true;
        }
        return this.anyOfItsParentsIsPresent(entity, entities);
    }

    private boolean anyOfItsParentsIsPresent(Entity entity, Set<String> entities) {
        if (!entity.isExtensionOf()) {
            return false;
        }
        Entity parent = entity.asExtensionOf().entity();
        if (parent == null) {
            return false;
        }
        if (entities.contains(parent.name$().toLowerCase())) {
            return true;
        }
        return this.anyOfItsParentsIsPresent(parent, entities);
    }

    private Set<String> getSubscribeEntities(Terminal terminal) {
        Terminal.Subscribe subscribe = terminal.subscribe();
        if (subscribe == null) {
            return Set.of();
        }
        Set<String> subscribeEntities = subscribe.entityTanks().stream().map(Layer::name$).map(String::toLowerCase).collect(Collectors.toSet());
        if (this.model.entityList().stream().map(e -> e.name$().toLowerCase()).allMatch(subscribeEntities::contains)) {
            return subscribeEntities;
        }
        this.resolveInterDependencies(subscribeEntities);
        return subscribeEntities;
    }

    private void resolveInterDependencies(Set<String> entities) {
        for (String name : (String[])entities.toArray(String[]::new)) {
            Entity entity = this.findEntity(name);
            if (entity == null) {
                Logger.warn((String)("Entity " + name + " not found in model"));
                continue;
            }
            this.getEntityReferencesOf(entity, entities);
        }
    }

    private void getEntityReferencesOf(Entity entity, Set<String> entities) {
        for (Entity.Attribute attribute : entity.attributeList()) {
            for (Entity entity2 : this.entityReferencesOf(attribute)) {
                if (!entities.add(entity2.name$().toLowerCase())) continue;
                this.getEntityReferencesOf(entity2, entities);
            }
        }
        for (Entity.Method method : entity.methodList()) {
            for (Entity entity3 : this.entityReferencesOf(method)) {
                if (!entities.add(entity3.name$().toLowerCase())) continue;
                this.getEntityReferencesOf(entity3, entities);
            }
        }
    }

    private Iterable<? extends Entity> entityReferencesOf(Entity.Method method) {
        if (method.isGetter()) {
            return Collections.emptyList();
        }
        if (method.isFunction()) {
            return this.entityReferencesOf(method.asFunction().returnType().asEntity(), method.asFunction().parameterList().stream().filter(EntityData::isEntity).map(EntityData::asEntity).collect(Collectors.toList()));
        }
        if (method.isRoutine()) {
            return this.entityReferencesOf(null, method.asRoutine().parameterList().stream().filter(EntityData::isEntity).map(EntityData::asEntity).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private Iterable<? extends Entity> entityReferencesOf(EntityData.Entity returnType, List<EntityData.Entity> params) {
        ArrayList<Entity> entities = new ArrayList<Entity>(1 + params.size());
        if (returnType != null && returnType.entity() != null) {
            entities.add(returnType.entity());
        }
        params.stream().filter(Objects::nonNull).map(EntityData.Entity::entity).filter(Objects::nonNull).forEach(entities::add);
        return entities;
    }

    private Iterable<? extends Entity> entityReferencesOf(Entity.Attribute attribute) {
        EntityData.Entity e = attribute.asEntity();
        if (e != null && e.entity() != null) {
            return List.of(e.entity());
        }
        return Collections.emptyList();
    }

    private Entity findEntity(String name) {
        return this.model.entityList(e -> name.equalsIgnoreCase(e.name$())).findFirst().orElse(null);
    }

    private Frame[] entitiesForInterfaces(String type) {
        return (Frame[])this.model.entityList().stream().map(c -> {
            FrameBuilder b = new FrameBuilder(new String[]{"entity"}).add("package", (Object)this.modelPackage).add("name", (Object)c.name$());
            if (c.isAbstract()) {
                b.add("abstract");
                Frame[] subclasses = this.subclassesOf((Entity)c);
                if (subclasses.length > 0) {
                    b.add("subclass", (Object)subclasses);
                }
            }
            b.add(type);
            return b.toFrame();
        }).toArray(Frame[]::new);
    }

    private Frame[] subclassesOf(Entity parent) {
        return (Frame[])this.model.entityList().stream().filter(e -> MasterRenderer.isSubclassOf(e, parent)).map(c -> new FrameBuilder(new String[]{"subclass"}).add("package", (Object)(this.modelPackage + ".master")).add("name", (Object)c.name$()).toFrame()).toArray(Frame[]::new);
    }

    private static boolean isSubclassOf(Entity node, Entity parent) {
        return node.isExtensionOf() && node.asExtensionOf().entity().equals(parent);
    }

    private Map<String, String> renderEntityNode(Entity entity) {
        return new EntityFrameCreator(this.modelPackage, this.model).create(entity).entrySet().stream().collect(Collectors.toMap(e -> this.entityDestination((String)e.getKey(), (Frame)e.getValue()), e -> this.entityTemplate.render(e.getValue())));
    }

    private Map<String, String> renderValidator(Entity entity) {
        return new ValidatorFrameCreator(this.modelPackage).create(entity).entrySet().stream().collect(Collectors.toMap(e -> this.validatorDestination((String)e.getKey(), (Frame)e.getValue()), e -> this.validatorTemplate.render(e.getValue())));
    }

    private Map<String, String> renderStructNode(Struct struct) {
        return new StructFrameCreator(this.modelPackage).create(struct).entrySet().stream().collect(Collectors.toMap(e -> this.destination((String)e.getKey()), e -> this.structTemplate.render(e.getValue())));
    }

    private void write(Map<String, String> outputsMap) {
        outputsMap.forEach((key, value) -> {
            File file = new File((String)key);
            if (value.isEmpty() || this.isUnderSource(file) && file.exists()) {
                return;
            }
            file.getParentFile().mkdirs();
            this.write(file, (String)value);
        });
    }

    private boolean isUnderSource(File file) {
        return file.getAbsolutePath().startsWith(this.srcFolder.getAbsolutePath());
    }

    private void write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
            fileWriter.write(text);
            fileWriter.close();
        }
        catch (IOException e) {
            this.notifier.notifyError(e.getMessage());
        }
    }

    private String destination(String path) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String entityDestination(String path, Frame frame) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String validatorDestination(String path, Frame frame) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }
}

