/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.Entity;
import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.DefaultValueHelper;
import io.intino.ness.datahubterminalplugin.master.ExpressionHelper;
import io.intino.ness.datahubterminalplugin.master.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityFrameCreator {
    private static final String DOT = ".";
    static final Map<String, String> TheTypes = Map.of("String", "String", "Double", "double", "Integer", "int", "Long", "long", "Boolean", "boolean", "Entity", "io.intino.ness.master.model.Entity", "Date", "LocalDate", "DateTime", "LocalDateTime", "Instant", "Instant");
    static final Map<String, String> ListTypes = Map.of("String", "List<String>", "Double", "List<Double>", "Integer", "List<Integer>", "Boolean", "List<Boolean>", "Entity", "List<io.intino.ness.master.model.Entity>", "Long", "List<Long>", "Date", "List<LocalDate>", "DateTime", "List<LocalDateTime>", "Instant", "List<Instant>");
    static final Map<String, String> SetTypes = Map.of("String", "Set<String>", "Double", "Set<Double>", "Integer", "Set<Integer>", "Boolean", "Set<Boolean>", "Entity", "Set<io.intino.ness.master.model.Entity>", "Long", "Set<Long>", "Date", "Set<LocalDate>", "DateTime", "Set<LocalDateTime>", "Instant", "Set<Instant>");
    private final String workingPackage;
    private final NessGraph model;

    public EntityFrameCreator(String workingPackage, NessGraph model) {
        this.workingPackage = workingPackage;
        this.model = model;
    }

    public Map<String, Frame> create(Entity entity) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(4);
        map.put(this.calculateEntityPath(entity, this.workingPackage), this.frameOf(entity).toFrame());
        if (entity.isDecorable()) {
            map.put(this.calculateDecorableEntityPath(entity.core$(), this.workingPackage), this.frameOf(entity).add("decorable").toFrame());
        }
        return map;
    }

    private FrameBuilder frameOf(Entity entity) {
        Parameter parent;
        FrameBuilder builder = new FrameBuilder(new String[]{"entity", "class"}).add("package", (Object)this.workingPackage).add("name", (Object)entity.core$().name()).add("attribute", (Object)entity.core$().componentList().stream().filter(a -> a.is(EntityData.class)).map(a -> this.attrFrameOf((Node)a, entity.core$())).toArray()).add("expression", (Object)entity.core$().componentList().stream().filter(a -> a.is(Expression.class)).map(ExpressionHelper::exprFrameOf).toArray());
        if (!this.model.structList().isEmpty()) {
            builder.add("hasStructs", (Object)new FrameBuilder().add("package", (Object)this.workingPackage));
        }
        builder.add("parent", (Object)((parent = this.parameter(entity.core$(), "entity")) != null ? ((Entity)parent.values().get(0)).name$() : "io.intino.ness.master.model.Entity"));
        builder.add("normalizeId", (Object)new FrameBuilder(new String[]{"normalizeId", entity.isAbstract() || entity.isDecorable() ? "abstract" : ""}).add("package", (Object)this.workingPackage).add("name", (Object)entity.name$()).toFrame());
        if (entity.isDecorable() || entity.isAbstract()) {
            builder.add("isAbstract", (Object)"abstract");
        }
        if (entity.isDecorable()) {
            builder.add("abstract", (Object)"abstract");
        }
        return builder;
    }

    private Frame attrFrameOf(Node node, Node owner) {
        FrameBuilder builder = new FrameBuilder().add("attribute");
        node.conceptList().forEach(aspect -> builder.add(aspect.name()));
        String type = EntityFrameCreator.typeOf(node);
        builder.add("name", (Object)node.name()).add("owner", (Object)node.owner().name()).add("type", (Object)type).add("package", (Object)this.workingPackage).add("index", (Object)node.owner().componentList().indexOf(node)).add("entityOwner", (Object)owner.name());
        if (owner.is(Entity.Abstract.class) || owner.is(Entity.Decorable.class)) {
            builder.add("castToSubclass", (Object)("(" + owner.name() + ")"));
        }
        if (type.contains("List<") || type.contains("Set<")) {
            builder.add("typeParameter", (Object)EntityFrameCreator.typeParameterOf(type));
        }
        this.processParameters(node, builder, type);
        return builder.toFrame();
    }

    private void processParameters(Node node, FrameBuilder builder, String type) {
        Parameter struct;
        Parameter format;
        Parameter defaultValue;
        Parameter values = this.parameter(node, "values");
        if (values != null) {
            builder.add("value", (Object)values.values().stream().map(Object::toString).toArray());
        }
        if ((defaultValue = DefaultValueHelper.getDefaultValue(node)) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(node, type, defaultValue));
        }
        if ((format = this.parameter(node, "format")) != null) {
            builder.add("format", format.values().get(0));
        } else if (type.startsWith("Date")) {
            builder.add("format", (Object)this.defaultFormat(type));
        }
        Parameter entity = this.parameter(node, "entity");
        if (entity != null) {
            String name = ((Entity)entity.values().get(0)).name$();
            builder.add("entity", (Object)name);
            Entity reference = this.model.entityList().stream().filter(e -> e.name$().equals(name)).findFirst().orElse(null);
            if (reference != null && reference.core$().conceptList().stream().anyMatch(c -> c.name().equals("Component"))) {
                builder.add("component");
            }
        }
        if ((struct = this.parameter(node, "struct")) != null) {
            Struct structNode = (Struct)struct.values().get(0);
            builder.add("struct", (Object)this.structFrame(structNode)).add("structLength", (Object)String.valueOf(structNode.attributeList().size()));
        }
        builder.add("attribute", (Object)builder.toFrame());
    }

    private String defaultFormat(String type) {
        return type.equals("Date") ? "dd/MM/yyyy" : "dd/MM/yyyy HH:mm:ss";
    }

    private Frame structFrame(Struct node) {
        return new FrameBuilder(new String[]{"struct"}).add("name", (Object)node.core$().name()).add("package", (Object)this.workingPackage).add("attribute", (Object)node.attributeList().stream().map(node1 -> this.attrFrameOf(node1.core$(), node.core$())).toArray()).toFrame();
    }

    private Frame defaultValue(Node c, String type, Parameter defaultValue) {
        FrameBuilder builder = new FrameBuilder((String[])c.conceptList().stream().map(Predicate::name).toArray(String[]::new));
        return builder.add("type", (Object)type).add("package", (Object)this.workingPackage).add("value", (Object)EntityFrameCreator.defaultValueOf(type, defaultValue)).toFrame();
    }

    private static String defaultValueOf(String type, Parameter defaultValue) {
        if (type.contains("List<")) {
            return "new java.util.ArrayList<>()";
        }
        if (type.contains("Set<")) {
            return "new java.util.LinkedHashSet<>()";
        }
        if (type.contains("Map<")) {
            return "new java.util.LinkedHashMap<>()";
        }
        return defaultValue.values().get(0).toString();
    }

    public static String typeParameterOf(String type) {
        return type.substring(type.indexOf("<") + 1, type.lastIndexOf(">"));
    }

    public static String typeOf(Node node) {
        String aspect = node.conceptList().stream().map(Predicate::name).filter(EntityFrameCreator::isProperTypeName).findFirst().orElse("");
        boolean list = node.conceptList().stream().anyMatch(a -> a.name().equals("List"));
        if (list) {
            return ListTypes.getOrDefault(aspect, "List<" + StringFormatters.firstUpperCase().format((Object)node.name()).toString() + ">");
        }
        boolean set = node.conceptList().stream().anyMatch(a -> a.name().equals("Set"));
        if (set) {
            return SetTypes.getOrDefault(aspect, "Set<" + StringFormatters.firstUpperCase().format((Object)node.name()).toString() + ">");
        }
        return TheTypes.getOrDefault(aspect, StringFormatters.firstUpperCase().format((Object)node.name()).toString());
    }

    public static boolean isProperTypeName(String s) {
        return !s.equals("Set") && !s.equals("List") && !s.equals("Optional") && !s.equals("Type") && !s.equals("Required");
    }

    private Parameter parameter(Node c, String name) {
        List values = (List)c.variables().get(name);
        return values == null ? null : Parameter.of(values);
    }

    private String calculateEntityPath(Entity entity, String aPackage) {
        return aPackage + ".entities." + (entity.isDecorable() ? "Abstract" : "") + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)entity.core$().name()).toString());
    }

    private String calculateDecorableEntityPath(Node node, String aPackage) {
        return aPackage + ".entities." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)node.name()).toString());
    }
}

