/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.Configuration;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.PomTemplate;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

public class MavenTerminalExecutor {
    private final File root;
    private final String basePackage;
    private final Target target;
    private final String terminalName;
    private final Map<String, String> versions;
    private final Configuration conf;
    private final PluginLauncher.SystemProperties systemProperties;
    private final PrintStream logger;

    public MavenTerminalExecutor(File root, String basePackage, Target target, String terminalName, Map<String, String> versions, Configuration conf, PluginLauncher.SystemProperties systemProperties, PrintStream logger) {
        this.root = root;
        this.basePackage = basePackage;
        this.target = target;
        this.terminalName = terminalName;
        this.versions = versions;
        this.conf = conf;
        this.systemProperties = systemProperties;
        this.logger = logger;
    }

    public void mvn(String goal) throws IOException, MavenInvocationException {
        File pom = this.createPom(this.root, this.basePackage, this.terminalName, this.conf.artifact().version());
        InvocationResult result = this.invoke(pom, goal);
        if (result != null && result.getExitCode() != 0) {
            if (result.getExecutionException() != null) {
                throw new IOException("Failed to publish accessor.", (Throwable)result.getExecutionException());
            }
            throw new IOException("Failed to publish accessor. Exit code: " + result.getExitCode());
        }
        if (result == null) {
            throw new IOException("Failed to publish accessor. Maven HOME not found");
        }
    }

    private InvocationResult invoke(File pom, String goal) throws MavenInvocationException {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        if (!goal.isEmpty()) {
            goals.add(goal);
        }
        InvocationRequest request = new DefaultInvocationRequest().setPomFile(pom).setGoals(goals);
        Invoker invoker = new DefaultInvoker().setMavenHome(this.systemProperties.mavenHome);
        this.log(invoker);
        this.config(request, this.systemProperties.mavenHome);
        return invoker.execute(request);
    }

    private void log(Invoker invoker) {
        invoker.setErrorHandler(this.logger::println);
    }

    private void config(InvocationRequest request, File mavenHome) {
        File mvn = new File(mavenHome, "bin" + File.separator + "mvn");
        mvn.setExecutable(true);
        request.setJavaHome(this.systemProperties.javaHome);
    }

    private File createPom(File root, String group, String artifact, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)artifact).add("version", (Object)version);
        this.conf.repositories().forEach(r -> this.buildRepoFrame(builder, (Configuration.Repository)r));
        if (this.conf.artifact().distribution() != null) {
            if (this.isSnapshotVersion()) {
                this.buildDistroFrame(builder, this.conf.artifact().distribution().snapshot());
            } else {
                this.buildDistroFrame(builder, this.conf.artifact().distribution().release());
            }
        }
        if (this.target.equals((Object)Target.Events) || this.target.equals((Object)Target.EventsAndEntities)) {
            builder.add("terminal", (Object)this.terminalDependenciesFrame(group, version));
        }
        if (this.target.equals((Object)Target.Bpm)) {
            builder.add("bpm", (Object)this.versions.get("bpm"));
        }
        File pomFile = new File(root, "pom.xml");
        Commons.write(pomFile.toPath(), new PomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    private boolean isSnapshotVersion() {
        return this.conf.artifact().version().contains("SNAPSHOT");
    }

    private FrameBuilder terminalDependenciesFrame(String group, String version) {
        return new FrameBuilder(new String[]{"terminal"}).add("group", (Object)group).add("artifact", (Object)"ontology").add("terminalVersion", (Object)this.versions.get("terminal-jms")).add("ingestionVersion", (Object)this.versions.get("ingestion")).add("masterVersion", (Object)this.versions.get("master")).add("version", (Object)version);
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).toFrame());
    }

    private void buildDistroFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).add("distribution").toFrame());
    }

    private FrameBuilder createRepositoryFrame(Configuration.Repository repo) {
        return new FrameBuilder(new String[]{"repository", repo.getClass().getSimpleName()}).add("name", (Object)repo.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repo.url()).add("snapshot", (Object)(repo instanceof Configuration.Repository.Snapshot));
    }

    public static enum Target {
        EventsAndEntities,
        Events,
        Bpm,
        Master;

    }
}

