/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.ontology;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Event;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Wordbag;
import io.intino.ness.datahubterminalplugin.event.EventRenderer;
import io.intino.ness.datahubterminalplugin.event.WordbagRenderer;
import io.intino.ness.datahubterminalplugin.master.MasterRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OntologyRenderer {
    private final List<Datalake.Tank.Event> eventTanks;
    private final List<Event> events;
    private final List<Wordbag> wordbags;
    private final NessGraph graph;
    private final Configuration conf;
    private final File root;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private final Map<Event, Datalake.Split> eventSplitMap;
    private final File srcDir;
    private final List<File> resDirectories;
    private final String basePackage;

    OntologyRenderer(NessGraph graph, Configuration conf, File root, File srcDir, List<File> resDirectories, String basePackage, PrintStream logger, PluginLauncher.Notifier notifier) {
        this.eventTanks = this.eventTanks(graph);
        this.events = graph.eventList();
        this.wordbags = graph.wordbagList();
        this.graph = graph;
        this.conf = conf;
        this.root = root;
        this.logger = logger;
        this.notifier = notifier;
        this.eventSplitMap = this.splitEvents();
        this.srcDir = srcDir;
        this.resDirectories = resDirectories;
        this.basePackage = basePackage;
        srcDir.mkdirs();
    }

    public boolean render() {
        this.renderEvents();
        this.renderEntities();
        return true;
    }

    private void renderEntities() {
        if (this.graph.entityList().isEmpty()) {
            return;
        }
        new MasterRenderer(this.srcDir, this.graph, this.conf, this.logger, this.notifier, this.basePackage).renderOntology();
    }

    private void renderEvents() {
        this.eventSplitMap.forEach((k, v) -> new EventRenderer((Event)k, (Datalake.Split)v, this.srcDir, this.basePackage).render());
        ((Stream)this.events.stream().filter(event -> !this.eventSplitMap.containsKey(event)).parallel()).forEach(event -> new EventRenderer((Event)event, null, this.srcDir, this.basePackage).render());
        ((Stream)this.wordbags.stream().parallel()).forEach(w -> new WordbagRenderer((Wordbag)w, this.conf, this.srcDir, this.resDirectories, this.basePackage).render());
        File resDirectory = new File(this.root, "res");
        resDirectory.mkdirs();
        this.wordbags.stream().filter(Wordbag::isInResource).map(Wordbag::asInResource).forEach(w -> {
            File source = new File(w.tsv().getPath());
            File destination = new File(resDirectory, this.relativeResource(source));
            destination.getParentFile().mkdirs();
            try {
                if (!destination.exists()) {
                    Files.copy(w.tsv().openStream(), destination.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        });
    }

    private Map<Event, Datalake.Split> splitEvents() {
        HashMap<Event, Datalake.Split> events = new HashMap<Event, Datalake.Split>();
        for (Datalake.Tank.Event tank : this.eventTanks) {
            List<Event> hierarchy = this.hierarchy(tank.event());
            Datalake.Split split = tank.asTank().isSplitted() ? tank.asTank().asSplitted().split() : null;
            events.put(hierarchy.get(0), split);
            hierarchy.remove(0);
            hierarchy.forEach(e -> events.put((Event)e, (Datalake.Split)null));
        }
        return events;
    }

    private String relativeResource(File resourceFile) {
        String file = resourceFile.getAbsolutePath();
        for (File resDirectory : this.resDirectories) {
            file = file.replace(resDirectory.getAbsolutePath(), "");
        }
        return file;
    }

    private List<Datalake.Tank.Event> eventTanks(NessGraph nessGraph) {
        if (nessGraph.datalake() == null) {
            return Collections.emptyList();
        }
        return nessGraph.datalake().tankList().stream().filter(Datalake.Tank::isEvent).map(Datalake.Tank::asEvent).collect(Collectors.toList());
    }

    private List<Event> hierarchy(Event event) {
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        events.add(event);
        if (event.isExtensionOf()) {
            events.addAll(this.hierarchy(event.asExtensionOf().parent()));
        }
        return new ArrayList<Event>(events);
    }
}

