/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.DefaultValueHelper;
import io.intino.ness.datahubterminalplugin.master.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class ValidatorFrameCreator {
    private static final String DOT = ".";
    private static final Map<String, String> TheTypes = new HashMap<String, String>(){
        {
            this.put("String", "String");
            this.put("Double", "double");
            this.put("Integer", "integer");
            this.put("Boolean", "boolean");
            this.put("Entity", "io.intino.ness.master.model.Entity");
            this.put("Long", "long");
            this.put("Date", "LocalDate");
            this.put("DateTime", "LocalDateTime");
            this.put("Instant", "Instant");
            this.put("Map", "Map");
        }
    };
    private static final Map<String, String> ListTypes = new HashMap<String, String>(){
        {
            this.put("String", "List<String>");
            this.put("Double", "List<Double>");
            this.put("Integer", "List<Integer>");
            this.put("Boolean", "List<Boolean");
            this.put("Entity", "List<io.intino.ness.master.model.Entity>");
            this.put("Long", "List<Long>");
            this.put("Date", "List<LocalDate>");
            this.put("DateTime", "List<LocalDateTime>");
            this.put("Instant", "List<Instant>");
            this.put("Map", "List<Map>");
        }
    };
    private static final Map<String, String> SetTypes = new HashMap<String, String>(){
        {
            this.put("String", "Set<String>");
            this.put("Double", "Set<Double>");
            this.put("Integer", "Set<Integer>");
            this.put("Boolean", "Set<Boolean");
            this.put("Entity", "Set<io.intino.ness.master.model.Entity>");
            this.put("Long", "Set<Long>");
            this.put("Date", "Set<LocalDate>");
            this.put("DateTime", "Set<LocalDateTime>");
            this.put("Instant", "Set<Instant>");
            this.put("Map", "Set<Map>");
        }
    };
    private final String workingPackage;
    private final Set<String> processedTypes = new HashSet<String>();

    public ValidatorFrameCreator(String workingPackage) {
        this.workingPackage = workingPackage;
    }

    public Map<String, Frame> create(Entity entity) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(4);
        map.put(this.calculateValidatorPath(entity, this.workingPackage), this.frameOf(entity).toFrame());
        if (entity.isDecorable()) {
            map.put(this.calculateDecorableValidatorPath(entity, this.workingPackage), this.frameOf(entity).add("decorable").toFrame());
        }
        return map;
    }

    private FrameBuilder frameOf(Entity entity) {
        this.processedTypes.clear();
        FrameBuilder builder = new FrameBuilder(new String[]{"validator", "class"}).add("package", (Object)(this.workingPackage + ".validators")).add("name", (Object)entity.core$().name()).add("attribute", (Object)entity.core$().componentList().stream().filter(c -> c.is(EntityData.class)).map(this::attrFrameOf).toArray()).add("type", (Object)entity.core$().componentList().stream().filter(c -> c.is(EntityData.class)).flatMap(c -> this.typeFramesOf((Node)c, entity.core$())).filter(Objects::nonNull).toArray());
        Parameter parent = this.parameter(entity.core$(), "entity");
        builder.add("parent", (Object)(parent != null ? ((Entity)parent.values().get(0)).name$() : "io.intino.ness.master.model.Entity"));
        if (entity.isDecorable() || entity.isAbstract()) {
            builder.add("isAbstract", (Object)"abstract");
        }
        if (entity.isDecorable()) {
            builder.add("abstract", (Object)"abstract");
        }
        return builder;
    }

    private Stream<Frame> typeFramesOf(Node node, Node parent) {
        String type = this.type(node);
        String typename = this.typename(type, node);
        String typeParameter = this.typeParameterOf(type);
        return this.typeFramesOf(node, parent, type, typename, typeParameter);
    }

    private Stream<Frame> typeFramesOf(Node node, Node parent, String type, String typename, String typeParameter) {
        if (!this.processedTypes.add(type.toLowerCase())) {
            return Stream.empty();
        }
        if (type.startsWith("List<") && typeParameter.equals("String")) {
            return Stream.empty();
        }
        if (type.startsWith("Set<") && typeParameter.equals("String")) {
            return Stream.empty();
        }
        LinkedList<Frame> frames = new LinkedList<Frame>();
        FrameBuilder builder = new FrameBuilder(new String[]{"type", typename}).add("typename", (Object)typename).add("name", (Object)typename).add("typeParameter", (Object)typeParameter).add("nameBoxed", (Object)this.boxed(type));
        if (node != null) {
            this.processTypeExtraInfo(node, parent, typeParameter, frames, builder);
        }
        frames.add(builder.toFrame());
        return frames.stream();
    }

    private void processTypeExtraInfo(Node node, Node parent, String typeParameter, List<Frame> frames, FrameBuilder builder) {
        if (!(typeParameter.isEmpty() || typeParameter.equals("Entity") || typeParameter.equals("String"))) {
            this.typeFramesOf(node, parent, typeParameter, typeParameter, "").forEach(frames::add);
        } else {
            Parameter struct;
            if (node.conceptList().stream().anyMatch(a -> a.name().equals("Word"))) {
                builder.add("word").add("package", (Object)(this.workingPackage + ".entities." + parent.name()));
            }
            if ((struct = this.parameter(node, "struct")) != null) {
                builder.add("struct").add("struct", (Object)this.structFrame((Struct)struct.values().get(0)));
            }
        }
    }

    private String typeParameterOf(String type) {
        if (!type.contains("List<") && !type.contains("Set<")) {
            return "";
        }
        return type.substring(type.indexOf("<") + 1).replace("io.intino.ness.master.model.", "").replace(">", "");
    }

    private String typename(String type, Node node) {
        if (!type.contains("<")) {
            return type;
        }
        return type.substring(0, type.indexOf(60));
    }

    private String boxed(String type) {
        return type.equals("int") ? "integer" : type;
    }

    private Frame attrFrameOf(Node node) {
        Parameter struct;
        Parameter format;
        Parameter defaultValue;
        Parameter values;
        FrameBuilder builder = new FrameBuilder().add("attribute");
        node.conceptList().forEach(aspect -> builder.add(aspect.name()));
        String type = this.type(node);
        builder.add("name", (Object)node.name()).add("owner", (Object)node.owner().name()).add("type", (Object)type).add("package", (Object)this.workingPackage);
        builder.add("index", (Object)node.owner().componentList().indexOf(node));
        builder.add("typename", (Object)this.typename(type, node));
        builder.add("typeParameter", (Object)this.typeParameterOf(type));
        boolean optional = node.conceptList().stream().anyMatch(a -> a.name().equals("Optional"));
        boolean required = node.conceptList().stream().anyMatch(a -> a.name().equals("Required"));
        if (required && optional) {
            Logger.warn((String)("Illegal combination of aspects: " + node.name() + " is declared both as Optional and Required. It will be set to Required."));
            optional = false;
        }
        if (optional) {
            builder.add("check", (Object)new FrameBuilder(new String[]{"optional", "warning"}).add("name", (Object)node.name()).toFrame());
        }
        if ((values = this.parameter(node, "values")) != null) {
            builder.add("value", (Object)values.values().stream().map(Object::toString).toArray());
        }
        if ((defaultValue = DefaultValueHelper.getDefaultValue(node)) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(node, type, defaultValue));
            if (!optional) {
                builder.add("optional", (Object)new FrameBuilder(new String[]{"optional"}).add("name", (Object)node.name()).toFrame());
            }
        } else if (!optional) {
            builder.add("check", (Object)new FrameBuilder(new String[]{"required"}).add("name", (Object)node.name()).toFrame());
        }
        if ((format = this.parameter(node, "format")) != null) {
            builder.add("format", format.values().get(0));
        } else if (type.contains("Date")) {
            builder.add("format", (Object)this.defaultFormat(type));
        }
        Parameter entity = this.parameter(node, "entity");
        if (entity != null) {
            builder.add("entity", (Object)((Entity)entity.values().get(0)).name$());
        }
        if ((struct = this.parameter(node, "struct")) != null) {
            builder.add("struct", (Object)this.structFrame((Struct)struct.values().get(0)));
        }
        this.addMissingAttributeCheckFrame(node, builder, required, optional);
        return builder.toFrame();
    }

    private void addMissingAttributeCheckFrame(Node node, FrameBuilder builder, boolean required, boolean optional) {
        FrameBuilder frame = required ? new FrameBuilder(new String[]{"check", "required"}) : (optional ? new FrameBuilder(new String[]{"check", "optional", "warning"}) : new FrameBuilder(new String[]{"check"}));
        builder.add("check", (Object)frame.add("name", (Object)node.name()).toFrame());
    }

    private String defaultFormat(String type) {
        return type.endsWith("LocalDateTime") ? "dd/MM/yyyy HH:mm:ss" : "dd/MM/yyyy";
    }

    private Frame structFrame(Struct node) {
        return new FrameBuilder(new String[]{"struct"}).add("name", (Object)node.core$().name()).add("package", (Object)this.workingPackage).add("attribute", (Object)node.attributeList().stream().map(Layer::core$).map(this::attrFrameOf).toArray()).toFrame();
    }

    private Frame defaultValue(Node c, String type, Parameter defaultValue) {
        FrameBuilder builder = new FrameBuilder((String[])c.conceptList().stream().map(Predicate::name).toArray(String[]::new));
        return builder.add("type", (Object)type).add("value", (Object)String.valueOf(defaultValue.values().get(0))).toFrame();
    }

    private String type(Node node) {
        String aspect = node.conceptList().stream().map(Predicate::name).filter(this::isProperTypeName).findFirst().orElse("");
        boolean list = node.conceptList().stream().anyMatch(a -> a.name().equals("List"));
        if (list) {
            return ListTypes.getOrDefault(aspect, "List<" + StringFormatters.firstUpperCase().format((Object)node.name()).toString() + ">");
        }
        boolean set = node.conceptList().stream().anyMatch(a -> a.name().equals("Set"));
        if (set) {
            return SetTypes.getOrDefault(aspect, "Set<" + StringFormatters.firstUpperCase().format((Object)node.name()).toString() + ">");
        }
        return TheTypes.getOrDefault(aspect, StringFormatters.firstUpperCase().format((Object)node.name()).toString());
    }

    private boolean isProperTypeName(String s) {
        return !s.equals("Set") && !s.equals("List") && !s.equals("Optional") && !s.equals("Type") && !s.equals("Required");
    }

    private Parameter parameter(Node c, String name) {
        List values = (List)c.variables().get(name);
        return values == null ? null : Parameter.of(values);
    }

    private String calculateValidatorPath(Entity entity, String aPackage) {
        return aPackage + ".validators." + (entity.isDecorable() ? "Abstract" : "") + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)(entity.name$() + "Validator")).toString());
    }

    private String calculateDecorableValidatorPath(Entity node, String aPackage) {
        return aPackage + ".validators." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)(node.name$() + "Validator")).toString());
    }
}

