/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.lookups;

import io.intino.datahub.model.Data;
import io.intino.datahub.model.Lookup;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.lookups.LookupTemplate;
import io.intino.ness.datahubterminalplugin.lookups.LookupsTemplate;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;

public class LookupRenderer {
    private final File destination;
    private final String rootPackage;

    public LookupRenderer(File destination, String rootPackage) {
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render(Lookup lookup) {
        String rootPackage = this.lookupsPackage();
        File packageFolder = new File(this.destination, rootPackage.replace(".", File.separator));
        Frame frame = this.buildFrame(lookup);
        Commons.writeFrame(packageFolder, lookup.name$(), this.template().render((Object)new FrameBuilder(new String[]{"root"}).add("root", (Object)rootPackage).add("package", (Object)rootPackage).add("lookup", (Object)frame)));
    }

    public void renderLookupsClass(List<Lookup> lookups) {
        File packageFolder = new File(this.destination, this.rootPackage.replace(".", File.separator));
        if (!lookups.isEmpty()) {
            Commons.writeFrame(packageFolder, "Lookups", this.lookupsClassTemplate().render((Object)this.renderLookups(lookups.stream())));
        }
    }

    private Frame renderLookups(Stream<Lookup> lookups) {
        LinkedHashSet namespaces = new LinkedHashSet();
        FrameBuilder fb = new FrameBuilder(new String[]{"lookups"});
        fb.add("package", (Object)this.rootPackage);
        lookups.forEach(l -> {
            this.renderLookup(this.rootPackage + ".lookups", fb, (Lookup)l);
            namespaces.add(l.namespace());
        });
        fb.add("namespace", (Object)namespaces.toArray(new String[0]));
        return fb.toFrame();
    }

    private void renderLookup(String lookupsPackage, FrameBuilder fb, Lookup l) {
        fb.add("lookup", (Object)new FrameBuilder(new String[]{"lookup"}).add("qn", (Object)(lookupsPackage + "." + Commons.firstUpperCase(l.name$()))).add("namespace", (Object)l.namespace()).add("name", (Object)l.name$()));
    }

    private Frame buildFrame(Lookup lookup) {
        FrameBuilder builder = new FrameBuilder(new String[]{"lookup"}).add("name", (Object)lookup.name$()).add("type", (Object)lookup.name$());
        builder.add("rootPackage", (Object)this.rootPackage);
        this.buildFrame(lookup, builder);
        return builder.toFrame();
    }

    private void buildFrame(Lookup lookup, FrameBuilder builder) {
        builder.add("dynamic");
        Lookup.Column idColumn = lookup.columnList().stream().filter(Data::isId).findFirst().orElse(null);
        this.addIndexes(builder, lookup.indexList(), idColumn);
        this.addDynamicColumns(builder, lookup.columnList());
        if (idColumn != null) {
            boolean idPrimitive = this.isPrimitive(idColumn.asType());
            builder.add("idColumnName", (Object)idColumn.name$()).add("idColumnType", (Object)(idPrimitive ? idColumn.asType().primitive() : idColumn.asType().type()));
        }
    }

    private void addIndexes(FrameBuilder builder, List<Lookup.Index> indices, Lookup.Column idColumn) {
        for (Lookup.Index index : indices) {
            Lookup lookup = (Lookup)index.core$().ownerAs(Lookup.class);
            List columns = index.columns();
            builder.add("index", (Object)new FrameBuilder(new String[]{"index", index.createOnClose() ? "onClose" : "onOpen"}).add("name", (Object)index.name$()).add("table", (Object)((Lookup)index.core$().ownerAs(Lookup.class)).name$()).add("idxColumn", columns.stream().map(c -> this.frameOf((Lookup.Column)c, this.indexOf((Lookup.Column)c))).toArray(FrameBuilder[]::new)).add("column", lookup.columnList().stream().map(c -> this.frameOf((Lookup.Column)c, this.indexOf((Lookup.Column)c)).add(columns.contains(c) ? "idx" : "regular")).toArray(FrameBuilder[]::new)));
        }
        if (idColumn != null) {
            builder.add("index", (Object)new FrameBuilder(new String[]{"index", "id", "onOpen"}).add("name", (Object)idColumn.name$()).add("table", (Object)((Lookup)idColumn.core$().ownerAs(Lookup.class)).name$()).add("idxColumn", (Object)this.frameOf(idColumn, this.indexOf(idColumn))).add("column", ((Lookup)idColumn.core$().ownerAs(Lookup.class)).columnList().stream().map(c -> this.frameOf((Lookup.Column)c, this.indexOf((Lookup.Column)c)).add(c.equals(idColumn) ? "idx" : "regular")).toArray(FrameBuilder[]::new)));
        }
    }

    private int indexOf(Lookup.Column c) {
        return ((Lookup)c.core$().ownerAs(Lookup.class)).columnList().indexOf(c);
    }

    private void addDynamicColumns(FrameBuilder builder, List<Lookup.Column> columnList) {
        Lookup.Column idColumn = columnList.stream().filter(Data::isId).findFirst().orElse(null);
        for (int i = 0; i < columnList.size(); ++i) {
            Lookup.Column column = columnList.get(i);
            FrameBuilder b = this.frameOf(column, i);
            if (idColumn != null) {
                b.add("hasId").add("idColumnName", (Object)idColumn.name$()).add("idColumnType", (Object)(this.isPrimitive(idColumn.asType()) ? idColumn.asType().primitive() : idColumn.asType().type()));
            }
            builder.add("column", (Object)b.toFrame());
        }
    }

    private FrameBuilder frameOf(Lookup.Column column, int index) {
        FrameBuilder builder = new FrameBuilder(new String[]{"column"}).add(column.isId() ? "id" : "regular").add(this.isPrimitive(column.asType()) ? "primitive" : "complex").add("table", (Object)((Lookup)column.core$().ownerAs(Lookup.class)).name$()).add("name", (Object)column.name$()).add("index", (Object)index).add("type", (Object)this.type(column)).add("typePrimitive", (Object)this.typePrimitive(column));
        column.core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).forEach(arg_0 -> ((FrameBuilder)builder).add(arg_0));
        if (column.isWordFromBag()) {
            builder.add("category").add("lookup", (Object)column.asWordFromBag().wordbag().name$());
        }
        return builder;
    }

    private String typePrimitive(Lookup.Column column) {
        if (this.isPrimitive(column.asType())) {
            return column.asType().primitive();
        }
        if (column.isWordFromBag()) {
            return "int";
        }
        return column.asType().type();
    }

    private String type(Lookup.Column column) {
        if (this.isPrimitive(column.asType())) {
            return column.asType().primitive();
        }
        if (column.isWordFromBag()) {
            return Commons.firstUpperCase(column.asWordFromBag().wordbag().name$()) + ".Entry";
        }
        return column.asType().type();
    }

    private boolean isPrimitive(Data.Type attribute) {
        Data data = attribute.asData();
        return data.isBool() || data.isInteger() || data.isLongInteger() || data.isReal();
    }

    private Template template() {
        return Formatters.customize(new LookupTemplate());
    }

    private String lookupsPackage() {
        return this.rootPackage + ".lookups";
    }

    private Template lookupsClassTemplate() {
        return Formatters.customize(new LookupsTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

