package io.intino.ness.datahubterminalplugin.terminal;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class TerminalTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((type("terminal"))).output(literal("package ")).output(mark("package", "validPackage")).output(literal(";\n\nimport io.intino.alexandria.Scale;\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.event.Event;\nimport io.intino.alexandria.logger.Logger;\nimport org.apache.activemq.command.ActiveMQTextMessage;\n\nimport javax.jms.JMSException;\nimport javax.jms.Message;\nimport javax.jms.TextMessage;\nimport java.io.File;\nimport java.time.Instant;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Collections;\nimport java.util.concurrent.TimeUnit;\nimport java.util.stream.Collectors;\n\nimport java.lang.reflect.Field;\nimport java.lang.reflect.Method;\n\n")).output(expression().output(mark("entities", "import"))).output(literal("\n\npublic class ")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(" {\n\tpublic static String[] subscriptionChannels = new String[]{")).output(mark("subscribe", "channel")).output(literal("};\n\n\tprivate final io.intino.alexandria.terminal.Connector connector;\n\tprivate final java.util.Map<java.util.function.BiConsumer<?, String>, List<java.util.function.Consumer<io.intino.alexandria.event.Event>>> consumers = new java.util.HashMap<>();\n\t")).output(mark("bpm", "splits")).output(literal("\n\t")).output(expression().output(mark("entities", "declaration"))).output(literal("\n\n\tpublic ")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("(io.intino.alexandria.terminal.Connector connector) {\n\t\tthis.connector = connector;\n\t}\n\n\tpublic void publish(Object event, String split) {\n\t\t")).output(mark("publish", "if").multiple("\n")).output(literal("\n\t}\n\n\t")).output(expression().output(mark("entities", "getter"))).output(literal("\n\n\tpublic io.intino.alexandria.datalake.Datalake datalake() {\n\t\ttry {\n\t\t\tMessage message = connector.requestResponse(\"service.ness.datalake.eventstore\", request(\"Datalake\"), 5, TimeUnit.SECONDS);\n\t\t\tif(message == null) return null;\n\n\t\t\tString path = ((TextMessage)message).getText();\n\t\t\tif(path == null) return null;\n\n\t\t\treturn new File(path).exists()\n\t\t\t\t\t? new io.intino.alexandria.datalake.file.FileDatalake(new File(path))\n\t\t\t\t\t: new io.intino.alexandria.terminal.remotedatalake.RemoteDatalake((io.intino.alexandria.terminal.JmsConnector) connector);\n\n\t\t} catch (JMSException e) {\n\t\t\tLogger.error(e);\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tpublic BatchSession batch(java.io.File temporalStageDirectory) {\n\t\treturn new BatchSession(temporalStageDirectory);\n\t}\n\n\tpublic BatchSession batch(java.io.File temporalStageDirectory, Config config) {\n\t\treturn new BatchSession(temporalStageDirectory, config);\n\t}\n\n\tpublic void publish(io.intino.alexandria.event.SessionEvent session) {\n\t\tconnector.sendEvent(io.intino.alexandria.event.SessionEvent.PATH, session);\n\t}\n\n\tpublic void subscribe(SessionEventConsumer onEventReceived) {\n\t\tconsumers.put(onEventReceived, List.of(event -> onEventReceived.accept(new io.intino.alexandria.event.SessionEvent(event.toMessage()), io.intino.alexandria.event.SessionEvent.PATH)));\n\t\tconnector.attachListener(io.intino.alexandria.event.SessionEvent.PATH, consumers.get(onEventReceived).get(0));\n\t}\n\n\t")).output(mark("publish").multiple("\n\n")).output(literal("\n\n\t")).output(mark("subscribe").multiple("\n\n")).output(literal("\n\n\tpublic synchronized void requestSeal() {\n\t\tconnector.requestResponse(\"service.ness.seal\", request(\"Seal\"), 30, TimeUnit.MINUTES);\n\t}\n\n\tpublic synchronized Instant requestLastSeal() {\n\t\tMessage message = connector.requestResponse(\"service.ness.seal.last\", request(\"LastSeal\"), 10, TimeUnit.MINUTES);\n\t\tif(message == null) return Instant.now();\n\t\ttry {\n\t\t\treturn Instant.parse(((TextMessage)message).getText());\n\t\t} catch (Exception e) {\n\t\t\tLogger.error(e);\n\t\t\treturn Instant.now();\n\t\t}\n\t}\n\n\tprivate javax.jms.Message request(String type) {\n\t\treturn request(type, Collections.emptyMap());\n\t}\n\n\tprivate javax.jms.Message request(String type, Map<String, String> attributes) {\n\t\ttry {\n\t\t\tActiveMQTextMessage m = new ActiveMQTextMessage();\n\t\t\tio.intino.alexandria.message.Message message = new io.intino.alexandria.message.Message(type);\n\t\t\tattributes.forEach(message::set);\n\t\t\tm.setText(new Event(message).ts(java.time.Instant.now()).toString());\n\t\t\treturn m;\n\t\t} catch(Exception e) {\n\t\t\tthrow new RuntimeException(e);\n\t\t}\n\t}\n\n\tpublic class BatchSession {\n\t\tprivate final java.io.File temporalStage;\n\t\tprivate final io.intino.alexandria.ingestion.SessionHandler sessionHandler;\n\t\tprivate final io.intino.alexandria.ingestion.EventSession eventSession;\n\t\tprivate final io.intino.alexandria.ingestion.SetSession setSession;\n\t\tprivate final Scale scale;\n\n\t\tpublic BatchSession(java.io.File temporalStage) {\n\t\t\tthis(temporalStage, new Config());\n\t\t}\n\n\t\tpublic BatchSession(java.io.File temporalStage, Config config) {\n\t\t\tthis.temporalStage = temporalStage;\n\t\t\tthis.scale = config.scale;\n\t\t\tthis.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);\n\t\t\tthis.eventSession = sessionHandler.createEventSession(config.eventsBufferSize);\n\t\t\tthis.setSession = sessionHandler.createSetSession(config.setsBufferSize);\n\t\t}\n\n\t\tpublic void feed(Event event, String split) {\n            eventSession.put(tankOf(event, split), Timetag.of(event.ts(), this.scale), event);\n\t\t}\n\n\t\tpublic void feed(Event event, String split, Scale scale) {\n\t\t\teventSession.put(tankOf(event, split), Timetag.of(event.ts(), scale), event);\n\t\t}\n\n\t\tpublic void feed(io.intino.alexandria.event.SessionEvent event) {\n\t\t\teventSession.put(io.intino.alexandria.event.SessionEvent.PATH, Timetag.of(event.ts(), Scale.Day), event);\n\t\t}\n\n\t\tpublic void flush() {\n\t\t\teventSession.flush();\n\t\t\tsetSession.flush();\n\t\t}\n\n\t\tpublic void push(File dataHubStage) {\n\t\t\teventSession.close();\n\t\t\tsetSession.close();\n\t\t\tsessionHandler.pushTo(dataHubStage);\n\t\t\t//connector.sendEvent(\"service.ness.push\", new Event(new io.intino.alexandria.message.Message(\"Push\").set(\"stage\", temporalStage.getName())));\n\t\t}\n\n\t\tpublic void push(String host, String user, String dataHubStageAbsolutePath) {\n\t\t\teventSession.close();\n\t\t\tsetSession.close();\n\t\t\tList<File> files = io.intino.alexandria.ingestion.FS.allFilesIn(temporalStage, path -> path.getName().endsWith(io.intino.alexandria.Session.SessionExtension)).collect(Collectors.toList());\n\t\t\tupload(files, host, user, dataHubStageAbsolutePath);\n\t\t\ttemporalStage.renameTo(new File(temporalStage.getParentFile(), temporalStage.getName() + \".treated\"));\n\t\t}\n\n\t\tpublic synchronized void seal() {\n\t\t\tconnector.requestResponse(\"service.ness.seal\", request(\"Seal\", Map.of(\"stage\", temporalStage.getName())));\n    \t}\n\n        private void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {\n\t\t\ttry {\n\t\t\t\tString connectionChain = user + \"@\" + host + \":\" + dataHubStageAbsolutePath;\n\t\t\t\tLogger.info(\"Uploading sessions to \" + connectionChain + \"...\");\n\t\t\t\tfor (File s : sessions) {\n\t\t\t\t\tProcess process = new ProcessBuilder(\"scp\", s.getAbsolutePath(), connectionChain)\n\t\t\t\t\t\t\t.inheritIO()\n\t\t\t\t\t\t\t.start();\n\t\t\t\t\tprocess.waitFor(1, java.util.concurrent.TimeUnit.HOURS);\n\t\t\t\t}\n\t\t\t\tLogger.info(\"sessions uploaded\");\n\t\t\t} catch (java.io.IOException | InterruptedException ignored) {\n\t\t\t}\n\n\t\t}\n\n        private String tankOf(Event event, String split) {\n        \t")).output(mark("publish", "tankOf").multiple("\n")).output(literal("\n        \treturn event.toMessage().type();\n        }\n\t}\n\n\tpublic static class Config {\n\t\tprivate int eventsBufferSize = 1_000_000;\n\t\tprivate int setsBufferSize = 1_000_000;\n\t\tprivate Scale scale = Scale.")).output(mark("scale")).output(literal(";\n\n\t\tpublic Config scale(Scale scale) {\n\t\t\tthis.scale = scale;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Config eventsBufferSize(int eventsBufferSize) {\n\t\t\tthis.eventsBufferSize = eventsBufferSize;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Config setsBufferSize(int setsBufferSize) {\n\t\t\tthis.setsBufferSize = setsBufferSize;\n\t\t\treturn this;\n\t\t}\n\t}\n\n\tpublic interface SessionEventConsumer extends java.util.function.BiConsumer<io.intino.alexandria.event.SessionEvent, String> {\n\t}\n\n\t")).output(mark("event", "interface").multiple("\n\n")).output(literal("\n}")),
			rule().condition((type("entities")), (trigger("import"))).output(literal("import ")).output(mark("package", "validPackage")).output(literal(".master.Entities;")),
			rule().condition((type("entities")), (trigger("declaration"))).output(literal("private volatile Entities entities;")),
			rule().condition((type("entities")), (trigger("getter"))).output(literal("public Entities entities() {\n\treturn entities != null ? entities : initEntities();\n}\n\nprivate synchronized Entities initEntities() {\n\tCachedEntities entities = new CachedEntities(connector);\n\tsetSingletonInstance(entities);\n\tentities.init();\n\tthis.entities = entities;\n\treturn entities;\n}\n\nprivate void setSingletonInstance(Entities entities) {\n\ttry {\n\t\tEntities.Singleton singleton = getEntitiesSingleton();\n    \tMethod method = Entities.Singleton.class.getDeclaredMethod(\"set\", Entities.class);\n    \tmethod.setAccessible(true);\n    \tmethod.invoke(singleton, entities);\n    \tmethod.setAccessible(false);\n\t} catch(Exception e) {\n\t\tthrow new RuntimeException(\"Failed to initialize Entities singleton: \" + e.getMessage(), e);\n\t}\n}\n\nprivate Entities.Singleton getEntitiesSingleton() throws Exception {\n\tField field = Entities.class.getField(\"Instance\");\n\treturn (Entities.Singleton) field.get(null);\n}")),
			rule().condition((type("bpm")), (trigger("splits"))).output(literal("public enum BpmSplit {\n\t")).output(mark("split", "asEnum").multiple(", ")).output(literal(";\n\n\tpublic abstract String qn();\n\n\tpublic static BpmSplit splitByQn(String qn) {\n\t\treturn java.util.Arrays.stream(values()).filter(c -> c.qn().equals(qn)).findFirst().orElse(null);\n\t}\n}")),
			rule().condition((trigger("asenum"))).output(mark("value", "snakeCaseToCamelCase")).output(literal(" {\n\tpublic String qn() {\n\t\treturn \"")).output(mark("qn")).output(literal("\";\n\t}\n}")),
			rule().condition((allTypes("multisplit","bpm")), (trigger("if"))).output(literal("if (event instanceof ")).output(mark("type")).output(literal(") publish((")).output(mark("type")).output(literal(") event, BpmSplit.splitByQn(split));")),
			rule().condition((type("multisplit")), (trigger("if"))).output(literal("if (event instanceof ")).output(mark("type")).output(literal(") publish((")).output(mark("type")).output(literal(") event, ")).output(mark("type")).output(literal(".Split.splitByQn(split));")),
			rule().condition((trigger("if"))).output(literal("if (event instanceof ")).output(mark("type")).output(literal(") publish((")).output(mark("type")).output(literal(") event);")),
			rule().condition((type("multisplit")), not(type("bpm")), (trigger("tankof"))).output(literal("if (event instanceof ")).output(mark("type")).output(literal(") return \"")).output(mark("typeWithNamespace")).output(literal(".\" + ")).output(mark("type")).output(literal(".Split.splitByQn(split).qn();")),
			rule().condition(not(type("bpm")), (trigger("tankof"))).output(literal("if (event instanceof ")).output(mark("type")).output(literal(") return \"")).output(mark("channel")).output(literal("\";")),
			rule().condition((allTypes("bpm","multisplit")), (trigger("publish"))).output(literal("public void publish(")).output(mark("type")).output(literal(" ")).output(mark("typeName", "firstLowerCase")).output(literal(", BpmSplit split, BpmSplit... moreSplits) {\n\tconnector.sendEvent(\"")).output(mark("typeWithNamespace")).output(literal(".\" + split.qn(), ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n\tfor (BpmSplit c : moreSplits) connector.sendEvent(\"")).output(mark("typeWithNamespace")).output(literal(".\" + c.qn(), ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n}")),
			rule().condition((type("bpm")), (trigger("publish"))).output(literal("public void publish(")).output(mark("type")).output(literal(" ")).output(mark("typeName", "firstLowerCase")).output(literal(") {\n\tconnector.sendEvent(\"")).output(mark("channel")).output(literal("\", ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n}")),
			rule().condition((type("multisplit")), not(type("bpm")), (trigger("publish"))).output(literal("public void publish(")).output(mark("type")).output(literal(" ")).output(mark("typeName", "firstLowerCase")).output(literal(", ")).output(mark("type")).output(literal(".Split split, ")).output(mark("type")).output(literal(".Split... moreSplits) {\n\tconnector.sendEvent(\"")).output(mark("typeWithNamespace")).output(literal(".\" + split.qn(), ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n\tfor (")).output(mark("type")).output(literal(".Split c : moreSplits)\n\t\tconnector.sendEvent(\"")).output(mark("typeWithNamespace")).output(literal(".\" + c.qn(), ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n}")),
			rule().condition(not(type("bpm")), (trigger("publish"))).output(literal("public void publish(")).output(mark("type")).output(literal(" ")).output(mark("typeName", "firstLowerCase")).output(literal(") {\n\tconnector.sendEvent(\"")).output(mark("channel")).output(literal("\", ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n}")),
			rule().condition((allTypes("bpm","multiSplit")), (trigger("subscribe"))).output(literal("public void subscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, String subscriberId, BpmSplit split, BpmSplit... moreSplits) {\n\tconsumers.putIfAbsent(onEventReceived, new java.util.ArrayList<>());\n\tList<java.util.function.Consumer<io.intino.alexandria.event.Event>> eventConsumers = consumers.get(onEventReceived);\n\tjava.util.function.Consumer<io.intino.alexandria.event.Event> consumer = event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeName", "FirstUpperCase")).output(literal(".\" + split.qn());\n\tconnector.attachListener(\"")).output(mark("typeName", "FirstUpperCase")).output(literal(".\" + split.qn(), subscriberId + \"_\" + split.qn(), consumer);\n\teventConsumers.add(consumer);\n\tfor (BpmSplit c : moreSplits) {\n\t\tconsumer = event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeName", "FirstUpperCase")).output(literal(".\" + c.qn());\n\t\teventConsumers.add(consumer);\n\t\tconnector.attachListener(\"")).output(mark("typeName", "FirstUpperCase")).output(literal(".\" + c.qn(), subscriberId + \"_\" + c.qn(), consumer);\n\t}\n}\n\npublic void subscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, BpmSplit split, BpmSplit... moreSplits) {\n\tconsumers.put(onEventReceived, List.of(event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeName", "FirstUpperCase")).output(literal(".\" + split.qn())));\n\tList<java.util.function.Consumer<io.intino.alexandria.event.Event>> eventConsumers = consumers.get(onEventReceived);\n\tjava.util.function.Consumer<io.intino.alexandria.event.Event> consumer = event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeName")).output(literal(".\" + split.qn());\n\tconnector.attachListener(\"")).output(mark("typeName", "FirstUpperCase")).output(literal(".\" + split.qn(), consumer);\n\teventConsumers.add(consumer);\n\tfor (BpmSplit c : moreSplits) {\n\t\tconsumer = event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeName", "FirstUpperCase")).output(literal(".\" + c.qn());\n\t\teventConsumers.add(consumer);\n\t\tconnector.attachListener(\"")).output(mark("typeName", "FirstUpperCase")).output(literal(".\" + c.qn(), consumer);\n\t}\n}\n\npublic void unsubscribe(ProcessStatusConsumer onEventReceived) {\n\tconsumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));\n}")),
			rule().condition((type("multiSplit")), not(type("bpm")), (trigger("subscribe"))).output(literal("public void subscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, String subscriberId, ")).output(mark("type")).output(literal(".Split split, ")).output(mark("type")).output(literal(".Split... moreSplits) {\n\tconsumers.putIfAbsent(onEventReceived, new java.util.ArrayList<>());\n\tList<java.util.function.Consumer<io.intino.alexandria.event.Event>> eventConsumers = consumers.get(onEventReceived);\n\tjava.util.function.Consumer<io.intino.alexandria.event.Event> consumer = event -> { try { onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeWithNamespace")).output(literal(".\" + split.qn());} catch(Throwable e) { Logger.error(e); }};\n\tconnector.attachListener(\"")).output(mark("typeWithNamespace")).output(literal(".\" + split.qn(), subscriberId + \"_\" + split.qn(), consumer);\n\teventConsumers.add(consumer);\n\tfor (")).output(mark("type")).output(literal(".Split s : moreSplits) {\n\t\tconsumer = event -> { try { onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeWithNamespace")).output(literal(".\" + s.qn());} catch(Throwable e) { Logger.error(e); }};\n\t\tconnector.attachListener(\"")).output(mark("typeWithNamespace")).output(literal(".\" + s.qn(), subscriberId + \"_\" + s.qn(), consumer);\n\t\teventConsumers.add(consumer);\n\t}\n}\n\npublic void subscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter, ")).output(mark("type")).output(literal(".Split split, ")).output(mark("type")).output(literal(".Split... moreSplits) {\n\tconsumers.putIfAbsent(onEventReceived, new java.util.ArrayList<>());\n\tList<java.util.function.Consumer<io.intino.alexandria.event.Event>> eventConsumers = consumers.get(onEventReceived);\n\tjava.util.function.Consumer<io.intino.alexandria.event.Event> consumer = event -> { try { onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeWithNamespace")).output(literal(".\" + split.qn());} catch(Throwable e) { Logger.error(e); }};\n\tconnector.attachListener(\"")).output(mark("typeWithNamespace")).output(literal(".\" + split.qn(), subscriberId + \"_\" + split.qn(), consumer, filter);\n\teventConsumers.add(consumer);\n\tfor (")).output(mark("type")).output(literal(".Split s : moreSplits) {\n\t\tconsumer = event -> { try { onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeWithNamespace")).output(literal(".\" + s.qn());} catch(Throwable e) { Logger.error(e); }};\n\t\tconnector.attachListener(\"")).output(mark("typeWithNamespace")).output(literal(".\" + s.qn(), subscriberId + \"_\" + s.qn(), consumer, filter);\n\t\teventConsumers.add(consumer);\n\t}\n}\n\npublic void subscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, ")).output(mark("type")).output(literal(".Split split, ")).output(mark("type")).output(literal(".Split... moreSplits) {\n\tconsumers.putIfAbsent(onEventReceived, new java.util.ArrayList<>());\n\tList<java.util.function.Consumer<io.intino.alexandria.event.Event>> eventConsumers = consumers.get(onEventReceived);\n\tjava.util.function.Consumer<io.intino.alexandria.event.Event> consumer = event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeWithNamespace")).output(literal(".\" + split.qn());\n\tconnector.attachListener(\"")).output(mark("typeWithNamespace")).output(literal(".\" + split.qn(), consumer);\n\teventConsumers.add(consumer);\n\tfor (")).output(mark("type")).output(literal(".Split s : moreSplits) {\n\t\tconsumer = event -> { try { onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("typeWithNamespace")).output(literal(".\" + s.qn());} catch(Throwable e) { Logger.error(e); }};\n\t\tconnector.attachListener(\"")).output(mark("typeWithNamespace")).output(literal(".\" + s.qn(), consumer);\n\t\teventConsumers.add(consumer);\n\t}\n}\n\npublic void unsubscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName")).output(literal("Consumer onEventReceived) {\n\tconsumers.get(onEventReceived).forEach(c-> connector.detachListeners(c));\n}")),
			rule().condition((trigger("subscribe"))).output(literal("public void subscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, String subscriberId) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("channel")).output(literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")).output(mark("channel")).output(literal("\", subscriberId, consumers.get(onEventReceived).get(0));\n}\n\npublic void subscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("channel")).output(literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")).output(mark("channel")).output(literal("\", subscriberId, consumers.get(onEventReceived).get(0), filter);\n}\n\npublic void subscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")).output(mark("type")).output(literal("(event), \"")).output(mark("channel")).output(literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")).output(mark("channel")).output(literal("\", consumers.get(onEventReceived).get(0));\n}\n\npublic void unsubscribe(")).output(mark("namespaceQn", "firstUpperCase")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived) {\n\tconsumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));\n}")),
			rule().condition((trigger("quoted"))).output(literal("\"")).output(mark("")).output(literal("\"")),
			rule().condition((trigger("interface"))).output(literal("public interface ")).output(mark("namespaceQn", "firstUpperCase")).output(mark("name", "firstUpperCase")).output(literal("Consumer extends java.util.function.BiConsumer<")).output(mark("type")).output(literal(", String> {\n}"))
		);
	}
}