package io.intino.ness.datahubterminalplugin.master;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class ValidatorTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((allTypes("validationLayer","class"))).output(literal("package ")).output(mark("package")).output(literal(";\n\npublic class ")).output(mark("module", "FirstUpperCase")).output(literal("RecordValidationLayer extends io.intino.ness.master.data.validation.RecordValidationLayer {\n\n\tpublic ")).output(mark("module", "FirstUpperCase")).output(literal("RecordValidationLayer() {\n\t\t")).output(expression().output(mark("entity", "putValidator").multiple("\n"))).output(literal("\n\t}\n}")),
			rule().condition((allTypes("validator","decorable"))).output(literal("package ")).output(mark("package")).output(literal(";\n\npublic class ")).output(mark("name", "FirstUpperCase")).output(literal("Validator extends Abstract")).output(mark("name", "FirstUpperCase")).output(literal("Validator {\n\n}")),
			rule().condition((allTypes("validator","class"))).output(literal("package ")).output(mark("package")).output(literal(";\n\nimport io.intino.ness.master.data.validation.Issue;\nimport io.intino.ness.master.data.validation.RecordValidator;\nimport io.intino.ness.master.data.validation.RecordValidator.TripletRecord;\nimport io.intino.ness.master.data.validation.FieldValidator;\nimport io.intino.ness.master.data.validation.TripletRecordStore;\n\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Objects;\nimport java.util.stream.Stream;\n\nimport static io.intino.ness.master.data.validation.Issue.Type.*;\n\npublic ")).output(expression().output(literal(" ")).output(mark("isAbstract", "firstLowerCase"))).output(literal(" class ")).output(mark("abstract", "FirstUpperCase")).output(mark("name", "FirstUpperCase")).output(literal("Validator implements RecordValidator {\n\n\tprotected final Map<String, FieldValidator> validatorsPerField = new java.util.HashMap<>(); {\n\t\t")).output(expression().output(mark("attribute", "attribValidatorMap").multiple("\n"))).output(literal("\n\t}\n\n\t@Override\n\tpublic Stream<Issue> validate(TripletRecord record, TripletRecordStore store) {\n\t\treturn validatorsPerField.keySet().stream()\n\t\t\t.map(attrib -> validate(attrib, record.get(attrib), record, store))\n\t\t\t.filter(Objects::nonNull)\n\t\t\t.reduce(Stream::concat).orElse(Stream.empty());\n\t}\n\n\tprotected Stream<Issue> validate(String attrib, List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t\treturn validatorsPerField.getOrDefault(attrib, FieldValidator.none()).validate(values, record, store);\n\t}\n\n\t")).output(expression().output(mark("attribute", "validationMethod").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("type", "checkType").multiple("\n\n"))).output(literal("\n\n\tprotected boolean isListOfString(String value, TripletRecordStore store) {\n\t\ttry {\n\t\t\tjava.util.Arrays.stream(value.split(LIST_SEPARATOR)).collect(java.util.stream.Collectors.toList());\n\t\t\treturn true;\n\t\t} catch(Exception e) {\n\t\t \treturn false;\n\t\t}\n\t}\n\n\tprotected boolean isSetOfString(String value, TripletRecordStore store) {\n\t\ttry {\n\t\t\tjava.util.Arrays.stream(value.split(LIST_SEPARATOR)).collect(java.util.stream.Collectors.toSet());\n\t\t\treturn true;\n\t\t} catch(Exception e) {\n\t\t \treturn false;\n\t\t}\n\t}\n\n\tprotected boolean isEntity(String id, TripletRecordStore store) {\n\t\treturn store.get(id) != null;\n\t}\n}")),
			rule().condition((type("attribute")), (trigger("attribvalidatormap"))).output(literal("validatorsPerField.put(\"")).output(mark("name", "firstLowerCase")).output(literal("\", this::validate")).output(mark("name", "FirstUpperCase")).output(literal(");")),
			rule().condition((allTypes("attribute","list")), (trigger("validationmethod"))).output(literal("protected Stream<Issue> validate")).output(mark("name", "FirstUpperCase")).output(literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")).output(mark("check", "attributeNotDefined")).output(literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n\treturn isListOf")).output(mark("typeParameter", "FirstUpperCase")).output(literal("(values.get(0).get(), store)\n\t\t? Stream.empty()\n\t\t: Stream.of(Issue.error(INVALID_VALUE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is an invalid ")).output(mark("type")).output(literal(": \" + values.get(0).get()).source(values.get(0).source()));\n}")),
			rule().condition((allTypes("attribute","set")), (trigger("validationmethod"))).output(literal("protected Stream<Issue> validate")).output(mark("name", "FirstUpperCase")).output(literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")).output(mark("check", "attributeNotDefined")).output(literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n\treturn isSetOf")).output(mark("typeParameter", "FirstUpperCase")).output(literal("(values.get(0).get(), store)\n\t\t? Stream.empty()\n\t\t: Stream.of(Issue.error(INVALID_VALUE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is an invalid ")).output(mark("type")).output(literal(": \" + values.get(0).get()).source(values.get(0).source()));\n}")),
			rule().condition((allTypes("attribute","entity")), (trigger("validationmethod"))).output(literal("protected Stream<Issue> validate")).output(mark("name", "FirstUpperCase")).output(literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")).output(mark("check", "attributeNotDefined")).output(literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n    return store.get(values.get(0).get()) != null\n    \t? Stream.empty()\n    \t: Stream.of(Issue.error(INVALID_REFERENCE, \"{\"+record.id()+\"} \" + \"")).output(mark("name", "FirstUpperCase")).output(literal(" \" + values.get(0).get() + \" does not exist.\").source(values.get(0).source()));\n}")),
			rule().condition((type("attribute")), not(type("string")), (trigger("validationmethod"))).output(literal("protected Stream<Issue> validate")).output(mark("name", "FirstUpperCase")).output(literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")).output(mark("check", "attributeNotDefined")).output(literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n\treturn is")).output(mark("typename", "FirstUpperCase")).output(literal("(values.get(0).get(), store)\n\t\t? Stream.empty()\n\t\t: Stream.of(Issue.error(INVALID_VALUE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is an invalid ")).output(mark("type")).output(literal(": \" + values.get(0).get()).source(values.get(0).source()));\n}")),
			rule().condition((type("attribute")), (type("string")), (trigger("validationmethod"))).output(literal("protected Stream<Issue> validate")).output(mark("name", "FirstUpperCase")).output(literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")).output(mark("check", "attributeNotDefined")).output(literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n\treturn Stream.empty();\n}")),
			rule().condition((allTypes("check","required")), (trigger("attributenotdefined"))).output(literal("if(values.isEmpty() || values.get(0).isEmpty()) return Stream.of(Issue.error(MISSING_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is not defined.\").source(record.source()));")),
			rule().condition((allTypes("check","optional","warning")), (trigger("attributenotdefined"))).output(literal("if(values.isEmpty() || values.get(0).isEmpty()) return Stream.of(Issue.warning(MISSING_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")).output(mark("name")).output(literal(" is not defined.\").source(record.source()));")),
			rule().condition((type("check")), (trigger("attributenotdefined"))).output(literal("if(values.isEmpty() || values.get(0).isEmpty()) return Stream.empty();")),
			rule().condition((type("type")), (anyTypes("double","long","boolean")), (trigger("checktype"))).output(literal("protected boolean is")).output(mark("name", "FirstUpperCase")).output(literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\t")).output(mark("nameBoxed", "FirstUpperCase")).output(literal(".parse")).output(mark("name", "FirstUpperCase")).output(literal("(value);\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")),
			rule().condition((type("type")), (type("integer")), (trigger("checktype"))).output(literal("protected boolean isInteger(String value, TripletRecordStore store) {\n\ttry {\n\t\tInteger.parseInt(value);\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")),
			rule().condition((type("type")), (type("localdate")), (trigger("checktype"))).output(literal("protected boolean is")).output(mark("name", "FirstUpperCase")).output(literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tjava.time.LocalDate.parse(value, java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"));\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")),
			rule().condition((type("type")), (type("localdatetime")), (trigger("checktype"))).output(literal("protected boolean is")).output(mark("name", "FirstUpperCase")).output(literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tjava.time.LocalDateTime.parse(value, java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\"));\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")),
			rule().condition((type("type")), (type("instant")), (trigger("checktype"))).output(literal("protected boolean is")).output(mark("name", "FirstUpperCase")).output(literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tjava.time.Instant.ofEpochMilli(Long.parseLong(value));\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")),
			rule().condition((type("type")), (anyTypes("list","set")), (trigger("checktype"))).output(literal("protected boolean is")).output(mark("typename", "FirstUpperCase")).output(literal("Of")).output(mark("typeParameter", "FirstUpperCase")).output(literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tList<String> list = java.util.Arrays.stream(value.split(LIST_SEPARATOR)).collect(java.util.stream.Collectors.toList());\n\t\tfor(String item : list)\n\t\t\tif(!is")).output(mark("typeParameter", "FirstUpperCase")).output(literal("(item, store))\n\t\t\t\treturn false;\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")),
			rule().condition((type("type")), (type("map")), (trigger("checktype"))).output(literal("protected boolean is")).output(mark("name", "FirstUpperCase")).output(literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tjava.util.Arrays.stream(value.split(LIST_SEPARATOR))\n\t\t\t.map(e -> e.split(MAP_KEY_VALUE_SEPARATOR))\n\t\t\t.collect(java.util.stream.Collectors.toMap(e -> e[0].trim(), e -> e[1].trim()));\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")),
			rule().condition((type("type")), (type("struct")), (trigger("checktype"))).output(literal("protected boolean is")).output(mark("name", "FirstUpperCase")).output(literal("(String value, TripletRecordStore store) {\n\ttry {\n    \tList<String> values = java.util.Arrays.stream(value.split(STRUCT_FIELD_SEPARATOR, -1)).map(v -> v.trim()).collect(java.util.stream.Collectors.toList());\n        ")).output(mark("struct", "call")).output(literal(";\n        return true;\n    } catch(Exception e) {\n    \treturn false;\n    }\n}")),
			rule().condition((type("type")), (type("word")), (trigger("checktype"))).output(literal("protected boolean is")).output(mark("name", "FirstUpperCase")).output(literal("(String value, TripletRecordStore store) {\n\ttry {\n    \t")).output(mark("package")).output(literal(".")).output(mark("name", "FirstUpperCase")).output(literal(".valueOf(value);\n        return true;\n    } catch(Exception e) {\n    \treturn false;\n    }\n}")),
			rule().condition((trigger("call"))).output(literal("new ")).output(mark("package")).output(literal(".structs.")).output(mark("name", "firstUpperCase")).output(literal("(")).output(mark("attribute", "parse").multiple(", ")).output(literal(")")),
			rule().condition((type("boolean")), (trigger("parse"))).output(literal("Boolean.parseBoolean(values.get(")).output(mark("index")).output(literal("))")),
			rule().condition((type("integer")), (trigger("parse"))).output(literal("Integer.parseInt(values.get(")).output(mark("index")).output(literal("))")),
			rule().condition((type("long")), (trigger("parse"))).output(literal("Long.parseLong(values.get(")).output(mark("index")).output(literal("))")),
			rule().condition((type("double")), (trigger("parse"))).output(literal("Double.parseDouble(values.get(")).output(mark("index")).output(literal("))")),
			rule().condition((type("localdate")), (trigger("parse"))).output(literal("java.time.LocalDate.parse(values.get(")).output(mark("index")).output(literal("));")),
			rule().condition((type("localdatetime")), (trigger("parse"))).output(literal("java.time.LocalDateTime.parse(values.get(")).output(mark("index")).output(literal("));")),
			rule().condition((type("instant")), (trigger("parse"))).output(literal("java.time.Instant.parse(values.get(")).output(mark("index")).output(literal("));")),
			rule().condition((trigger("parse"))).output(literal("values.get(")).output(mark("index")).output(literal(")")),
			rule().condition((type("entity")), not(type("abstract")), (trigger("putvalidator"))).output(literal("validatorsPerType.put(\"")).output(mark("name", "firstLowerCase")).output(literal("\", new ")).output(mark("name", "FirstUpperCase")).output(literal("Validator());"))
		);
	}
}