/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.event;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class WordbagTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("root"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(";\n\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Predicate;\nimport java.util.stream.Collectors;\n\n")}).output(new Rule.Output[]{this.mark("dimension", new String[0])}), this.rule().condition(this.allTypes(new String[]{"wordbag", "resource"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" {\n\tprivate static final java.util.Map<Integer, Word> words;\n\tprivate static final java.util.Map<String, Word> wordsByName;\n\tpublic static final Word NA = new Word(")}).output(new Rule.Output[]{this.mark("column", new String[]{"defaultValue"}).multiple(", ")}).output(new Rule.Output[]{this.literal(");\n\tstatic {\n\t\twords = new java.util.HashMap<>();\n\t\twordsByName = new java.util.HashMap<>();\n\t\ttry (java.io.BufferedReader reader = new java.io.BufferedReader(new java.io.InputStreamReader(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class.getResourceAsStream(\"/")}).output(new Rule.Output[]{this.mark("resource", new String[0])}).output(new Rule.Output[]{this.literal("\")))) {\n\t\t\treader.lines().map(l -> l.split(\"\\t\", -1)).\n\t\t\tmap(l -> new Word(")}).output(new Rule.Output[]{this.mark("column", new String[]{"constructor"}).multiple(", ")}).output(new Rule.Output[]{this.literal(")).\n\t\t\tforEach(w -> {words.put(w.index, w); wordsByName.put(w.name, w);});\n\t\t} catch (java.io.IOException e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e);\n\t\t}\n\t}\n\n\tpublic static List<Word> words() {\n\t\treturn new ArrayList<>(words.values());\n\t}\n\n\tpublic static List<Word> words(Predicate<Word> filter) {\n\t\treturn words.values().stream().filter(filter).collect(Collectors.toList());\n\t}\n\n\tpublic static Word categoryByIndex(int index) {\n\t\treturn words.getOrDefault(index, NA);\n\t}\n\n\tpublic static Word categoryByName(String name) {\n\t\treturn wordsByName.getOrDefault(name, NA);\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("column", new String[]{"find"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tpublic static class Word {\n\t\t")}).output(new Rule.Output[]{this.mark("column", new String[]{"declaration"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\t\tWord(")}).output(new Rule.Output[]{this.mark("column", new String[]{"parameter"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\t\t\t")}).output(new Rule.Output[]{this.mark("column", new String[]{"assign"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t}\n\n\t\tpublic boolean equals(Word category) {\n\t\t\treturn this.index == category.index;\n\t\t}\n\t}\n}")}), this.rule().condition(this.type("wordbag"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" {\n\tprivate static final java.util.Map<Short, Word> words;\n\tprivate static final java.util.Map<String, Word> wordsByName;\n\tpublic static final Word NA = new Word((short) 0, \"NA\");\n\t")}).output(new Rule.Output[]{this.mark("category", new String[]{"field"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\tstatic {\n\t\twords = new java.util.HashMap<>();\n\t\twordsByName = new java.util.HashMap<>();\n\t\t")}).output(new Rule.Output[]{this.mark("category", new String[]{"put"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tpublic static List<Word> words() {\n\t\treturn new ArrayList<>(words.values());\n\t}\n\n\tpublic static List<Word> words(Predicate<Word> filter) {\n\t\treturn words.values().stream().filter(filter).collect(Collectors.toList());\n\t}\n\n\tpublic static Word categoryByIndex(short index) {\n\t\treturn words.getOrDefault(index, NA);\n\t}\n\n\tpublic static Word categoryByName(String name) {\n\t\treturn wordsByName.getOrDefault(name, NA);\n\t}\n\n\tpublic static Word categoryByLabel(String label) {\n\t\treturn words.values().stream().filter(c -> c.label.equals(label)).findFirst().orElse(NA);\n\t}\n\n\tpublic static class Word {\n\t\tpublic final short index;\n\t\tpublic final String name;\n\t\tpublic final String label;\n\n\t\tWord(short index, String name) {\n\t\t\tthis(index, name, name);\n\t\t}\n\n\t\tWord(short index, String name, String label) {\n\t\t\tthis.index = index;\n\t\t\tthis.name = name;\n\t\t\tthis.label = label;\n\t\t}\n\n\t\tpublic boolean equals(Word category) {\n\t\t\treturn this.index == category.index;\n\t\t}\n\t}\n}")}), this.rule().condition(this.trigger("declaration"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public final ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.trigger("parameter"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}), this.rule().condition(this.anyTypes(new String[]{"string", "text"}), new Rule.Condition[]{this.trigger("constructor")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("] : \"NA\"")}), this.rule().condition(this.type("integer"), new Rule.Condition[]{this.trigger("constructor")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? Integer.parseInt(l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("]) : -1")}), this.rule().condition(this.type("real"), new Rule.Condition[]{this.trigger("constructor")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? Double.parseDouble(l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("]) : Double.NaN")}), this.rule().condition(this.anyTypes(new String[]{"longInteger", "long"}), new Rule.Condition[]{this.trigger("constructor")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? Long.parseLong(l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("]) : -1L")}), this.rule().condition(this.anyTypes(new String[]{"boolean", "bool"}), new Rule.Condition[]{this.trigger("constructor")}).output(new Rule.Output[]{this.literal("l.length > ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(" ? Boolean.parseBoolean(l[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("]) : false")}), this.rule().condition(this.anyTypes(new String[]{"string", "text"}), new Rule.Condition[]{this.trigger("defaultvalue")}).output(new Rule.Output[]{this.literal("\"NA\"")}), this.rule().condition(this.type("integer"), new Rule.Condition[]{this.trigger("defaultvalue")}).output(new Rule.Output[]{this.literal("0")}), this.rule().condition(this.type("real"), new Rule.Condition[]{this.trigger("defaultvalue")}).output(new Rule.Output[]{this.literal("0.")}), this.rule().condition(this.anyTypes(new String[]{"longInteger", "long"}), new Rule.Condition[]{this.trigger("defaultvalue")}).output(new Rule.Output[]{this.literal("0L")}), this.rule().condition(this.anyTypes(new String[]{"boolean", "bool"}), new Rule.Condition[]{this.trigger("defaultvalue")}).output(new Rule.Output[]{this.literal("false")}), this.rule().condition(this.trigger("assign"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("this.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(";")}), this.rule().condition(this.type("primitive"), new Rule.Condition[]{this.not(this.attribute("index", "0")), this.not(this.attribute("index", "1")), this.trigger("find")}).output(new Rule.Output[]{this.literal("public static Word categoryBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\treturn words.values().stream().filter(c -> c.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" == ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(").findFirst().orElse(NA);\n}")}), this.rule().condition(this.not(this.attribute("index", "0")), new Rule.Condition[]{this.not(this.attribute("index", "1")), this.trigger("find")}).output(new Rule.Output[]{this.literal("public static Word categoryBy")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(") {\n\treturn words.values().stream().filter(c -> c.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".equals(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(")).findFirst().orElse(NA);\n}")}), this.rule().condition(this.trigger("put"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("words.put((short) ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");\nwordsByName.put(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.trigger("field"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public static final Word ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" = new Word((short) ")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", \"")}).output(new Rule.Output[]{this.mark("label", new String[0])}).output(new Rule.Output[]{this.literal("\"")})}).output(new Rule.Output[]{this.literal(");")})});
    }
}

