/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.terminal;

import com.google.gson.Gson;
import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Event;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Terminal;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.IntinoException;
import io.intino.ness.datahubterminalplugin.Manifest;
import io.intino.ness.datahubterminalplugin.MavenTerminalExecutor;
import io.intino.ness.datahubterminalplugin.Version;
import io.intino.ness.datahubterminalplugin.terminal.TerminalRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TerminalPublisher {
    private final File root;
    private final Terminal terminal;
    private final Configuration conf;
    private final Map<String, String> versions;
    private final PluginLauncher.SystemProperties systemProperties;
    private final String basePackage;
    private final PluginLauncher.Phase invokedPhase;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private final boolean includeMaster;
    private final List<Datalake.Tank.Event> tanks;

    public TerminalPublisher(File root, Terminal terminal, List<Datalake.Tank.Event> tanks, Configuration configuration, Map<String, String> versions, PluginLauncher.SystemProperties systemProperties, PluginLauncher.Phase invokedPhase, PrintStream logger, PluginLauncher.Notifier notifier, boolean includeMaster) {
        this.root = root;
        this.terminal = terminal;
        this.tanks = tanks;
        this.conf = configuration;
        this.versions = versions;
        this.systemProperties = systemProperties;
        this.basePackage = configuration.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifact().name()).toString().toLowerCase();
        this.invokedPhase = invokedPhase;
        this.logger = logger;
        this.notifier = notifier;
        this.includeMaster = includeMaster;
    }

    public boolean publish() {
        try {
            if (!this.createSources()) {
                return false;
            }
            this.logger.println("Publishing " + this.terminal.name$() + "...");
            new MavenTerminalExecutor(this.root, this.basePackage, this.includeMaster ? MavenTerminalExecutor.Target.EventsAndMaster : MavenTerminalExecutor.Target.Events, this.terminalNameArtifact(), this.versions, this.conf, this.systemProperties, this.logger).mvn(this.invokedPhase == PluginLauncher.Phase.INSTALL ? "install" : "deploy");
            this.logger.println("Terminal " + this.terminal.name$() + " published!");
            return true;
        }
        catch (Throwable e) {
            this.logger.println(e.getMessage() == null ? e.toString() : e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkPublish() {
        try {
            Version version = new Version(this.conf.artifact().version());
            if (!(version.isSnapshot() || this.invokedPhase != PluginLauncher.Phase.DISTRIBUTE && this.invokedPhase != PluginLauncher.Phase.DEPLOY)) {
                return false;
            }
        }
        catch (IntinoException e) {
            return false;
        }
        return true;
    }

    private boolean createSources() {
        File srcDirectory = new File(this.root, "src");
        srcDirectory.mkdirs();
        Map<Event, Datalake.Split> eventSplitMap = this.collectEvents(this.tanks);
        if (this.duplicatedEvents()) {
            return false;
        }
        new TerminalRenderer(this.terminal, eventSplitMap, srcDirectory, this.basePackage).render();
        File resDirectory = new File(this.root, "res");
        resDirectory.mkdirs();
        this.writeManifest(resDirectory);
        return true;
    }

    private boolean duplicatedEvents() {
        Set duplicatedSubscribe;
        Set duplicatedPublish = this.terminal.publish() != null ? this.findDuplicates(this.terminal.publish().tanks().stream().map(Datalake.Tank.Event::qn).collect(Collectors.toList())) : Collections.emptySet();
        Set<Object> set = duplicatedSubscribe = this.terminal.subscribe() != null ? this.findDuplicates(this.terminal.subscribe().tanks().stream().map(Datalake.Tank.Event::qn).collect(Collectors.toList())) : Collections.emptySet();
        if (!duplicatedPublish.isEmpty()) {
            this.logger.println("Duplicated publishing event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            this.notifier.notifyError("Duplicated publishing event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            return true;
        }
        if (!duplicatedSubscribe.isEmpty()) {
            this.logger.println("Duplicated subscription event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            this.notifier.notifyError("Duplicated subscription event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            return true;
        }
        return false;
    }

    public Set<String> findDuplicates(List<String> listContainingDuplicates) {
        HashSet set = new HashSet();
        return listContainingDuplicates.stream().filter(yourInt -> !set.add(yourInt)).collect(Collectors.toSet());
    }

    private void writeManifest(File srcDirectory) {
        List<String> publish = this.terminal.publish() != null ? this.terminal.publish().tanks().stream().map(this::eventQn).collect(Collectors.toList()) : Collections.emptyList();
        List<String> subscribe = this.terminal.subscribe() != null ? this.terminal.subscribe().tanks().stream().map(this::eventQn).collect(Collectors.toList()) : Collections.emptyList();
        Manifest manifest = new Manifest(this.terminal.name$(), this.basePackage + "." + Formatters.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString()), publish, subscribe, this.tankClasses(), this.eventSplits());
        try {
            Files.write(new File(srcDirectory, "terminal.mf").toPath(), new Gson().toJson((Object)manifest).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String namespace(Event event) {
        return event.core$().owner().is(Namespace.class) ? ((Namespace)event.core$().ownerAs(Namespace.class)).qn() + "." : "";
    }

    private String terminalNameArtifact() {
        return Formatters.firstLowerCase(Formatters.camelCaseToSnakeCase().format((Object)this.terminal.name$()).toString());
    }

    private Map<String, Set<String>> eventSplits() {
        HashMap<String, Set<String>> eventSplits;
        Map<String, Set<String>> map = eventSplits = this.terminal.publish() == null ? new HashMap<String, Set<String>>() : this.eventSplitOf(this.terminal.publish().tanks());
        if (this.terminal.subscribe() == null) {
            return eventSplits;
        }
        Map<String, Set<String>> subscribeEventSplits = this.eventSplitOf(this.terminal.subscribe().tanks());
        for (String eventType : subscribeEventSplits.keySet()) {
            if (!eventSplits.containsKey(eventType)) {
                eventSplits.put(eventType, new HashSet());
            }
            ((Set)eventSplits.get(eventType)).addAll((Collection)subscribeEventSplits.get(eventType));
        }
        return eventSplits;
    }

    private Map<String, Set<String>> eventSplitOf(List<Datalake.Tank.Event> tanks) {
        return tanks.stream().collect(Collectors.toMap(this::eventQn, tank -> tank.asTank().isSplitted() ? tank.asTank().asSplitted().split().leafs().stream().map(Datalake.Split::qn).collect(Collectors.toSet()) : Collections.emptySet(), (a, b) -> b));
    }

    private Map<String, String> tankClasses() {
        HashMap<String, String> tankClasses = new HashMap<String, String>();
        if (this.terminal.publish() != null) {
            this.terminal.publish().tanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Event)t), this.basePackage + ".events." + this.namespace(t.event()).toLowerCase() + t.event().name$()));
        }
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().tanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Event)t), this.basePackage + ".events." + this.namespace(t.event()).toLowerCase() + t.event().name$()));
        }
        if (this.terminal.bpm() != null) {
            Datalake.Split split = this.terminal.bpm().split();
            String statusQn = this.terminal.bpm().processStatusClass();
            String statusClassName = statusQn.substring(statusQn.lastIndexOf(".") + 1);
            tankClasses.put((String)(split != null ? split.qn() + "." : "") + statusClassName, statusQn);
        }
        return tankClasses;
    }

    private String eventQn(Datalake.Tank.Event t) {
        return this.namespace(t.event()) + t.event().name$();
    }

    private Map<Event, Datalake.Split> collectEvents(List<Datalake.Tank.Event> tanks) {
        HashMap<Event, Datalake.Split> events = new HashMap<Event, Datalake.Split>();
        for (Datalake.Tank.Event tank : tanks) {
            List<Event> hierarchy = this.hierarchy(tank.event());
            Datalake.Split split = tank.asTank().isSplitted() ? tank.asTank().asSplitted().split() : null;
            events.put(hierarchy.get(0), split);
            hierarchy.remove(0);
            hierarchy.forEach(e -> events.put((Event)e, (Datalake.Split)null));
        }
        return events;
    }

    private List<Event> hierarchy(Event event) {
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        events.add(event);
        if (event.isExtensionOf()) {
            events.addAll(this.hierarchy(event.asExtensionOf().parent()));
        }
        return new ArrayList<Event>(events);
    }
}

