/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class ValidatorTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"validationLayer", "class"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\npublic class ")}).output(new Rule.Output[]{this.mark("module", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("RecordValidationLayer extends io.intino.ness.master.data.validation.RecordValidationLayer {\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("module", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("RecordValidationLayer() {\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"putValidator"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"validator", "decorable"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Validator extends Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Validator {\n\n}")}), this.rule().condition(this.allTypes(new String[]{"validator", "class"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.ness.master.data.validation.Issue;\nimport io.intino.ness.master.data.validation.RecordValidator;\nimport io.intino.ness.master.data.validation.RecordValidator.TripletRecord;\nimport io.intino.ness.master.data.validation.FieldValidator;\nimport io.intino.ness.master.data.validation.TripletRecordStore;\n\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Objects;\nimport java.util.stream.Stream;\n\nimport static io.intino.ness.master.data.validation.Issue.Type.*;\n\npublic ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("isAbstract", new String[]{"firstLowerCase"})})}).output(new Rule.Output[]{this.literal(" class ")}).output(new Rule.Output[]{this.mark("abstract", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Validator implements RecordValidator {\n\n\tprotected final Map<String, FieldValidator> validatorsPerField = new java.util.HashMap<>(); {\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("attribute", new String[]{"attribValidatorMap"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n\n\t@Override\n\tpublic Stream<Issue> validate(TripletRecord record, TripletRecordStore store) {\n\t\treturn validatorsPerField.keySet().stream()\n\t\t\t.map(attrib -> validate(attrib, record.get(attrib), record, store))\n\t\t\t.filter(Objects::nonNull)\n\t\t\t.reduce(Stream::concat).orElse(Stream.empty());\n\t}\n\n\tprotected Stream<Issue> validate(String attrib, List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t\treturn validatorsPerField.getOrDefault(attrib, FieldValidator.none()).validate(values, record, store);\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("attribute", new String[]{"validationMethod"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("type", new String[]{"checkType"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\tprotected boolean isListOfString(String value, TripletRecordStore store) {\n\t\ttry {\n\t\t\tjava.util.Arrays.stream(value.split(LIST_SEPARATOR)).collect(java.util.stream.Collectors.toList());\n\t\t\treturn true;\n\t\t} catch(Exception e) {\n\t\t \treturn false;\n\t\t}\n\t}\n\n\tprotected boolean isEntity(String id, TripletRecordStore store) {\n\t\treturn store.get(id) != null;\n\t}\n}")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.trigger("attribvalidatormap")}).output(new Rule.Output[]{this.literal("validatorsPerField.put(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\", this::validate")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.allTypes(new String[]{"attribute", "list"}), new Rule.Condition[]{this.trigger("validationmethod")}).output(new Rule.Output[]{this.literal("protected Stream<Issue> validate")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("required", new String[]{"attributeNotDefined"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("optional", new String[]{"attributeNotDefined"})})}).output(new Rule.Output[]{this.literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n\treturn isListOf")}).output(new Rule.Output[]{this.mark("typeParameter", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(values.get(0).get(), store)\n\t\t? Stream.empty()\n\t\t: Stream.of(Issue.error(INVALID_VALUE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" is an invalid ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(": \" + values.get(0).get()).source(values.get(0).source()));\n}")}), this.rule().condition(this.allTypes(new String[]{"attribute", "entity"}), new Rule.Condition[]{this.trigger("validationmethod")}).output(new Rule.Output[]{this.literal("protected Stream<Issue> validate")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("required", new String[]{"attributeNotDefined"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("optional", new String[]{"attributeNotDefined"})})}).output(new Rule.Output[]{this.literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n    return store.get(values.get(0).get()) != null\n    \t? Stream.empty()\n    \t: Stream.of(Issue.error(INVALID_REFERENCE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" \" + values.get(0).get() + \" does not exist.\").source(values.get(0).source()));\n}")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.not(this.type("string")), this.trigger("validationmethod")}).output(new Rule.Output[]{this.literal("protected Stream<Issue> validate")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("required", new String[]{"attributeNotDefined"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("optional", new String[]{"attributeNotDefined"})})}).output(new Rule.Output[]{this.literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n\treturn is")}).output(new Rule.Output[]{this.mark("typename", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(values.get(0).get(), store)\n\t\t? Stream.empty()\n\t\t: Stream.of(Issue.error(INVALID_VALUE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" is an invalid ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(": \" + values.get(0).get()).source(values.get(0).source()));\n}")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.type("string"), this.trigger("validationmethod")}).output(new Rule.Output[]{this.literal("protected Stream<Issue> validate")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(List<TripletRecord.Value> values, TripletRecord record, TripletRecordStore store) {\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("required", new String[]{"attributeNotDefined"})})}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("optional", new String[]{"attributeNotDefined"})})}).output(new Rule.Output[]{this.literal("\n\tif(values.size() > 1) return Stream.of(Issue.error(DUPLICATED_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" is defined \" + values.size() + \" times.\").source(values.get(0).source()));\n\treturn Stream.empty();\n}")}), this.rule().condition(this.type("required"), new Rule.Condition[]{this.trigger("attributenotdefined")}).output(new Rule.Output[]{this.literal("if(values.isEmpty() || values.get(0).isEmpty()) return Stream.of(Issue.error(MISSING_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" is not defined.\").source(record.source()));")}), this.rule().condition(this.allTypes(new String[]{"optional", "warning"}), new Rule.Condition[]{this.trigger("attributenotdefined")}).output(new Rule.Output[]{this.literal("if(values.isEmpty() || values.get(0).isEmpty()) return Stream.of(Issue.warning(MISSING_ATTRIBUTE, \"{\"+record.id()+\"} \" + \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" is not defined.\").source(record.source()));")}), this.rule().condition(this.type("optional"), new Rule.Condition[]{this.trigger("attributenotdefined")}).output(new Rule.Output[]{this.literal("if(values.isEmpty() || values.get(0).isEmpty()) return Stream.empty();")}), this.rule().condition(this.type("type"), new Rule.Condition[]{this.anyTypes(new String[]{"double", "long", "boolean"}), this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean is")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\t")}).output(new Rule.Output[]{this.mark("nameBoxed", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".parse")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(value);\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")}), this.rule().condition(this.type("type"), new Rule.Condition[]{this.type("integer"), this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean isInteger(String value, TripletRecordStore store) {\n\ttry {\n\t\tInteger.parseInt(value);\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")}), this.rule().condition(this.type("type"), new Rule.Condition[]{this.type("localdate"), this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean is")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tjava.time.LocalDate.parse(value, java.time.format.DateTimeFormatter.ofPattern(\"")}).output(new Rule.Output[]{this.mark("format", new String[0])}).output(new Rule.Output[]{this.literal("\"));\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")}), this.rule().condition(this.type("type"), new Rule.Condition[]{this.type("localdatetime"), this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean is")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tjava.time.LocalDateTime.parse(value, java.time.format.DateTimeFormatter.ofPattern(\"")}).output(new Rule.Output[]{this.mark("format", new String[0])}).output(new Rule.Output[]{this.literal("\"));\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")}), this.rule().condition(this.type("type"), new Rule.Condition[]{this.type("instant"), this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean is")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tjava.time.Instant.ofEpochMilli(Long.parseLong(value));\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")}), this.rule().condition(this.type("type"), new Rule.Condition[]{this.type("list"), this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean is")}).output(new Rule.Output[]{this.mark("typename", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Of")}).output(new Rule.Output[]{this.mark("typeParameter", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tList<String> list = java.util.Arrays.stream(value.split(LIST_SEPARATOR)).collect(java.util.stream.Collectors.toList());\n\t\tfor(String item : list)\n\t\t\tif(!is")}).output(new Rule.Output[]{this.mark("typeParameter", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(item, store))\n\t\t\t\treturn false;\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")}), this.rule().condition(this.type("type"), new Rule.Condition[]{this.type("map"), this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean is")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String value, TripletRecordStore store) {\n\ttry {\n\t\tjava.util.Arrays.stream(value.split(LIST_SEPARATOR))\n\t\t\t.map(e -> e.split(MAP_KEY_VALUE_SEPARATOR))\n\t\t\t.collect(java.util.stream.Collectors.toMap(e -> e[0].trim(), e -> e[1].trim()));\n\t\treturn true;\n\t} catch(Exception e) {\n\t \treturn false;\n\t}\n}")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean is")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String value, TripletRecordStore store) {\n\ttry {\n    \tList<String> values = java.util.Arrays.stream(value.split(STRUCT_FIELD_SEPARATOR, -1)).map(v -> v.trim()).collect(java.util.stream.Collectors.toList());\n        ")}).output(new Rule.Output[]{this.mark("struct", new String[]{"call"})}).output(new Rule.Output[]{this.literal(";\n        return true;\n    } catch(Exception e) {\n    \treturn false;\n    }\n}")}), this.rule().condition(this.type("word"), new Rule.Condition[]{this.trigger("checktype")}).output(new Rule.Output[]{this.literal("protected boolean is")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String value, TripletRecordStore store) {\n\ttry {\n    \t")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".valueOf(value);\n        return true;\n    } catch(Exception e) {\n    \treturn false;\n    }\n}")}), this.rule().condition(this.trigger("call"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".structs.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("attribute", new String[]{"parse"}).multiple(", ")}).output(new Rule.Output[]{this.literal(")")}), this.rule().condition(this.type("boolean"), new Rule.Condition[]{this.trigger("parse")}).output(new Rule.Output[]{this.literal("Boolean.parseBoolean(values.get(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("))")}), this.rule().condition(this.type("integer"), new Rule.Condition[]{this.trigger("parse")}).output(new Rule.Output[]{this.literal("Integer.parseInt(values.get(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("))")}), this.rule().condition(this.type("double"), new Rule.Condition[]{this.trigger("parse")}).output(new Rule.Output[]{this.literal("Double.parseDouble(values.get(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("))")}), this.rule().condition(this.type("localdate"), new Rule.Condition[]{this.trigger("parse")}).output(new Rule.Output[]{this.literal("java.time.LocalDate.parse(values.get(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("));")}), this.rule().condition(this.type("localdatetime"), new Rule.Condition[]{this.trigger("parse")}).output(new Rule.Output[]{this.literal("java.time.LocalDateTime.parse(values.get(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("));")}), this.rule().condition(this.type("instant"), new Rule.Condition[]{this.trigger("parse")}).output(new Rule.Output[]{this.literal("java.time.Instant.parse(values.get(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("));")}), this.rule().condition(this.trigger("parse"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("values.get(")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal(")")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.not(this.type("abstract")), this.trigger("putvalidator")}).output(new Rule.Output[]{this.literal("validatorsPerType.put(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\", new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Validator());")})});
    }
}

