/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.DefaultValueHelper;
import io.intino.ness.datahubterminalplugin.master.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StructFrameCreator {
    private static final String DOT = ".";
    private static final Map<String, String> types = Map.of("String", "String", "Double", "double", "Integer", "int", "Boolean", "boolean", "Entity", "io.intino.ness.master.model.Entity", "Long", "long");
    private static final Map<String, String> listTypes = Map.of("String", "List<String>", "Double", "List<Double>", "Integer", "List<Integer>", "Boolean", "List<Boolean", "Entity", "List<io.intino.ness.master.model.Entity>", "Long", "List<Long>");
    private final String workingPackage;

    public StructFrameCreator(String workingPackage) {
        this.workingPackage = workingPackage;
    }

    public Map<String, Frame> create(Struct struct) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(4);
        map.put(this.calculateStructPath(struct, this.workingPackage), this.frameOf(struct).toFrame());
        return map;
    }

    private FrameBuilder frameOf(Struct struct) {
        return new FrameBuilder(new String[]{"struct", "class"}).add("package", (Object)this.workingPackage).add("name", (Object)struct.name$()).add("attribute", (Object)struct.attributeList().stream().map(this::attrFrameOf).toArray());
    }

    private Frame attrFrameOf(Struct.Attribute attr) {
        String entity;
        Parameter defaultValue;
        List values;
        FrameBuilder builder = new FrameBuilder().add("attribute");
        String type = this.type(attr);
        builder.add(type);
        builder.add("name", (Object)attr.name$()).add("owner", (Object)attr.core$().owner().name()).add("type", (Object)type);
        if (attr.isList()) {
            builder.add("list");
        }
        List list = values = attr.isWord() ? attr.asWord().values() : null;
        if (values != null) {
            builder.add("value", (Object)values.toArray());
        }
        if ((defaultValue = DefaultValueHelper.getDefaultValue(attr.core$())) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(attr, type, defaultValue));
        }
        String string = entity = attr.isEntity() ? attr.asEntity().entity().name$() : null;
        if (entity != null) {
            builder.add("entity", (Object)entity);
        }
        return builder.toFrame();
    }

    private Frame defaultValue(Struct.Attribute attr, String type, Parameter defaultValue) {
        FrameBuilder builder = new FrameBuilder((String[])attr.core$().conceptList().stream().map(Predicate::name).toArray(String[]::new));
        return builder.add("type", (Object)type).add("value", (Object)defaultValue.values().get(0).toString()).toFrame();
    }

    private String type(Struct.Attribute attribute) {
        String type = StructFrameCreator.getType(attribute);
        if (!attribute.isList()) {
            return types.getOrDefault(type, StringFormatters.firstUpperCase().format((Object)attribute.name$()).toString());
        }
        return listTypes.getOrDefault(type, "List<" + StringFormatters.firstUpperCase().format((Object)attribute.name$()).toString() + ">");
    }

    private static String getType(Struct.Attribute attribute) {
        Optional<String> type = attribute.core$().layerList().stream().filter(StructFrameCreator::isEntityData).findFirst();
        if (type.isEmpty()) {
            throw new IllegalStateException("Cannot find type of attribute " + attribute + " in " + attribute.core$().owner().name());
        }
        return type.get().substring(type.get().indexOf("$") + 1);
    }

    private static boolean isEntityData(String layer) {
        return layer.startsWith("EntityData$") && !layer.equals("EntityData$Type");
    }

    private String calculateStructPath(Struct struct, String aPackage) {
        return aPackage + ".structs." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)struct.name$()).toString());
    }
}

