/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class MasterTerminalTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"master", "view"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport java.util.Arrays;\nimport java.util.List;\nimport java.util.UUID;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.*;\n\npublic interface MasterView {\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"getterSignature"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.allTypes(new String[]{"master", "interface"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport java.util.Arrays;\nimport java.util.Map;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.UUID;\nimport java.util.concurrent.Future;\nimport java.util.concurrent.CompletableFuture;\nimport io.intino.ness.master.model.TripletRecord;\nimport io.intino.ness.master.messages.listeners.EntityListener;\nimport io.intino.ness.master.messages.listeners.ErrorListener;\nimport io.intino.ness.master.messages.Response;\nimport io.intino.ness.master.model.Entity;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.*;\n\npublic interface MasterTerminal extends MasterView {\n\n\tstatic MasterTerminal create() {\n\t\treturn create(new MasterTerminal.Config());\n\t}\n\n\tstatic MasterTerminal create(MasterTerminal.Config config) {\n\t\tif(config.type() == Type.FullLoad) return new FullLoadMasterTerminal(config);\n\t\tif(config.type() == Type.LazyLoad) return new LazyLoadMasterTerminal(config);\n\t\tthrow new IllegalArgumentException(\"Unknown MasterTerminal type \" + config.type());\n\t}\n\n\tvoid start();\n\tvoid stop();\n\n\t<T extends Entity> Future<Response<T>> enable(String entityId);\n\t<T extends Entity> Future<Response<T>> disable(String entityId);\n\t<T extends Entity> Future<Response<T>> publish(Entity entity);\n\n\tMasterView disabled();\n\n\tMasterTerminal.Config config();\n\n\tio.intino.ness.master.serialization.MasterSerializer serializer();\n\n\tvoid addErrorListener(ErrorListener listener);\n\n\t<T extends Entity> void addEntityListener(String type, EntityListener<T> listener);\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"entityListener"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t@SuppressWarnings(\"unchecked\")\n\tdefault <T extends Entity> T asEntity(TripletRecord record) {\n\t\tif(record == null) return null;\n\t\tswitch(record.type()) {\n\t\t\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"asEntitySwitchCase"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t\tdefault: throw new IllegalArgumentException(\"Unknown entity type \" + record.type());\n\t\t}\n\t}\n\n\tenum Type {\n\t\t/**\n\t\t* <p>All records will be loaded into local-memory maps on start.</p>\n\t\t*/\n\t\tFullLoad,\n\n\t\t/**\n\t\t* <p>Records will be loaded from the master backend on demand.</p>\n\t\t*/\n\t\tLazyLoad;\n\n\t\tpublic static Type getDefault() {return FullLoad;}\n\t\tpublic static Type byName(String name) {return Arrays.stream(values()).filter(e -> e.name().equalsIgnoreCase(name)).findFirst().orElse(null);}\n\t}\n\n\tenum EntityFilter {\n\t\tOnlyEnabled, OnlyDisabled, All\n\t}\n\n\tfinal class Config {\n\n\t\tprivate String clientName = \"")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".MasterTerminal-\" + UUID.randomUUID();\n\t\tprivate List<String> addresses = List.of(\"localhost:5701\");\n\t\tprivate Type type = Type.getDefault();\n\t\tprivate boolean allowWriting = false;\n\t\tprivate boolean multithreadLoading = true;\n\t\tprivate EntityFilter filter = EntityFilter.OnlyEnabled;\n\t\tprivate boolean cacheDisabledView = true;\n\t\tprivate final Map<String, String> properties = new HashMap<>() {{\n\t\t\tput(\"hazelcast.logging.type\", \"none\");\n\t\t\tput(\"master.log.initialization_complete\", \"true\");\n\t\t}};\n\n\t\tpublic Config() {}\n\n\t\tpublic Config(Config other) {\n\t\t\tthis.clientName = other.clientName;\n\t\t\tthis.addresses = other.addresses == null ? null : List.copyOf(other.addresses);\n\t\t\tthis.type = other.type;\n\t\t\tthis.allowWriting = other.allowWriting;\n\t\t\tthis.multithreadLoading = other.multithreadLoading;\n\t\t\tthis.filter = other.filter;\n\t\t\tthis.cacheDisabledView = other.cacheDisabledView;\n\t\t\tthis.properties.putAll(other.properties);\n\t\t}\n\n\t\tpublic String clientName() {\n\t\t\treturn clientName;\n\t\t}\n\n\t\tpublic Config clientName(String clientName) {\n\t\t\tthis.clientName = clientName;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic List<String> addresses() {\n\t\t\treturn addresses;\n\t\t}\n\n\t\tpublic Config addresses(List<String> addresses) {\n\t\t\tthis.addresses = addresses;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Type type() {\n\t\t\treturn type;\n\t\t}\n\n\t\tpublic Config type(Type type) {\n\t\t\tthis.type = type;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic boolean allowWriting() {\n\t\t\treturn allowWriting;\n\t\t}\n\n\t\tpublic Config allowWriting(boolean allowWriting) {\n\t\t\tthis.allowWriting = allowWriting;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic boolean multithreadLoading() {\n\t\t\treturn multithreadLoading;\n\t\t}\n\n\t\tpublic Config multithreadLoading(boolean multithreadLoading) {\n\t\t\tthis.multithreadLoading = multithreadLoading;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic EntityFilter filter() {\n\t\t\treturn filter;\n\t\t}\n\n\t\tpublic Config filter(EntityFilter filter) {\n\t\t\tthis.filter = filter == null ? EntityFilter.OnlyEnabled : filter;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic boolean cacheDisabledView() {\n\t\t\treturn cacheDisabledView;\n\t\t}\n\n\t\tpublic Config cacheDisabledView(boolean cache) {\n\t\t\tthis.cacheDisabledView = cache;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Map<String, String> properties() {\n\t\t\treturn properties;\n\t\t}\n\n\t\tpublic Config putProperty(String key, String value) {\n\t\t\tthis.properties.put(key, value);\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Config removeProperty(String key) {\n\t\t\tthis.properties.remove(key);\n\t\t\treturn this;\n\t\t}\n\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"master", "cached"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport com.hazelcast.client.HazelcastClient;\nimport com.hazelcast.client.config.ClientConfig;\nimport com.hazelcast.client.config.ClientNetworkConfig;\nimport com.hazelcast.core.HazelcastInstance;\nimport com.hazelcast.map.IMap;\nimport com.hazelcast.topic.Message;\nimport com.hazelcast.topic.MessageListener;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.ness.master.messages.*;\nimport io.intino.ness.master.messages.listeners.EntityListener;\nimport io.intino.ness.master.messages.listeners.EntityListener.Event;\nimport io.intino.ness.master.messages.listeners.ErrorListener;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.model.Triplet;\nimport io.intino.ness.master.model.TripletRecord;\nimport io.intino.ness.master.serialization.MasterSerializer;\nimport io.intino.ness.master.serialization.MasterSerializers;\n\nimport java.time.Instant;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.concurrent.*;\nimport java.util.concurrent.atomic.AtomicBoolean;\nimport java.util.logging.ConsoleHandler;\nimport java.util.logging.Handler;\nimport java.util.logging.Level;\nimport java.util.logging.LogManager;\nimport java.util.stream.Stream;\n\nimport static io.intino.ness.master.core.Master.MASTER_MAP_NAME;\nimport static io.intino.ness.master.core.Master.METADATA_MAP_NAME;\nimport static io.intino.ness.master.messages.MasterTopics.*;\nimport static java.util.Objects.requireNonNull;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.*;\n\n@SuppressWarnings({\"rawtypes\", \"unchecked\"})\npublic class FullLoadMasterTerminal implements MasterTerminal {\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"map"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\tprivate final AtomicBoolean initialized = new AtomicBoolean(false);\n\tprivate final MasterTerminal.Config config;\n\tprotected HazelcastInstance hazelcast;\n\tprivate final Map<String, List<EntityListener>> entityListeners = new ConcurrentHashMap<>();\n\tprivate final List<ErrorListener> errorListeners = Collections.synchronizedList(new ArrayList<>());\n\tprivate final Map<String, CompletableFuture> futures = new ConcurrentHashMap<>();\n\tprivate DisabledView disabledView;\n\n\tpublic FullLoadMasterTerminal(MasterTerminal.Config config) {\n\t\tthis(config, null);\n\t}\n\n\tpublic FullLoadMasterTerminal(MasterTerminal.Config config, HazelcastInstance hazelcast) {\n    \tthis.config = requireNonNull(config);\n    \tthis.hazelcast = hazelcast;\n   \t}\n\n\t@Override\n\tpublic void start() {\n\t\tif(!initialized.compareAndSet(false, true)) return;\n\t\tconfigureLogger();\n\t\tinitHazelcastClient();\n\t\tloadData();\n\t\tinitListeners();\n\t\tif(\"true\".equals(config.properties().getOrDefault(\"master.log.initialization_complete\", \"true\")))\n\t\t\tLogger.info(\"MasterTerminal \" + config.clientName() + \" initialized successfully. (\" + getClass().getSimpleName() + \")\");\n\t}\n\n\t@Override\n\tpublic void stop() {\n\t\thazelcast.shutdown();\n\t}\n\n\t@Override\n\tpublic void addErrorListener(ErrorListener listener) {\n\t\tif(listener == null) throw new NullPointerException(\"ErrorListener cannot be null\");\n\t\terrorListeners.add(listener);\n\t}\n\n\t@Override\n\tpublic <T extends Entity> void addEntityListener(String type, EntityListener<T> listener) {\n\t\tif(type == null) throw new NullPointerException(\"Type cannot be null\");\n\t\tif(listener == null) throw new NullPointerException(\"EntryListener cannot be null\");\n\t\tentityListeners.computeIfAbsent(type, k -> new ArrayList<>()).add(listener);\n\t}\n\n\t@Override\n\tpublic MasterSerializer serializer() {\n    \tIMap<String, String> metadata = hazelcast.getMap(METADATA_MAP_NAME);\n    \treturn MasterSerializers.get(metadata.get(\"serializer\"));\n    }\n\n\t@Override\n\tpublic MasterTerminal.Config config() {\n\t\treturn new MasterTerminal.Config(config);\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"getter"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t@Override\n\tpublic <T extends Entity> Future<Response<T>> enable(String id) {\n\t\tif(!config.allowWriting()) throw new UnsupportedOperationException(\"This master client is configured as read only\");\n        if(id == null) throw new NullPointerException(\"Entity id cannot be null\");\n        UpdateMasterMessage message = createMessage(UpdateMasterMessage.Action.Enable, id);\n        CompletableFuture<Response<T>> future = new CompletableFuture<>();\n        futures.put(message.id(), future);\n        MasterMessagePublisher.publishMessage(hazelcast, MASTER_UPDATE_TOPIC, message);\n        return future;\n\t}\n\n  \t@Override\n  \tpublic <T extends Entity> Future<Response<T>> disable(String id) {\n  \t\tif(!config.allowWriting()) throw new UnsupportedOperationException(\"This master client is configured as read only\");\n        if(id == null) throw new NullPointerException(\"Entity id cannot be null\");\n        UpdateMasterMessage message = createMessage(UpdateMasterMessage.Action.Disable, id);\n        CompletableFuture<Response<T>> future = new CompletableFuture<>();\n        futures.put(message.id(), future);\n        MasterMessagePublisher.publishMessage(hazelcast, MASTER_UPDATE_TOPIC, message);\n        return future;\n  \t}\n\n\t@Override\n\tpublic <T extends Entity> Future<Response<T>> publish(Entity entity) {\n\t\tif(!config.allowWriting()) throw new UnsupportedOperationException(\"This master client is configured as read only\");\n\t\tif(entity == null) throw new NullPointerException(\"Entity cannot be null\");\n\t\tUpdateMasterMessage message = createMessage(UpdateMasterMessage.Action.Publish, serializer().serialize(entity.asTripletRecord()));\n        CompletableFuture<Response<T>> future = new CompletableFuture<>();\n        futures.put(message.id(), future);\n\t\tMasterMessagePublisher.publishMessage(hazelcast, MASTER_UPDATE_TOPIC, message);\n\t\treturn future;\n\t}\n\n\t@Override\n\tpublic synchronized MasterView disabled() {\n  \t\tif(config.filter() == MasterTerminal.EntityFilter.OnlyDisabled) return this;\n\t\tif(!config.cacheDisabledView()) {\n\t\t\tDisabledView view = new DisabledView(config, hazelcast);\n\t\t\tview.start();\n\t\t\treturn view;\n\t\t}\n\t\tif(disabledView == null) {\n\t\t\tdisabledView = new DisabledView(config, hazelcast);\n\t\t\tdisabledView.start();\n\t\t}\n\t\treturn disabledView;\n\t}\n\n\tprivate UpdateMasterMessage createMessage(UpdateMasterMessage.Action action, String value) {\n\t\treturn new UpdateMasterMessage(config.clientName(), action, value);\n\t}\n\n\tprivate boolean isIgnored(TripletRecord record) {\n\t\tif(config.filter() == MasterTerminal.EntityFilter.All) return false;\n\t\treturn isEnabled(record)\n\t\t\t? config.filter() == MasterTerminal.EntityFilter.OnlyDisabled\n\t\t\t: config.filter() == MasterTerminal.EntityFilter.OnlyEnabled;\n\t}\n\n\tprivate boolean isEnabled(TripletRecord record) {\n\t\tString enabledValue = record.getValue(\"enabled\");\n        return enabledValue == null || \"true\".equalsIgnoreCase(enabledValue);\n\t}\n\n\tprotected void add(TripletRecord record) {\n\t\tif(isIgnored(record)) return;\n\t\tswitch(record.type()) {\n\t\t\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"adder"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t}\n\t}\n\n\tprotected void remove(String id) {\n\t\tswitch(Triplet.typeOf(id)) {\n\t\t\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"remover"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t}\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"add"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"remove"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tprivate void initHazelcastClient() {\n\t\tif(hazelcast != null) return;\n\n\t\tClientConfig config = new ClientConfig();\n\t\tconfig.setInstanceName(this.config.clientName());\n\t\tconfig.setNetworkConfig(new ClientNetworkConfig().setAddresses(this.config.addresses()));\n\t\tthis.config.properties().forEach(config::setProperty);\n\n\t\thazelcast = HazelcastClient.newHazelcastClient(config);\n\t}\n\n\tprotected void initListeners() {\n\t\thazelcast.getTopic(MASTER_LISTENER_TOPIC).addMessageListener(new ListenerTopicMessageListener());\n\t\thazelcast.getTopic(MASTER_ERROR_TOPIC).addMessageListener(new ErrorTopicMessageListener());\n\t}\n\n\tprivate void loadData() {\n\t\tIMap<String, String> master = hazelcast.getMap(MASTER_MAP_NAME);\n\t\tMasterSerializer serializer = serializer();\n\n\t\tLogger.debug(\"Loading data from master (serializer=\" + serializer.name() + \")\");\n\t\tlong start = System.currentTimeMillis();\n\n\t\tif(config.multithreadLoading())\n\t\t\tloadDataMultiThread(master, serializer);\n\t\telse\n\t\t\tloadDataSingleThread(master, serializer);\n\n\t\tlong time = System.currentTimeMillis() - start;\n\t\tLogger.debug(\"Data from master loaded in \" + time + \" ms\");\n\t}\n\n\tprivate void loadDataSingleThread(IMap<String, String> master, MasterSerializer serializer) {\n\t\tmaster.forEach((id, serializedRecord) -> add(serializer.deserialize(serializedRecord)));\n\t}\n\n\tprivate void loadDataMultiThread(IMap<String, String> master, MasterSerializer serializer) {\n\t\ttry {\n\t\t\tExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() - 1);\n\n\t\t\tmaster.forEach((id, serializedRecord) -> threadPool.submit(() -> add(serializer.deserialize(serializedRecord))));\n\n\t\t\tthreadPool.shutdown();\n\t\t\tthreadPool.awaitTermination(1, TimeUnit.HOURS);\n\t\t} catch (Exception e) {\n\t\t\tthrow new RuntimeException(e);\n\t\t}\n\t}\n\n\tprivate static void configureLogger() {\n\t\tjava.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger(\"\");\n\t\trootLogger.setLevel(Level.WARNING);\n\t\tfor (Handler h : rootLogger.getHandlers()) rootLogger.removeHandler(h);\n\t\tfinal ConsoleHandler handler = new ConsoleHandler();\n\t\thandler.setLevel(Level.WARNING);\n\t\thandler.setFormatter(new io.intino.alexandria.logger.Formatter());\n\t\trootLogger.setUseParentHandlers(false);\n\t\trootLogger.addHandler(handler);\n\t}\n\n\tprivate class ErrorTopicMessageListener implements MessageListener<Object> {\n\n\t\t@Override\n\t\tpublic void onMessage(Message<Object> rawMessage) {\n\t\t\tErrorMasterMessage message = MasterMessageSerializer.deserialize(rawMessage.getMessageObject(), ErrorMasterMessage.class);\n        \tnotifyErrorListeners(new MasterError(message.ts(), message.error()));\n\t\t}\n\n\t\tprotected void notifyErrorListeners(ErrorListener.Error error) {\n\t\t\tif(error.messageId() != null) {\n\t\t\t\tCompletableFuture<Response<?>> future = futures.remove(error.messageId());\n\t\t\t\tif(future != null) future.complete(Response.ofFailure(error));\n\t\t\t}\n\n\t\t\terrorListeners.forEach(listener -> listener.notify(error));\n\t\t}\n\n\t\tprotected class MasterError implements ErrorListener.Error {\n\n\t\t\tprivate final Instant ts;\n\t\t\tprivate final MasterMessageException error;\n\n\t\t\tprivate MasterError(Instant ts, MasterMessageException error) {\n\t\t\t\tthis.ts = ts;\n\t\t\t\tthis.error = error;\n\t\t\t}\n\n\t\t\t@Override\n\t\t\tpublic Instant ts() {\n\t\t\t\treturn ts;\n\t\t\t}\n\n\t\t\t@Override\n\t\t\tpublic MasterMessageException cause() {\n\t\t\t\treturn error;\n\t\t\t}\n\t\t}\n\t}\n\n\tprivate class ListenerTopicMessageListener implements MessageListener<Object> {\n\n\t\t@Override\n\t\tpublic void onMessage(Message<Object> rawMessage) {\n\t\t\tListenerMasterMessage message = MasterMessageSerializer.deserialize(String.valueOf(rawMessage.getMessageObject()), ListenerMasterMessage.class);\n\t\t\tTripletRecord record = serializer().tryDeserialize(message.record()).orElse(null);\n\t\t\tEvent<?> event = new MasterEntityEvent<>(\n\t\t\t\tmessage.serverName(), message.clientName(),\tasEventType(message.action()),\n\t\t\t\tmessage.recordId(), asEntity(record), message.record(),\n\t\t\t\tmessage.ts(), message.updateMessageId());\n\t\t\tprocess(event, record);\n\t\t\tnotifyEntityListeners(event);\n\t\t}\n\n\t\tprotected void process(Event<?> event, TripletRecord record) {\n\t\t\tswitch(event.type()) {\n\t\t\t\tcase Create:\n\t\t\t\tcase Update:\n\t\t\t\tcase Enable:\n\t\t\t\t\tadd(record);\n\t\t\t\t\tbreak;\n\t\t\t\tcase Disable:\n\t\t\t\tcase Remove:\n\t\t\t\t\tremove(record.id());\n\t\t\t\t\tbreak;\n\t\t\t}\n\t\t}\n\n\t\tprivate Event.Type asEventType(ListenerMasterMessage.Action action) {\n\t\t\tswitch(action) {\n\t\t\t\tcase Created: return Event.Type.Create;\n\t\t\t\tcase Updated: return Event.Type.Update;\n\t\t\t\tcase Enabled: return Event.Type.Enable;\n\t\t\t\tcase Disabled: return Event.Type.Disable;\n\t\t\t\tcase Removed: return Event.Type.Remove;\n\t\t\t\tcase None: return Event.Type.None;\n\t\t\t\tdefault: throw new IllegalArgumentException(\"Unknown listener action \" + action);\n\t\t\t}\n\t\t}\n\n\t\t@SuppressWarnings(\"all\")\n\t\tprotected void notifyEntityListeners(Event<?> event) {\n\t\t\tCompletableFuture<Response<?>> future = futures.remove(event.messageId());\n\t\t\tif(future != null) future.complete(Response.ofSuccessful(event));\n\n\t\t\tList<EntityListener> listeners = entityListeners.get(event.entityId().type());\n\t\t\tif(listeners != null) listeners.forEach(listener -> listener.notify(event));\n\t\t}\n\t}\n\n\tstatic class DisabledView extends FullLoadMasterTerminal {\n\n\t\tpublic DisabledView(Config config, HazelcastInstance hazelcast) {\n\t\t\tsuper(\n\t\t\t\tnew Config(config)\n\t\t\t\t\t.allowWriting(false)\n\t\t\t\t\t.filter(EntityFilter.OnlyDisabled)\n\t\t\t\t\t.putProperty(\"master.log.initialization_complete\", \"false\"),\n\t\t\t\thazelcast);\n\t\t}\n\n\t\t@Override\n\t\tpublic void addErrorListener(ErrorListener listener) {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\n\t\t@Override\n\t\tpublic <T extends Entity> void addEntityListener(String type, EntityListener<T> listener) {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\n\t\t@Override\n\t\tpublic void stop() {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\n\t\t@Override\n\t\tpublic MasterView disabled() {\n\t\t\treturn this;\n\t\t}\n\n\t\t@Override\n\t\tprotected void initListeners() {\n\t\t\thazelcast.getTopic(MASTER_LISTENER_TOPIC).addMessageListener(new DisabledListenerTopicMessageListener());\n\t\t}\n\n\t\tprivate class DisabledListenerTopicMessageListener extends ListenerTopicMessageListener {\n\n\t\t\tprotected void process(Event<?> event, TripletRecord record) {\n\t\t\t\tswitch(event.type()) {\n\t\t\t\t\tcase Create:\n\t\t\t\t\tcase Update:\n\t\t\t\t\tcase Enable:\n\t\t\t\t\t\tremove(record.id());\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase Disable:\n\t\t\t\t\tcase Remove:\n\t\t\t\t\t\tadd(record);\n\t\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tprotected void notifyEntityListeners(Event<?> event) {}\n\t\t}\n\t}\n\n\tpublic static class MasterEntityEvent<T extends Entity> implements Event<T> {\n\n\t\tprivate final String serverName;\n\t\tprivate final String clientName;\n\t\tprivate final Type type;\n\t\tprivate final Entity.Id entityId;\n\t\tprivate final T entity;\n\t\tprivate final String value;\n\t\tprivate final Instant ts;\n\t\tprivate final String messageId;\n\n\t\tprivate MasterEntityEvent(String serverName, String clientName, Type type, String entityId, T entity, String value, Instant ts, String messageId) {\n\t\t\tthis.serverName = serverName;\n\t\t\tthis.clientName = clientName;\n\t\t\tthis.type = type;\n\t\t\tthis.entityId = new Entity.Id(entityId);\n\t\t\tthis.entity = entity;\n\t\t\tthis.value = value;\n\t\t\tthis.ts = ts;\n\t\t\tthis.messageId = messageId;\n\t\t}\n\n\t\t@Override\n\t\tpublic String serverName() {\n\t\t\treturn serverName;\n\t\t}\n\n\t\t@Override\n\t\tpublic String clientName() {\n\t\t\treturn clientName;\n\t\t}\n\n\t\t@Override\n\t\tpublic Type type() {\n\t\t\treturn type;\n\t\t}\n\n\t\t@Override\n\t\tpublic Entity.Id entityId() {\n\t\t\treturn entityId;\n\t\t}\n\n\t\t@Override\n\t\tpublic T entity() {\n\t\t\treturn entity;\n\t\t}\n\n\t\t@Override\n\t\tpublic String value() {\n\t\t\treturn value;\n\t\t}\n\n\t\t@Override\n\t\tpublic Instant ts() {\n\t\t\treturn ts;\n\t\t}\n\n\t\t@Override\n\t\tpublic String messageId() {\n\t\t\treturn messageId;\n\t\t}\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"master", "lazy"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport com.hazelcast.client.HazelcastClient;\nimport com.hazelcast.client.config.ClientConfig;\nimport com.hazelcast.client.config.ClientNetworkConfig;\nimport com.hazelcast.core.HazelcastInstance;\nimport com.hazelcast.map.IMap;\nimport com.hazelcast.topic.Message;\nimport com.hazelcast.topic.MessageListener;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.ness.master.messages.*;\nimport io.intino.ness.master.messages.listeners.EntityListener;\nimport io.intino.ness.master.messages.listeners.EntityListener.Event;\nimport io.intino.ness.master.messages.listeners.ErrorListener;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.model.Triplet;\nimport io.intino.ness.master.model.TripletRecord;\nimport io.intino.ness.master.serialization.MasterSerializer;\nimport io.intino.ness.master.serialization.MasterSerializers;\n\nimport java.time.Instant;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.function.BiFunction;\nimport java.util.concurrent.*;\nimport java.util.concurrent.atomic.AtomicBoolean;\nimport java.util.logging.ConsoleHandler;\nimport java.util.logging.Handler;\nimport java.util.logging.Level;\nimport java.util.logging.LogManager;\nimport java.util.stream.Stream;\n\nimport static io.intino.ness.master.core.Master.MASTER_MAP_NAME;\nimport static io.intino.ness.master.core.Master.METADATA_MAP_NAME;\nimport static io.intino.ness.master.messages.MasterTopics.*;\nimport static java.util.Objects.requireNonNull;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.*;\n\n@SuppressWarnings({\"rawtypes\", \"unchecked\"})\npublic class LazyLoadMasterTerminal implements MasterTerminal {\n\n\tprivate final AtomicBoolean initialized = new AtomicBoolean(false);\n\tprivate final MasterTerminal.Config config;\n\tprotected HazelcastInstance hazelcast;\n\tprivate IMap<String, String> masterMap;\n\tprivate MasterSerializer serializer;\n\tprivate final Map<String, List<EntityListener>> entityListeners = new ConcurrentHashMap<>();\n\tprivate final List<ErrorListener> errorListeners = Collections.synchronizedList(new ArrayList<>());\n\tprivate final Map<String, CompletableFuture> futures = new ConcurrentHashMap<>();\n\tprivate DisabledView disabledView;\n\n\tpublic LazyLoadMasterTerminal(MasterTerminal.Config config) {\n\t\tthis(config, null);\n\t}\n\n\tpublic LazyLoadMasterTerminal(MasterTerminal.Config config, HazelcastInstance hazelcast) {\n\t\tthis.config = requireNonNull(config);\n\t\tthis.hazelcast = hazelcast;\n\t}\n\n\t@Override\n\tpublic void start() {\n\t\tif(!initialized.compareAndSet(false, true)) return;\n\t\tconfigureLogger();\n\t\tinitHazelcastClient();\n\t\tif(\"true\".equals(config.properties().getOrDefault(\"master.log.initialization_complete\", \"true\")))\n\t\t\tLogger.info(\"MasterTerminal \" + config.clientName() + \" initialized successfully. (\" + getClass().getSimpleName() + \")\");\n\t}\n\n\t@Override\n\tpublic void stop() {\n\t\thazelcast.shutdown();\n\t}\n\n\t@Override\n\tpublic void addErrorListener(ErrorListener listener) {\n\t\tif(listener == null) throw new NullPointerException(\"ErrorListener cannot be null\");\n\t\terrorListeners.add(listener);\n\t}\n\n\t@Override\n\tpublic <T extends Entity> void addEntityListener(String type, EntityListener<T> listener) {\n\t\tif(type == null) throw new NullPointerException(\"Type cannot be null\");\n\t\tif(listener == null) throw new NullPointerException(\"EntryListener cannot be null\");\n\t\tentityListeners.computeIfAbsent(type, k -> new ArrayList<>()).add(listener);\n\t}\n\n\t@Override\n    public MasterSerializer serializer() {\n    \treturn serializer;\n    }\n\n\t@Override\n\tpublic MasterTerminal.Config config() {\n\t\treturn new MasterTerminal.Config(config);\n\t}\n\n\t@Override\n\tpublic <T extends Entity> Future<Response<T>> enable(String id) {\n\t\tif(!config.allowWriting()) throw new UnsupportedOperationException(\"This master client is configured as read only\");\n        if(id == null) throw new NullPointerException(\"Entity id cannot be null\");\n        UpdateMasterMessage message = createMessage(UpdateMasterMessage.Action.Enable, id);\n        CompletableFuture<Response<T>> future = new CompletableFuture<>();\n        futures.put(message.id(), future);\n        MasterMessagePublisher.publishMessage(hazelcast, MASTER_UPDATE_TOPIC, message);\n        return future;\n\t}\n\n  \t@Override\n  \tpublic <T extends Entity> Future<Response<T>> disable(String id) {\n  \t\tif(!config.allowWriting()) throw new UnsupportedOperationException(\"This master client is configured as read only\");\n        if(id == null) throw new NullPointerException(\"Entity id cannot be null\");\n        UpdateMasterMessage message = createMessage(UpdateMasterMessage.Action.Disable, id);\n        CompletableFuture<Response<T>> future = new CompletableFuture<>();\n        futures.put(message.id(), future);\n        MasterMessagePublisher.publishMessage(hazelcast, MASTER_UPDATE_TOPIC, message);\n        return future;\n  \t}\n\n\t@Override\n\tpublic <T extends Entity> Future<Response<T>> publish(Entity entity) {\n\t\tif(!config.allowWriting()) throw new UnsupportedOperationException(\"This master client is configured as read only\");\n\t\tif(entity == null) throw new NullPointerException(\"Entity cannot be null\");\n\t\tUpdateMasterMessage message = createMessage(UpdateMasterMessage.Action.Publish, serializer().serialize(entity.asTripletRecord()));\n        CompletableFuture<Response<T>> future = new CompletableFuture<>();\n        futures.put(message.id(), future);\n\t\tMasterMessagePublisher.publishMessage(hazelcast, MASTER_UPDATE_TOPIC, message);\n\t\treturn future;\n\t}\n\n\t@Override\n\tpublic synchronized MasterView disabled() {\n  \t\tif(config.filter() == MasterTerminal.EntityFilter.OnlyDisabled) return this;\n\t\tif(!config.cacheDisabledView()) {\n\t\t\tDisabledView view = new DisabledView(config, hazelcast);\n\t\t\tview.start();\n\t\t\treturn view;\n\t\t}\n\t\tif(disabledView == null) {\n\t\t\tdisabledView = new DisabledView(config, hazelcast);\n\t\t\tdisabledView.start();\n\t\t}\n\t\treturn disabledView;\n\t}\n\n\tprivate UpdateMasterMessage createMessage(UpdateMasterMessage.Action action, String value) {\n\t\treturn new UpdateMasterMessage(config.clientName(), action, value);\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"getter"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tprivate TripletRecord getRecord(String id) {\n    \tString serializedRecord = masterMap.get(id);\n    \tif(serializedRecord == null || isIgnored(serializedRecord)) return null;\n    \treturn serializer.deserialize(serializedRecord);\n    }\n\n   \t\tprivate <T extends Entity> T entity(BiFunction<String, MasterTerminal, T> constructor, String id, TripletRecord record) {\n   \t\t\tT entity = constructor.apply(id, this);\n   \t\t\trecord.triplets().forEach(entity::add);\n   \t\t\treturn entity;\n   \t\t}\n\n\tprivate boolean accepts(String serializedRecord) {\n\t\treturn !isIgnored(serializedRecord);\n\t}\n\n\tprivate boolean isIgnored(String serializedRecord) {\n\t\tif(config.filter() == MasterTerminal.EntityFilter.All) return false;\n\t\treturn isEnabled(serializer.deserialize(serializedRecord))\n\t\t\t? config.filter() == MasterTerminal.EntityFilter.OnlyDisabled\n\t\t\t: config.filter() == MasterTerminal.EntityFilter.OnlyEnabled;\n   \t\t}\n\n\tprivate boolean isEnabled(TripletRecord record) {\n\t\tString enabledValue = record.getValue(\"enabled\");\n        return enabledValue == null || \"true\".equalsIgnoreCase(enabledValue);\n\t}\n\n\tprivate void initHazelcastClient() {\n\t\tClientConfig config = new ClientConfig();\n    \tconfig.setInstanceName(this.config.clientName());\n    \tconfig.setNetworkConfig(new ClientNetworkConfig().setAddresses(this.config.addresses()));\n\n    \thazelcast = HazelcastClient.newHazelcastClient(config);\n\n    \tmasterMap = hazelcast.getMap(MASTER_MAP_NAME);\n    \tIMap<String, String> metadata = hazelcast.getMap(METADATA_MAP_NAME);\n    \tserializer = MasterSerializers.get(metadata.get(\"serializer\"));\n\n    \tinitListeners();\n\t}\n\n\tprotected void initListeners() {\n\t\thazelcast.getTopic(MASTER_LISTENER_TOPIC).addMessageListener(new ListenerTopicMessageListener());\n\t\thazelcast.getTopic(MASTER_ERROR_TOPIC).addMessageListener(new ErrorTopicMessageListener());\n\t}\n\n\tprivate static void configureLogger() {\n\t\tjava.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger(\"\");\n\t\trootLogger.setLevel(Level.WARNING);\n\t\tfor (Handler h : rootLogger.getHandlers()) rootLogger.removeHandler(h);\n\t\tfinal ConsoleHandler handler = new ConsoleHandler();\n\t\thandler.setLevel(Level.WARNING);\n\t\thandler.setFormatter(new io.intino.alexandria.logger.Formatter());\n\t\trootLogger.setUseParentHandlers(false);\n\t\trootLogger.addHandler(handler);\n\t}\n\n\tprivate class ErrorTopicMessageListener implements MessageListener<Object> {\n\n\t\t@Override\n\t\tpublic void onMessage(Message<Object> rawMessage) {\n\t\t\tErrorMasterMessage message = MasterMessageSerializer.deserialize(String.valueOf(rawMessage.getMessageObject()), ErrorMasterMessage.class);\n        \tnotifyErrorListeners(new MasterError(message.ts(), message.error()));\n\t\t}\n\n\t\tprotected void notifyErrorListeners(ErrorListener.Error error) {\n\t\t\tif(error.messageId() != null) {\n\t\t\t\tCompletableFuture<Response<?>> future = futures.remove(error.messageId());\n\t\t\t\tif(future != null) future.complete(Response.ofFailure(error));\n\t\t\t}\n\n\t\t\terrorListeners.forEach(listener -> listener.notify(error));\n\t\t}\n\n\t\tprotected class MasterError implements ErrorListener.Error {\n\n\t\t\tprivate final Instant ts;\n\t\t\tprivate final MasterMessageException error;\n\n\t\t\tprivate MasterError(Instant ts, MasterMessageException error) {\n\t\t\t\tthis.ts = ts;\n\t\t\t\tthis.error = error;\n\t\t\t}\n\n\t\t\t@Override\n\t\t\tpublic Instant ts() {\n\t\t\t\treturn ts;\n\t\t\t}\n\n\t\t\t@Override\n\t\t\tpublic MasterMessageException cause() {\n\t\t\t\treturn error;\n\t\t\t}\n\t\t}\n\t}\n\n\n\tprivate class ListenerTopicMessageListener implements MessageListener<Object> {\n\n\t\t@Override\n\t\tpublic void onMessage(Message<Object> rawMessage) {\n\t\t\tListenerMasterMessage message = MasterMessageSerializer.deserialize(String.valueOf(rawMessage.getMessageObject()), ListenerMasterMessage.class);\n\t\t\tTripletRecord record = serializer().tryDeserialize(message.record()).orElse(null);\n\t\t\tEvent<?> event = new MasterEntityEvent<>(\n\t\t\t\tmessage.serverName(), message.clientName(),\tasEventType(message.action()),\n\t\t\t\tmessage.recordId(), asEntity(record), message.record(),\n\t\t\t\tmessage.ts(), message.updateMessageId());\n\t\t\tnotifyEntityListeners(event);\n\t\t}\n\n\t\tprivate Event.Type asEventType(ListenerMasterMessage.Action action) {\n\t\t\tswitch(action) {\n\t\t\t\tcase Created: return Event.Type.Create;\n\t\t\t\tcase Updated: return Event.Type.Update;\n\t\t\t\tcase Enabled: return Event.Type.Enable;\n\t\t\t\tcase Disabled: return Event.Type.Disable;\n\t\t\t\tcase Removed: return Event.Type.Remove;\n\t\t\t\tcase None: return Event.Type.None;\n\t\t\t\tdefault: throw new IllegalArgumentException(\"Unknown listener action \" + action);\n\t\t\t}\n\t\t}\n\n\t\t@SuppressWarnings(\"all\")\n\t\tprotected void notifyEntityListeners(Event<?> event) {\n\t\t\tCompletableFuture<Response<?>> future = futures.remove(event.messageId());\n\t\t\tif(future != null) future.complete(Response.ofSuccessful(event));\n\n\t\t\tList<EntityListener> listeners = entityListeners.get(event.entityId().type());\n\t\t\tif(listeners != null) listeners.forEach(listener -> listener.notify(event));\n\t\t}\n\t}\n\n\tstatic class DisabledView extends LazyLoadMasterTerminal {\n\n\t\tpublic DisabledView(Config config, HazelcastInstance hazelcast) {\n\t\t\tsuper(\n\t\t\t\tnew Config(config)\n\t\t\t\t\t.allowWriting(false)\n\t\t\t\t\t.filter(EntityFilter.OnlyDisabled)\n\t\t\t\t\t.putProperty(\"master.log.initialization_complete\", \"false\"),\n\t\t\t\thazelcast);\n\t\t}\n\n\t\t@Override\n\t\tpublic <T extends Entity> void addEntityListener(String type, EntityListener<T> listener) {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\n\t\t@Override\n\t\tpublic void stop() {\n\t\t\tthrow new UnsupportedOperationException();\n\t\t}\n\n\t\t@Override\n\t\tpublic MasterView disabled() {\n\t\t\treturn this;\n\t\t}\n\n\t\t@Override\n\t\tprotected void initListeners() {\n\t\t\thazelcast.getTopic(MASTER_LISTENER_TOPIC).addMessageListener(new DisabledListenerTopicMessageListener());\n\t\t}\n\n\t\tprivate class DisabledListenerTopicMessageListener extends ListenerTopicMessageListener {\n\t\t\tprotected void notifyEntityListeners(Event<?> event) {}\n\t\t}\n\t}\n\n\tpublic static class MasterEntityEvent<T extends Entity> implements Event<T> {\n\n\t\tprivate final String serverName;\n\t\tprivate final String clientName;\n\t\tprivate final Type type;\n\t\tprivate final Entity.Id entityId;\n\t\tprivate final T entity;\n\t\tprivate final String value;\n\t\tprivate final Instant ts;\n\t\tprivate final String messageId;\n\n\t\tprivate MasterEntityEvent(String serverName, String clientName, Type type, String entityId, T entity, String value, Instant ts, String messageId) {\n\t\t\tthis.serverName = serverName;\n\t\t\tthis.clientName = clientName;\n\t\t\tthis.type = type;\n\t\t\tthis.entityId = new Entity.Id(entityId);\n\t\t\tthis.entity = entity;\n\t\t\tthis.value = value;\n\t\t\tthis.ts = ts;\n\t\t\tthis.messageId = messageId;\n\t\t}\n\n\t\t@Override\n\t\tpublic String serverName() {\n\t\t\treturn serverName;\n\t\t}\n\n\t\t@Override\n\t\tpublic String clientName() {\n\t\t\treturn clientName;\n\t\t}\n\n\t\t@Override\n\t\tpublic Type type() {\n\t\t\treturn type;\n\t\t}\n\n\t\t@Override\n\t\tpublic Entity.Id entityId() {\n\t\t\treturn entityId;\n\t\t}\n\n\t\t@Override\n\t\tpublic T entity() {\n\t\t\treturn entity;\n\t\t}\n\n\t\t@Override\n\t\tpublic String value() {\n\t\t\treturn value;\n\t\t}\n\n\t\t@Override\n\t\tpublic Instant ts() {\n\t\t\treturn ts;\n\t\t}\n\n\t\t@Override\n\t\tpublic String messageId() {\n\t\t\treturn messageId;\n\t\t}\n\t}\n}")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("remover")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"lowerCase"})}).output(new Rule.Output[]{this.literal("\": removeFrom")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(id); break;")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("adder")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"lowerCase"})}).output(new Rule.Output[]{this.literal("\": addTo")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(record); break;")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("map")}).output(new Rule.Output[]{this.literal("private final Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstLowerCase"})}).output(new Rule.Output[]{this.literal("Map = new ConcurrentHashMap<>();")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("add")}).output(new Rule.Output[]{this.literal("private void addTo")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(TripletRecord record) {\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" entity = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(record.id(), this);\n\trecord.triplets().forEach(entity::add);\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.put(record.id(), entity);\n}")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.trigger("remove")}).output(new Rule.Output[]{this.literal("private void removeFrom")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.remove(id);\n}")}), this.rule().condition(this.type("subclass"), new Rule.Condition[]{this.trigger("getbyid")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"lowerCase"})}).output(new Rule.Output[]{this.literal("\": return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(id);")}), this.rule().condition(this.type("subclass"), new Rule.Condition[]{this.trigger("getallstream")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")}), this.rule().condition(this.type("abstract"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\tswitch(Triplet.typeOf(id)) {\n\t\t")}).output(new Rule.Output[]{this.mark("subclass", new String[]{"getById"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\treturn null;\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn Stream.of(\n\t\t")}).output(new Rule.Output[]{this.mark("subclass", new String[]{"getAllStream"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).flatMap(java.util.function.Function.identity());\n}")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.type("cached"), this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.get(id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Map.values().stream();\n}")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.type("lazy"), this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\tTripletRecord record = getRecord(id);\n\treturn record != null ? entity(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("::new, id, record) : null;\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn masterMap.entrySet().stream()\n\t\t\t.filter(e -> e.getKey().endsWith(\":")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\"))\n\t\t\t.filter(e -> accepts(e.getValue()))\n\t\t\t.map(e -> entity(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("::new, e.getKey(), serializer.deserialize(e.getValue())));\n}")}), this.rule().condition(this.trigger("gettersignature"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id);\nStream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\ndefault List<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("List() {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().collect(Collectors.toList());}")}), this.rule().condition(this.trigger("entitylistener"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("default void add")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityListener(EntityListener<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> listener) {\n\taddEntityListener(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\", listener);\n}")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.not(this.type("abstract")), this.trigger("asentityswitchcase")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("\": return (T) new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(record, this);")})});
    }
}

