/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.Configuration;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.EntityFrameCreator;
import io.intino.ness.datahubterminalplugin.master.EntityTemplate;
import io.intino.ness.datahubterminalplugin.master.MasterTerminalTemplate;
import io.intino.ness.datahubterminalplugin.master.StructFrameCreator;
import io.intino.ness.datahubterminalplugin.master.StructTemplate;
import io.intino.ness.datahubterminalplugin.master.ValidatorFrameCreator;
import io.intino.ness.datahubterminalplugin.master.ValidatorTemplate;
import io.intino.ness.datahubterminalplugin.util.ErrorUtils;
import io.intino.plugin.PluginLauncher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class MasterRenderer {
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private final File srcFolder;
    private final NessGraph model;
    private final Configuration conf;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private final Template entityTemplate;
    private final Template validatorTemplate;
    private final Template structTemplate;
    private final String workingPackage;

    public MasterRenderer(File root, NessGraph model, Configuration conf, PrintStream logger, PluginLauncher.Notifier notifier) {
        this.srcFolder = new File(root, "src");
        this.model = model;
        this.conf = conf;
        this.logger = logger;
        this.notifier = notifier;
        this.entityTemplate = Formatters.customize(new EntityTemplate());
        this.validatorTemplate = Formatters.customize(new ValidatorTemplate());
        this.structTemplate = Formatters.customize(new StructTemplate());
        this.srcFolder.mkdirs();
        this.workingPackage = this.conf.artifact().code().generationPackage();
    }

    boolean render() {
        try {
            if (this.model.entityList().isEmpty()) {
                return false;
            }
            this.logger.println("Generating Entities...");
            this.write(this.entityClasses());
            this.write(this.structClasses());
            this.write(this.masterClass());
            this.write(this.validationLayerClass());
            return true;
        }
        catch (Throwable e) {
            this.notifier.notifyError("Error during java className generation: " + ErrorUtils.getMessage(e));
            return false;
        }
    }

    private Map<String, String> entityClasses() {
        HashMap<String, String> outputs = new HashMap<String, String>();
        this.model.entityList().forEach(e -> outputs.putAll(this.renderEntityAndValidator((Entity)e)));
        return outputs;
    }

    private Map<String, String> renderEntityAndValidator(Entity entity) {
        Map<String, String> map = this.renderEntityNode(entity);
        map.putAll(this.renderValidator(entity));
        return map;
    }

    private Map<String, String> structClasses() {
        return this.model.structList().stream().map(this::renderStructNode).flatMap(e -> e.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> validationLayerClass() {
        String module = Formatters.javaValidName().format((Object)this.conf.artifact().name()).toString();
        String qn = this.workingPackage + ".validators." + StringFormatters.firstUpperCase().format((Object)module) + "RecordValidationLayer";
        return Map.of(this.destination(qn), Formatters.customize(new ValidatorTemplate()).render((Object)new FrameBuilder(new String[]{"validationLayer", "class"}).add("module", (Object)module).add("entity", (Object)this.entities("")).add("package", (Object)(this.workingPackage + ".validators")).toFrame()));
    }

    private Map<String, String> masterClass() {
        String masterView = this.workingPackage + DOT + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)"MasterView").toString());
        String fullLoad = this.workingPackage + DOT + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)"FullLoadMasterTerminal").toString());
        String lazyLoad = this.workingPackage + DOT + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)"LazyLoadMasterTerminal").toString());
        String masterTerminal = this.workingPackage + DOT + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)"MasterTerminal").toString());
        return Map.of(this.destination(masterView), Formatters.customize(new MasterTerminalTemplate()).render((Object)this.masterFrameBuilder("view").toFrame()), this.destination(fullLoad), Formatters.customize(new MasterTerminalTemplate()).render((Object)this.masterFrameBuilder("cached").toFrame()), this.destination(lazyLoad), Formatters.customize(new MasterTerminalTemplate()).render((Object)this.masterFrameBuilder("lazy").toFrame()), this.destination(masterTerminal), Formatters.customize(new MasterTerminalTemplate()).render((Object)this.masterFrameBuilder("interface").toFrame()));
    }

    private FrameBuilder masterFrameBuilder(String type) {
        FrameBuilder builder = new FrameBuilder(new String[]{"master"}).add("package", (Object)this.workingPackage);
        builder.add("entity", (Object)this.entities(type));
        builder.add(type);
        return builder;
    }

    private Frame[] entities(String type) {
        return (Frame[])this.model.entityList().stream().map(c -> {
            FrameBuilder b = new FrameBuilder(new String[]{"entity"}).add("name", (Object)c.name$());
            if (c.isAbstract()) {
                b.add("abstract");
                Frame[] subclasses = this.subclassesOf((Entity)c);
                if (subclasses.length > 0) {
                    b.add("subclass", (Object)subclasses);
                }
            }
            b.add(type);
            return b.toFrame();
        }).toArray(Frame[]::new);
    }

    private Frame[] subclassesOf(Entity parent) {
        return (Frame[])this.model.entityList().stream().filter(e -> MasterRenderer.isSubclassOf(e, parent)).map(c -> new FrameBuilder(new String[]{"subclass"}).add("name", (Object)c.name$()).toFrame()).toArray(Frame[]::new);
    }

    private static boolean isSubclassOf(Entity node, Entity parent) {
        return node.isExtensionOf() && node.asExtensionOf().entity().equals(parent);
    }

    private Map<String, String> renderEntityNode(Entity entity) {
        return new EntityFrameCreator(this.workingPackage, this.model).create(entity).entrySet().stream().collect(Collectors.toMap(e -> this.entityDestination((String)e.getKey(), (Frame)e.getValue()), e -> this.entityTemplate.render(e.getValue())));
    }

    private Map<String, String> renderValidator(Entity entity) {
        return new ValidatorFrameCreator(this.workingPackage).create(entity).entrySet().stream().collect(Collectors.toMap(e -> this.validatorDestination((String)e.getKey(), (Frame)e.getValue()), e -> this.validatorTemplate.render(e.getValue())));
    }

    private Map<String, String> renderStructNode(Struct struct) {
        return new StructFrameCreator(this.workingPackage).create(struct).entrySet().stream().collect(Collectors.toMap(e -> this.destination((String)e.getKey()), e -> this.structTemplate.render(e.getValue())));
    }

    private void write(Map<String, String> outputsMap) {
        outputsMap.forEach((key, value) -> {
            File file = new File((String)key);
            if (value.isEmpty() || this.isUnderSource(file) && file.exists()) {
                return;
            }
            file.getParentFile().mkdirs();
            this.write(file, (String)value);
        });
    }

    private boolean isUnderSource(File file) {
        return file.getAbsolutePath().startsWith(this.srcFolder.getAbsolutePath());
    }

    private void write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
            fileWriter.write(text);
            fileWriter.close();
        }
        catch (IOException e) {
            this.notifier.notifyError(e.getMessage());
        }
    }

    private String destination(String path) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String entityDestination(String path, Frame frame) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String validatorDestination(String path, Frame frame) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }
}

