/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.Configuration;
import io.intino.datahub.model.NessGraph;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.MavenTerminalExecutor;
import io.intino.ness.datahubterminalplugin.master.MasterRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.PrintStream;
import java.util.Map;

public class MasterPublisher {
    private final NessGraph model;
    private final File root;
    private final Configuration conf;
    private final Map<String, String> versions;
    private final PluginLauncher.SystemProperties systemProperties;
    private final String basePackage;
    private final PluginLauncher.Phase invokedPhase;
    private final PluginLauncher.Notifier notifier;
    private final PrintStream logger;

    public MasterPublisher(File root, NessGraph model, Configuration configuration, Map<String, String> versions, PluginLauncher.SystemProperties systemProperties, PluginLauncher.Phase invokedPhase, PrintStream logger, PluginLauncher.Notifier notifier) {
        this.root = root;
        this.model = model;
        this.conf = configuration;
        this.versions = versions;
        this.systemProperties = systemProperties;
        this.basePackage = configuration.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifact().name()).toString().toLowerCase();
        this.invokedPhase = invokedPhase;
        this.logger = logger;
        this.notifier = notifier;
    }

    public boolean publish() {
        try {
            if (!this.createSources()) {
                return false;
            }
            this.logger.println("Publishing master...");
            new MavenTerminalExecutor(this.root, this.basePackage, MavenTerminalExecutor.Target.Master, "master-terminal", this.versions, this.conf, this.systemProperties, this.logger).mvn(this.invokedPhase == PluginLauncher.Phase.INSTALL ? "install" : "deploy");
            this.logger.println("Terminal master published!");
            return true;
        }
        catch (Throwable e) {
            this.logger.println(e.getMessage() == null ? e.toString() : e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean createSources() {
        return new MasterRenderer(this.root, this.model, this.conf, this.logger, this.notifier).render();
    }
}

