/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.Entity;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.DefaultValueHelper;
import io.intino.ness.datahubterminalplugin.master.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityFrameCreator {
    private static final String DOT = ".";
    private static final Map<String, String> types = Map.of("String", "String", "Double", "double", "Integer", "int", "Boolean", "boolean", "Entity", "io.intino.ness.master.model.Entity", "Long", "long");
    private static final Map<String, String> listTypes = Map.of("String", "List<String>", "Double", "List<Double>", "Integer", "List<Integer>", "Boolean", "List<Boolean>", "Entity", "List<io.intino.ness.master.model.Entity>", "Long", "List<Long>");
    private final String workingPackage;
    private final NessGraph model;

    public EntityFrameCreator(String workingPackage, NessGraph model) {
        this.workingPackage = workingPackage;
        this.model = model;
    }

    public Map<String, Frame> create(Entity entity) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(4);
        map.put(this.calculateEntityPath(entity, this.workingPackage), this.frameOf(entity).toFrame());
        if (entity.isDecorable()) {
            map.put(this.calculateDecorableEntityPath(entity.core$(), this.workingPackage), this.frameOf(entity).add("decorable").toFrame());
        }
        return map;
    }

    private FrameBuilder frameOf(Entity entity) {
        FrameBuilder builder = new FrameBuilder(new String[]{"entity", "class"}).add("package", (Object)this.workingPackage).add("name", (Object)entity.core$().name()).add("attribute", (Object)entity.core$().componentList().stream().map(a -> this.attrFrameOf((Node)a, entity.core$())).toArray());
        Parameter parent = this.parameter(entity.core$(), "entity");
        builder.add("parent", (Object)(parent != null ? ((Entity)parent.values().get(0)).name$() : "io.intino.ness.master.model.Entity"));
        if (entity.isDecorable() || entity.isAbstract()) {
            builder.add("isAbstract", (Object)"abstract");
        }
        if (entity.isDecorable()) {
            builder.add("abstract", (Object)"abstract");
        }
        return builder;
    }

    private Frame attrFrameOf(Node node, Node owner) {
        FrameBuilder builder = new FrameBuilder().add("attribute");
        node.conceptList().forEach(aspect -> builder.add(aspect.name()));
        String type = this.type(node);
        builder.add("name", (Object)node.name()).add("owner", (Object)node.owner().name()).add("type", (Object)type).add("package", (Object)this.workingPackage);
        builder.add("index", (Object)node.owner().componentList().indexOf(node));
        builder.add("entityOwner", (Object)owner.name());
        if (owner.is(Entity.Abstract.class) || owner.is(Entity.Decorable.class)) {
            builder.add("castToSubclass", (Object)("(" + owner.name() + ")"));
        }
        this.processParameters(node, builder, type);
        return builder.toFrame();
    }

    private void processParameters(Node node, FrameBuilder builder, String type) {
        Parameter struct;
        Parameter format;
        Parameter defaultValue;
        Parameter values = this.parameter(node, "values");
        if (values != null) {
            builder.add("value", (Object)values.values().stream().map(Object::toString).toArray());
        }
        if ((defaultValue = DefaultValueHelper.getDefaultValue(node)) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(node, type, defaultValue));
        }
        if ((format = this.parameter(node, "format")) != null) {
            builder.add("format", format.values().get(0));
        } else if (type.startsWith("Date")) {
            builder.add("format", (Object)this.defaultFormat(type));
        }
        Parameter entity = this.parameter(node, "entity");
        if (entity != null) {
            String name = ((Entity)entity.values().get(0)).name$();
            builder.add("entity", (Object)name);
            Entity reference = this.model.entityList().stream().filter(e -> e.name$().equals(name)).findFirst().orElse(null);
            if (reference != null && reference.core$().conceptList().stream().anyMatch(c -> c.name().equals("Component"))) {
                builder.add("component");
            }
        }
        if ((struct = this.parameter(node, "struct")) != null) {
            builder.add("struct", (Object)this.structFrame(((Struct)struct.values().get(0)).core$()));
        }
        builder.add("attribute", (Object)builder.toFrame());
    }

    private String defaultFormat(String type) {
        return type.equals("Date") ? "dd/MM/yyyy" : "dd/MM/yyyy HH:mm:ss";
    }

    private Frame structFrame(Node node) {
        return new FrameBuilder(new String[]{"struct"}).add("name", (Object)node.name()).add("package", (Object)this.workingPackage).add("attribute", (Object)node.componentList().stream().map(node1 -> this.attrFrameOf((Node)node1, node)).toArray()).toFrame();
    }

    private Frame defaultValue(Node c, String type, Parameter defaultValue) {
        FrameBuilder builder = new FrameBuilder((String[])c.conceptList().stream().map(Predicate::name).toArray(String[]::new));
        return builder.add("type", (Object)type).add("value", (Object)EntityFrameCreator.defaultValueOf(type, defaultValue)).toFrame();
    }

    private static String defaultValueOf(String type, Parameter defaultValue) {
        if (type.contains("List<")) {
            return "new java.util.ArrayList<>()";
        }
        if (type.contains("Map<")) {
            return "new java.util.HashMap<>()";
        }
        return defaultValue.values().get(0).toString();
    }

    private String type(Node node) {
        String aspect = node.conceptList().stream().map(Predicate::name).filter(this::isProperTypeName).findFirst().orElse("");
        boolean list = node.conceptList().stream().anyMatch(a -> a.name().equals("List"));
        if (!list) {
            return types.getOrDefault(aspect, StringFormatters.firstUpperCase().format((Object)node.name()).toString());
        }
        return listTypes.getOrDefault(aspect, "List<" + StringFormatters.firstUpperCase().format((Object)node.name()).toString() + ">");
    }

    private boolean isProperTypeName(String s) {
        return !s.equals("List") && !s.equals("Optional") && !s.equals("Type");
    }

    private Parameter parameter(Node c, String name) {
        List values = (List)c.variables().get(name);
        return values == null ? null : Parameter.of(values);
    }

    private String calculateEntityPath(Entity entity, String aPackage) {
        return aPackage + ".entities." + (entity.isDecorable() ? "Abstract" : "") + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)entity.core$().name()).toString());
    }

    private String calculateDecorableEntityPath(Node node, String aPackage) {
        return aPackage + ".entities." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)node.name()).toString());
    }
}

