/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.NessGraph;
import io.intino.datahub.graph.Terminal;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.stores.FileSystemStore;
import io.intino.ness.datahubterminalplugin.ArtifactoryConnector;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.OntologyPublisher;
import io.intino.ness.datahubterminalplugin.TerminalPublisher;
import io.intino.plugin.PluginLauncher;
import io.intino.plugin.project.Safe;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class DataHubTerminalsPluginLauncher
extends PluginLauncher {
    private static final String MINIMUM_BPM_VERSION = "1.2.5";
    private static final String MINIMUM_TERMINAL_JMS_VERSION = "4.0.0";
    private static final String MINIMUM_EVENT_VERSION = "3.0.0";
    private static final String MINIMUM_INGESTION_VERSION = "4.0.0";
    private static final String MAX_TERMINAL_JMS_VERSION = "5.0.0";
    private static final String MAX_INGESTION_VERSION = "5.0.0";
    private static final String MAX_EVENT_VERSION = "4.0.0";

    public void run() {
        if (this.invokedPhase.ordinal() < 2) {
            return;
        }
        this.logger().println("Building " + this.configuration().artifact().name() + " terminal");
        File tempDir = this.tempDirectory();
        this.run(tempDir);
    }

    public void run(File tempDir) {
        List directories;
        File resDirectory;
        if (this.logger() != null) {
            this.logger().println("Maven HOME: " + this.systemProperties.mavenHome.getAbsolutePath());
        }
        if ((resDirectory = (File)(directories = this.moduleStructure().resDirectories).stream().filter(d -> {
            File[] files = d.getAbsoluteFile().listFiles(f -> f.getName().endsWith(".stash"));
            return files != null && files.length > 0;
        }).findFirst().orElse(null)) == null) {
            this.notifier().notifyError("Stashes not found. Please compile module");
            return;
        }
        String[] stashes = (String[])Arrays.stream(Objects.requireNonNull(resDirectory.listFiles(f -> f.getName().endsWith(".stash")))).map(f -> f.getName().replace(".stash", "")).toArray(String[]::new);
        Graph graph = new Graph((Store)new FileSystemStore(resDirectory)).loadStashes(stashes);
        if (graph == null) {
            this.notifier().notifyError("Couldn't load graph. Please recompile module");
            return;
        }
        if (DataHubTerminalsPluginLauncher.safe(() -> this.configuration().artifact().distribution()) != null && DataHubTerminalsPluginLauncher.safe(() -> this.configuration().artifact().distribution().snapshot()) == null && this.isSnapshotVersion()) {
            this.notifier().notifyError("Snapshot distribution repository not found");
            return;
        }
        Map<String, String> versions = Map.of("terminal-jms", this.terminalJmsVersion(), "ingestion", this.ingestionVersion(), "bpm", this.bpmVersion(), "event", this.eventVersion());
        this.publishOntology((NessGraph)graph.as(NessGraph.class), versions, tempDir);
        this.publishTerminals((NessGraph)graph.as(NessGraph.class), versions, tempDir);
        this.logger().println("Finished generation of terminals!");
    }

    private void publishOntology(NessGraph graph, Map<String, String> versions, File tempDir) {
        try {
            AtomicBoolean published = new AtomicBoolean(true);
            published.set(new OntologyPublisher(new File(tempDir, "ontology"), graph, this.configuration(), this.moduleStructure(), versions, this.systemProperties(), this.invokedPhase, this.logger()).publish() & published.get());
            if (published.get() && this.notifier() != null) {
                this.notifier().notify("Ontology " + this.participle() + ". Copy maven dependency:\n" + this.accessorDependency(this.configuration().artifact().groupId() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.configuration().artifact().name()).toString().toLowerCase(), "ontology", this.configuration().artifact().version()));
            }
        }
        catch (Throwable e) {
            this.logger().println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void publishTerminals(NessGraph nessGraph, Map<String, String> versions, File tempDir) {
        try {
            AtomicBoolean published = new AtomicBoolean(true);
            nessGraph.terminalList().parallelStream().forEach(terminal -> {
                published.set(new TerminalPublisher(new File(tempDir, terminal.name$()), (Terminal)terminal, this.tanks((Terminal)terminal), this.configuration(), versions, this.systemProperties(), this.invokedPhase, this.logger()).publish() & published.get());
                if (published.get() && this.notifier() != null) {
                    this.notifier().notify("Terminal " + terminal.name$() + " " + this.participle() + ". Copy maven dependency:\n" + this.accessorDependency(this.configuration().artifact().groupId() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.configuration().artifact().name()).toString().toLowerCase(), this.terminalNameArtifact((Terminal)terminal), this.configuration().artifact().version()));
                }
            });
        }
        catch (Throwable e) {
            this.logger().println(e.getMessage());
            e.printStackTrace();
        }
    }

    private String terminalNameArtifact(Terminal terminal) {
        return Formatters.firstLowerCase(Formatters.camelCaseToSnakeCase().format((Object)terminal.name$()).toString());
    }

    private String terminalJmsVersion() {
        List<String> terminalVersions = ArtifactoryConnector.terminalVersions();
        Collections.reverse(terminalVersions);
        return terminalVersions.isEmpty() ? "4.0.0" : this.suitableTerminalVersion(terminalVersions);
    }

    private String ingestionVersion() {
        List<String> versions = ArtifactoryConnector.ingestionVersions();
        Collections.reverse(versions);
        return versions.isEmpty() ? "4.0.0" : this.suitableIngestionVersion(versions);
    }

    private String eventVersion() {
        List<String> versions = ArtifactoryConnector.eventVersions();
        Collections.reverse(versions);
        return versions.isEmpty() ? MINIMUM_EVENT_VERSION : this.suitableEventVersion(versions);
    }

    private String suitableTerminalVersion(List<String> versions) {
        return versions.stream().filter(version -> version.compareTo("5.0.0") < 0).findFirst().orElse("4.0.0");
    }

    private String suitableIngestionVersion(List<String> versions) {
        return versions.stream().filter(v -> v.compareTo("5.0.0") < 0).findFirst().orElse("4.0.0");
    }

    private String suitableEventVersion(List<String> versions) {
        return versions.stream().filter(v -> v.compareTo("4.0.0") < 0).findFirst().orElse(MINIMUM_EVENT_VERSION);
    }

    private boolean isSnapshotVersion() {
        return this.configuration().artifact().version().contains("SNAPSHOT");
    }

    private String bpmVersion() {
        List<String> bpmVersions = ArtifactoryConnector.bpmVersions();
        return bpmVersions.isEmpty() ? MINIMUM_BPM_VERSION : bpmVersions.get(bpmVersions.size() - 1);
    }

    private String participle() {
        return this.invokedPhase == PluginLauncher.Phase.INSTALL ? "installed" : "distributed";
    }

    private String accessorDependency(String groupId, String artifactId, String version) {
        return "<dependency>\n    <groupId>" + groupId.toLowerCase() + "</groupId>\n    <artifactId>" + artifactId.toLowerCase() + "</artifactId>\n    <version>" + version + "</version>\n</dependency>";
    }

    private File tempDirectory() {
        try {
            return Files.createTempDirectory("_temp", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new File("");
        }
    }

    private List<Datalake.Tank.Event> tanks(Terminal terminal) {
        ArrayList<Datalake.Tank.Event> tanks = new ArrayList<Datalake.Tank.Event>();
        if (terminal.publish() != null) {
            tanks.addAll(terminal.publish().tanks());
        }
        if (terminal.subscribe() != null) {
            tanks.addAll(terminal.subscribe().tanks());
        }
        return tanks;
    }

    public static <T> T safe(Safe.Wrapper<T> wrapper) {
        try {
            return (T)wrapper.value();
        }
        catch (Throwable var2) {
            return null;
        }
    }
}

