/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.Configuration;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.Table;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.datahubterminalplugin.AccessorPomTemplate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.event.EventRenderer;
import io.intino.ness.datahubterminalplugin.event.TableRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

class OntologyPublisher {
    private final File root;
    private final List<Event> events;
    private final List<Table> tables;
    private final Configuration conf;
    private final PluginLauncher.SystemProperties systemProperties;
    private final String basePackage;
    private final PluginLauncher.Phase invokedPhase;
    private final PrintStream logger;
    private final List<Datalake.Tank.Event> tanks;
    private final StringBuilder errorStream;

    OntologyPublisher(File root, List<Datalake.Tank.Event> tanks, List<Event> events, List<Table> tables, Configuration configuration, PluginLauncher.SystemProperties systemProperties, PluginLauncher.Phase invokedPhase, PrintStream logger) {
        this.root = root;
        this.tanks = tanks;
        this.events = events;
        this.tables = tables;
        this.conf = configuration;
        this.systemProperties = systemProperties;
        this.basePackage = configuration.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifact().name()).toString().toLowerCase();
        this.invokedPhase = invokedPhase;
        this.logger = logger;
        this.errorStream = new StringBuilder();
    }

    boolean publish() {
        if (!this.createSources()) {
            return false;
        }
        try {
            this.logger.println("Publishing ontology...");
            this.mvn(this.invokedPhase == PluginLauncher.Phase.INSTALL ? "install" : "deploy");
            this.logger.println("Ontology published!");
        }
        catch (Exception e) {
            this.logger.println(e.getMessage());
            this.logger.println(this.errorStream.toString());
            return false;
        }
        return true;
    }

    private boolean createSources() {
        File srcDirectory = new File(this.root, "src");
        srcDirectory.mkdirs();
        Map<Event, Datalake.Split> eventSplitMap = this.collectEvents(this.tanks);
        eventSplitMap.forEach((k, v) -> new EventRenderer((Event)k, (Datalake.Split)v, srcDirectory, this.basePackage).render());
        ((Stream)this.events.stream().filter(event -> !eventSplitMap.containsKey(event)).parallel()).forEach(event -> new EventRenderer((Event)event, null, srcDirectory, this.basePackage).render());
        this.tables.forEach(t -> new TableRenderer((Table)t, srcDirectory, this.basePackage).render());
        File resDirectory = new File(this.root, "res");
        resDirectory.mkdirs();
        return true;
    }

    private Map<Event, Datalake.Split> collectEvents(List<Datalake.Tank.Event> tanks) {
        HashMap<Event, Datalake.Split> events = new HashMap<Event, Datalake.Split>();
        for (Datalake.Tank.Event tank : tanks) {
            List<Event> hierarchy = this.hierarchy(tank.event());
            Datalake.Split split = tank.asTank().isSplitted() ? tank.asTank().asSplitted().split() : null;
            events.put(hierarchy.get(0), split);
            hierarchy.remove(0);
            hierarchy.forEach(e -> events.put((Event)e, (Datalake.Split)null));
        }
        return events;
    }

    private List<Event> hierarchy(Event event) {
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        events.add(event);
        if (event.isExtensionOf()) {
            events.addAll(this.hierarchy(event.asExtensionOf().parent()));
        }
        return new ArrayList<Event>(events);
    }

    private void mvn(String goal) throws IOException, MavenInvocationException {
        File pom = this.createPom(this.root, this.basePackage, this.conf.artifact().version());
        InvocationResult result = this.invoke(pom, goal);
        if (result != null && result.getExitCode() != 0) {
            this.logger.println(this.errorStream.toString());
            if (result.getExecutionException() != null) {
                throw new IOException("Failed to publish accessor.", (Throwable)result.getExecutionException());
            }
            throw new IOException("Failed to publish accessor. Exit code: " + result.getExitCode());
        }
        if (result == null) {
            throw new IOException("Failed to publish accessor. Maven HOME not found");
        }
    }

    private InvocationResult invoke(File pom, String goal) throws MavenInvocationException {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        if (!goal.isEmpty()) {
            goals.add(goal);
        }
        InvocationRequest request = new DefaultInvocationRequest().setPomFile(pom).setGoals(goals);
        Invoker invoker = new DefaultInvoker().setMavenHome(this.systemProperties.mavenHome);
        this.log(invoker);
        this.config(request, this.systemProperties.mavenHome);
        return invoker.execute(request);
    }

    private void log(Invoker invoker) {
        invoker.setErrorHandler(this.logger::println);
        invoker.setOutputHandler(s -> this.errorStream.append(s).append("\n"));
    }

    private void config(InvocationRequest request, File mavenHome) {
        File mvn = new File(mavenHome, "bin" + File.separator + "mvn");
        mvn.setExecutable(true);
        request.setJavaHome(this.systemProperties.javaHome);
    }

    private File createPom(File root, String group, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)"ontology").add("version", (Object)version);
        this.conf.repositories().forEach(r -> this.buildRepoFrame(builder, (Configuration.Repository)r));
        if (this.conf.artifact().distribution() != null) {
            if (this.isSnapshotVersion()) {
                this.buildDistroFrame(builder, this.conf.artifact().distribution().snapshot());
            } else {
                this.buildDistroFrame(builder, this.conf.artifact().distribution().release());
            }
        }
        builder.add("event", (Object)new FrameBuilder());
        File pomFile = new File(root, "pom.xml");
        Commons.write(pomFile.toPath(), new AccessorPomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    private boolean isSnapshotVersion() {
        return this.conf.artifact().version().contains("SNAPSHOT");
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).toFrame());
    }

    private void buildDistroFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).add("distribution").toFrame());
    }

    private FrameBuilder createRepositoryFrame(Configuration.Repository repository) {
        return new FrameBuilder(new String[]{"repository", repository.getClass().getSimpleName()}).add("name", (Object)repository.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repository.url());
    }
}

