/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.Configuration;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.Table;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.datahubterminalplugin.AccessorPomTemplate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.event.EventRenderer;
import io.intino.ness.datahubterminalplugin.event.TableRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

class OntologyPublisher {
    private final File root;
    private final List<Event> events;
    private final List<Table> tables;
    private final Configuration conf;
    private final PluginLauncher.SystemProperties systemProperties;
    private final String basePackage;
    private final PluginLauncher.Phase invokedPhase;
    private final PrintStream logger;
    private final List<Datalake.Tank.Event> tanks;
    private final StringBuilder errorStream;

    OntologyPublisher(File root, List<Datalake.Tank.Event> tanks, List<Event> events, List<Table> tables, Configuration configuration, PluginLauncher.SystemProperties systemProperties, PluginLauncher.Phase invokedPhase, PrintStream logger) {
        this.root = root;
        this.tanks = tanks;
        this.events = events;
        this.tables = tables;
        this.conf = configuration;
        this.systemProperties = systemProperties;
        this.basePackage = configuration.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifact().name()).toString().toLowerCase();
        this.invokedPhase = invokedPhase;
        this.logger = logger;
        this.errorStream = new StringBuilder();
    }

    boolean publish() {
        if (!this.createSources()) {
            return false;
        }
        try {
            this.logger.println("Publishing ontology...");
            this.mvn(this.invokedPhase == PluginLauncher.Phase.INSTALL ? "install" : "deploy");
            this.logger.println("Ontology published!");
        }
        catch (IOException | MavenInvocationException e) {
            this.logger.println(e.getMessage());
            this.logger.println(this.errorStream.toString());
            return false;
        }
        return true;
    }

    private boolean createSources() {
        File srcDirectory = new File(this.root, "src");
        srcDirectory.mkdirs();
        Map<Event, Datalake.Context> eventContextMap = this.collectEvents(this.tanks);
        eventContextMap.forEach((k, v) -> new EventRenderer((Event)k, (Datalake.Context)v, srcDirectory, this.basePackage).render());
        ((Stream)this.events.stream().filter(event -> !eventContextMap.containsKey(event)).parallel()).forEach(event -> new EventRenderer((Event)event, null, srcDirectory, this.basePackage).render());
        this.tables.forEach(t -> new TableRenderer((Table)t, srcDirectory, this.basePackage).render());
        File resDirectory = new File(this.root, "res");
        resDirectory.mkdirs();
        return true;
    }

    private Map<Event, Datalake.Context> collectEvents(List<Datalake.Tank.Event> tanks) {
        HashMap<Event, Datalake.Context> events = new HashMap<Event, Datalake.Context>();
        for (Datalake.Tank.Event tank : tanks) {
            List<Event> hierarchy = this.hierarchy(tank.event());
            Datalake.Context context = tank.asTank().isContextual() ? tank.asTank().asContextual().context() : null;
            events.put(hierarchy.get(0), context);
            hierarchy.remove(0);
            hierarchy.forEach(e -> events.put((Event)e, (Datalake.Context)null));
        }
        return events;
    }

    private List<Event> hierarchy(Event event) {
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        events.add(event);
        if (event.isExtensionOf()) {
            events.addAll(this.hierarchy(event.asExtensionOf().parent()));
        }
        return new ArrayList<Event>(events);
    }

    private void mvn(String goal) throws IOException, MavenInvocationException {
        File pom = this.createPom(this.root, this.basePackage, this.conf.artifact().version());
        InvocationResult result = this.invoke(pom, goal);
        if (result != null && result.getExitCode() != 0) {
            if (result.getExecutionException() != null) {
                throw new IOException("Failed to publish accessor.", (Throwable)result.getExecutionException());
            }
            throw new IOException("Failed to publish accessor. Exit code: " + result.getExitCode());
        }
        if (result == null) {
            throw new IOException("Failed to publish accessor. Maven HOME not found");
        }
    }

    private InvocationResult invoke(File pom, String goal) throws MavenInvocationException {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        if (!goal.isEmpty()) {
            goals.add(goal);
        }
        InvocationRequest request = new DefaultInvocationRequest().setPomFile(pom).setGoals(goals);
        Invoker invoker = new DefaultInvoker().setMavenHome(this.systemProperties.mavenHome);
        this.log(invoker);
        this.config(request, this.systemProperties.mavenHome);
        return invoker.execute(request);
    }

    private void log(Invoker invoker) {
        invoker.setErrorHandler(this.logger::println);
        invoker.setOutputHandler(s -> this.errorStream.append(s).append("\n"));
    }

    private void config(InvocationRequest request, File mavenHome) {
        File mvn = new File(mavenHome, "bin" + File.separator + "mvn");
        mvn.setExecutable(true);
        request.setJavaHome(this.systemProperties.javaHome);
    }

    private File createPom(File root, String group, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)"ontology").add("version", (Object)version);
        this.conf.repositories().stream().filter(r -> !(r instanceof Configuration.Repository.Language)).forEach(r -> this.buildRepoFrame(builder, (Configuration.Repository)r, this.conf.artifact().version().contains("SNAPSHOT")));
        builder.add("event", (Object)new FrameBuilder());
        File pomFile = new File(root, "pom.xml");
        Commons.write(pomFile.toPath(), new AccessorPomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r, boolean snapshot) {
        builder.add("repository", (Object)this.createRepositoryFrame(r, snapshot));
    }

    private Frame createRepositoryFrame(Configuration.Repository repository, boolean snapshot) {
        return new FrameBuilder(new String[]{"repository", this.isDistribution(repository, snapshot) ? "distribution" : "release"}).add("name", (Object)repository.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repository.url()).toFrame();
    }

    private boolean isDistribution(Configuration.Repository repository, boolean snapshot) {
        Configuration.Distribution distribution = this.conf.artifact().distribution();
        if (distribution == null) {
            return false;
        }
        Configuration.Repository repo = snapshot ? distribution.snapshot() : distribution.release();
        return repo != null && repository.identifier().equals(repo.identifier()) && repository.url().equals(repo.url());
    }
}

