/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.NessGraph;
import io.intino.datahub.graph.Terminal;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.stores.FileSystemStore;
import io.intino.ness.datahubterminalplugin.ArtifactoryConnector;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.OntologyPublisher;
import io.intino.ness.datahubterminalplugin.TerminalPublisher;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class DataHubTerminalsPluginLauncher
extends PluginLauncher {
    private static final String MINIMUM_TERMINAL_JMS_VERSION = "2.0.0";
    private static final String MINIMUM_BPM_VERSION = "1.2.5";

    public void run() {
        if (this.invokedPhase.ordinal() < 2) {
            return;
        }
        this.logger().println("Building " + this.configuration().artifact().name() + " terminal");
        File tempDir = this.tempDirectory();
        this.run(tempDir);
    }

    public void run(File tempDir) {
        List directories = this.moduleStructure().resDirectories;
        File resDirectory = directories.stream().filter(d -> {
            File[] files = d.getAbsoluteFile().listFiles(f -> f.getName().endsWith(".stash"));
            return files != null && files.length > 0;
        }).findFirst().orElse(null);
        if (resDirectory == null) {
            this.notifier().notifyError("Stashes not found. Please compile module");
            return;
        }
        String[] stashes = (String[])Arrays.stream(Objects.requireNonNull(resDirectory.listFiles(f -> f.getName().endsWith(".stash")))).map(f -> f.getName().replace(".stash", "")).toArray(String[]::new);
        Graph graph = new Graph((Store)new FileSystemStore(resDirectory)).loadStashes(stashes);
        if (graph == null) {
            this.notifier().notifyError("Couldn't load graph. Please recompile module");
            return;
        }
        this.publishOntology((NessGraph)graph.as(NessGraph.class), tempDir);
        this.publishTerminals((NessGraph)graph.as(NessGraph.class), tempDir);
    }

    private void publishOntology(NessGraph graph, File tempDir) {
        try {
            AtomicBoolean published = new AtomicBoolean(true);
            published.set(new OntologyPublisher(new File(tempDir, "ontology"), this.eventTanks(graph), graph.eventList(), this.configuration(), this.systemProperties(), this.invokedPhase, this.logger()).publish() & published.get());
            if (published.get() && this.notifier() != null) {
                this.notifier().notify("Ontology " + this.participle() + ". Copy maven dependency:\n" + this.accessorDependency(this.configuration().artifact().groupId() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.configuration().artifact().name()).toString().toLowerCase(), "ontology", this.configuration().artifact().version()));
            }
            if (published.get()) {
                FileUtils.deleteDirectory((File)tempDir);
            }
        }
        catch (IOException e) {
            this.logger().println(e.getMessage());
        }
    }

    private void publishTerminals(NessGraph nessGraph, File tempDir) {
        try {
            String terminalJmsVersion = this.terminalJmsVersion();
            String bpmVersion = this.bpmVersion();
            AtomicBoolean published = new AtomicBoolean(true);
            nessGraph.terminalList().forEach(terminal -> {
                published.set(new TerminalPublisher(new File(tempDir, terminal.name$()), (Terminal)terminal, this.tanks((Terminal)terminal), this.configuration(), terminalJmsVersion, bpmVersion, this.systemProperties(), this.invokedPhase, this.logger()).publish() & published.get());
                if (published.get() && this.notifier() != null) {
                    this.notifier().notify("Terminal " + terminal.name$() + " " + this.participle() + ". Copy maven dependency:\n" + this.accessorDependency(this.configuration().artifact().groupId() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.configuration().artifact().name()).toString().toLowerCase(), terminal.name$(), this.configuration().artifact().version()));
                }
            });
            if (published.get()) {
                FileUtils.deleteDirectory((File)tempDir);
            }
        }
        catch (IOException e) {
            this.logger().println(e.getMessage());
        }
    }

    private String terminalJmsVersion() {
        List<String> terminalVersions = ArtifactoryConnector.terminalVersions();
        return terminalVersions.isEmpty() ? MINIMUM_TERMINAL_JMS_VERSION : terminalVersions.get(terminalVersions.size() - 1);
    }

    private String bpmVersion() {
        List<String> bpmVersions = ArtifactoryConnector.bpmVersions();
        return bpmVersions.isEmpty() ? MINIMUM_BPM_VERSION : bpmVersions.get(bpmVersions.size() - 1);
    }

    private String participle() {
        return this.invokedPhase == PluginLauncher.Phase.INSTALL ? "installed" : "distributed";
    }

    private String accessorDependency(String groupId, String artifactId, String version) {
        return "<dependency>\n    <groupId>" + groupId.toLowerCase() + "</groupId>\n    <artifactId>" + artifactId.toLowerCase() + "</artifactId>\n    <version>" + version + "</version>\n</dependency>";
    }

    private File tempDirectory() {
        try {
            return Files.createTempDirectory("_temp", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new File("");
        }
    }

    private List<Datalake.Tank.Event> eventTanks(NessGraph nessGraph) {
        return nessGraph.datalake().tankList().stream().filter(Datalake.Tank::isEvent).map(Datalake.Tank::asEvent).collect(Collectors.toList());
    }

    private List<Datalake.Tank.Event> tanks(Terminal terminal) {
        ArrayList<Datalake.Tank.Event> tanks = new ArrayList<Datalake.Tank.Event>();
        if (terminal.publish() != null) {
            tanks.addAll(terminal.publish().tanks());
        }
        if (terminal.subscribe() != null) {
            tanks.addAll(terminal.subscribe().tanks());
        }
        return tanks;
    }
}

