import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiFrame from "alexandria-ui-elements/src/displays/components/Frame";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiTextEditableCode from "alexandria-ui-elements/src/displays/components/TextEditableCode";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiDownload from "alexandria-ui-elements/src/displays/components/Download";
import DisplaysHeader from "datalake-inspector/src/displays/templates/Header";
import DisplaysHtmlViewer from "datalake-inspector/src/displays/HtmlViewer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractHomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1582191513" layout="vertical flexible">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1919650805" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2102217236">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a245239432" layout="vertical flexible" width="100.0%" height="100.0%">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1889802507" format="box" layout="vertical flexible" width="100.0%" height="100.0%">
							<UiTextEditableCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1125706209" format="fullHeight codeEditor" mode="normal" language="Java" value="">
							</UiTextEditableCode>
						</UiBlock>
						<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_273578758" title="review" target="self" mode="Button" size="Medium">
						</UiOpenDialog>
					</UiBlock>
				</UiBlock>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_523012281" title="Review" fullscreen={true}>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_318257084" layout="vertical flexible centercenter" width="100.0%" height="100.0%">
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a729423713" mode="Rise">
						</UiSpinner>
					</UiBlock>
					<UiDownload context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_658979336" title="download" target="self" mode="MaterialIconButton" icon="Archive" size="Large" format="absolute">
					</UiDownload>
					<UiFrame context={this._context.bind(this)} owner={this._owner.bind(this)} id="a279266518" format="fullWidth" visible={false}>
					</UiFrame>
				</UiDialog>
			</UiBlock>
		);
	}
}