import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractHeader extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="horizontal center" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_558615752" layout="horizontal center flexible" spacing="8">
					<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a854463473" width="200px" height="50px">
					</UiImage>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1831181350" format="h2" mode="normal" value="Data Lake Inspector">
					</UiText>
				</UiBlock>
			</UiBlock>
		);
	}
}