/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.Terminal;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.TerminalTemplate;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class TerminalRenderer {
    private final Terminal terminal;
    private final Map<Event, Datalake.Context> eventWithContext;
    private final File srcDir;
    private final String basePackage;

    TerminalRenderer(Terminal terminal, Map<Event, Datalake.Context> eventWithContext, File srcDir, String basePackage) {
        this.terminal = terminal;
        this.eventWithContext = eventWithContext;
        this.srcDir = srcDir;
        this.basePackage = basePackage;
    }

    void render() {
        File packageFolder = new File(this.srcDir, this.basePackage.replace(".", File.separator));
        Commons.writeFrame(packageFolder, Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString(), this.template().render((Object)this.createTerminalFrame()));
    }

    private Frame createTerminalFrame() {
        Datalake datalake = this.terminal.graph().datalake();
        FrameBuilder builder = new FrameBuilder().add("terminal").add("package", (Object)this.basePackage).add("name", (Object)this.terminal.name$());
        if (datalake != null) {
            builder.add("scale", (Object)datalake.scale().name());
        }
        builder.add("event", this.eventWithContext.keySet().stream().map(m -> new FrameBuilder(new String[]{"event"}).add("name", (Object)m.name$()).add("type", (Object)m.name$()).toFrame()).toArray(Frame[]::new));
        if (this.terminal.publish() != null) {
            this.terminal.publish().tanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Event)tank)));
        }
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().tanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Event)tank)));
        }
        if (this.terminal.allowsBpmIn() != null) {
            this.addBpm(builder);
        }
        return builder.toFrame();
    }

    private void addBpm(FrameBuilder builder) {
        Datalake.Context context = this.terminal.allowsBpmIn().context();
        String statusQn = this.terminal.allowsBpmIn().processStatusClass();
        String statusClassName = statusQn.substring(statusQn.lastIndexOf(".") + 1);
        Frame frame = new FrameBuilder(new String[]{"default"}).add("type", (Object)statusQn).add("typeName", (Object)statusClassName).add("channel", (Object)((String)(context != null ? context.qn() + "." : "") + statusClassName)).toFrame();
        builder.add("subscribe", (Object)frame);
        builder.add("publish", (Object)frame);
        builder.add("event", (Object)new FrameBuilder(new String[]{"event"}).add("name", (Object)statusClassName).add("type", (Object)statusQn).toFrame());
    }

    private Frame frameOf(Datalake.Tank.Event tank) {
        return new FrameBuilder(new String[]{this.contextsOf(tank).size() > 1 ? "multicontext" : "default"}).add("type", (Object)Formatters.firstUpperCase(tank.event().name$())).add("typeName", (Object)tank.event().name$()).add("channel", (Object)tank.qn()).toFrame();
    }

    private List<Datalake.Context> contextsOf(Datalake.Tank.Event tank) {
        return tank.asTank().isContextual() ? tank.asTank().asContextual().context().leafs() : Collections.emptyList();
    }

    private Template template() {
        return Formatters.customize(new TerminalTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

