/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import com.google.gson.Gson;
import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.graph.Datalake;
import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.Terminal;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.datahubterminalplugin.AccessorPomTemplate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.Manifest;
import io.intino.ness.datahubterminalplugin.TerminalRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

class TerminalPublisher {
    private final File root;
    private final Terminal terminal;
    private final Configuration conf;
    private final PluginLauncher.SystemProperties systemProperties;
    private final String basePackage;
    private final PluginLauncher.Phase invokedPhase;
    private final PrintStream logger;
    private List<Datalake.Tank.Event> tanks;

    TerminalPublisher(File root, Terminal terminal, List<Datalake.Tank.Event> tanks, Configuration configuration, PluginLauncher.SystemProperties systemProperties, PluginLauncher.Phase invokedPhase, PrintStream logger) {
        this.root = root;
        this.terminal = terminal;
        this.tanks = tanks;
        this.conf = configuration;
        this.systemProperties = systemProperties;
        this.basePackage = configuration.artifact().groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifact().name()).toString().toLowerCase();
        this.invokedPhase = invokedPhase;
        this.logger = logger;
    }

    boolean publish() {
        if (!this.createSources()) {
            return false;
        }
        try {
            this.mvn(this.invokedPhase == PluginLauncher.Phase.INSTALL ? "install" : "deploy");
        }
        catch (IOException | MavenInvocationException e) {
            this.logger.println(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean createSources() {
        File srcDirectory = new File(this.root, "src");
        srcDirectory.mkdirs();
        Map<Event, Datalake.Context> eventContextMap = this.collectEvents(this.tanks);
        new TerminalRenderer(this.terminal, eventContextMap, srcDirectory, this.basePackage).render();
        File resDirectory = new File(this.root, "res");
        resDirectory.mkdirs();
        this.writeManifest(resDirectory);
        return true;
    }

    private void writeManifest(File srcDirectory) {
        List<String> publish = this.terminal.publish() != null ? this.terminal.publish().tanks().stream().map(t -> t.asTank().event().name$()).collect(Collectors.toList()) : Collections.emptyList();
        List<String> subscribe = this.terminal.subscribe() != null ? this.terminal.subscribe().tanks().stream().map(t -> t.asTank().event().name$()).collect(Collectors.toList()) : Collections.emptyList();
        Manifest manifest = new Manifest(this.terminal.name$(), this.basePackage + "." + Formatters.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString()), publish, subscribe, this.tankClasses(), this.eventContexts());
        try {
            Files.write(new File(srcDirectory, "terminal.mf").toPath(), new Gson().toJson((Object)manifest).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String terminalNameArtifact() {
        return Formatters.firstLowerCase(Formatters.camelCaseToSnakeCase().format((Object)this.terminal.name$()).toString());
    }

    private Map<String, Set<String>> eventContexts() {
        HashMap<String, Set<String>> eventContexts;
        Map<String, Set<String>> map = eventContexts = this.terminal.publish() == null ? new HashMap<String, Set<String>>() : this.eventContextOf(this.terminal.publish().tanks());
        if (this.terminal.subscribe() == null) {
            return eventContexts;
        }
        Map<String, Set<String>> subscribeEventContexts = this.eventContextOf(this.terminal.subscribe().tanks());
        for (String eventType : subscribeEventContexts.keySet()) {
            if (!eventContexts.containsKey(eventType)) {
                eventContexts.put(eventType, new HashSet());
            }
            ((Set)eventContexts.get(eventType)).addAll((Collection)subscribeEventContexts.get(eventType));
        }
        return eventContexts;
    }

    private Map<String, Set<String>> eventContextOf(List<Datalake.Tank.Event> tanks) {
        return tanks.stream().collect(Collectors.toMap(t -> t.asTank().event().name$(), tank -> tank.asTank().isContextual() ? tank.asTank().asContextual().context().leafs().stream().map(Datalake.Context::qn).collect(Collectors.toSet()) : Collections.emptySet(), (a, b) -> b));
    }

    private Map<String, String> tankClasses() {
        HashMap<String, String> tankClasses = new HashMap<String, String>();
        if (this.terminal.publish() != null) {
            this.terminal.publish().tanks().forEach(t -> tankClasses.putIfAbsent(t.asTank().event().name$(), this.basePackage + ".events." + t.asTank().event().name$()));
        }
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().tanks().forEach(t -> tankClasses.putIfAbsent(t.asTank().event().name$(), this.basePackage + ".events." + t.asTank().event().name$()));
        }
        if (this.terminal.allowsBpmIn() != null) {
            Datalake.Context context = this.terminal.allowsBpmIn().context();
            String statusQn = this.terminal.allowsBpmIn().processStatusClass();
            String statusClassName = statusQn.substring(statusQn.lastIndexOf(".") + 1);
            tankClasses.put((String)(context != null ? context.qn() + "." : "") + statusClassName, statusQn);
        }
        return tankClasses;
    }

    private Map<Event, Datalake.Context> collectEvents(List<Datalake.Tank.Event> tanks) {
        HashMap<Event, Datalake.Context> events = new HashMap<Event, Datalake.Context>();
        for (Datalake.Tank.Event tank : tanks) {
            List<Event> hierarchy = this.hierarchy(tank.event());
            Datalake.Context context = tank.asTank().isContextual() ? tank.asTank().asContextual().context() : null;
            events.put(hierarchy.get(0), context);
            hierarchy.remove(0);
            hierarchy.forEach(e -> events.put((Event)e, (Datalake.Context)null));
        }
        return events;
    }

    private List<Event> hierarchy(Event event) {
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        events.add(event);
        if (event.isExtensionOf()) {
            events.addAll(this.hierarchy(event.asExtensionOf().parent()));
        }
        return new ArrayList<Event>(events);
    }

    private void mvn(String goal) throws IOException, MavenInvocationException {
        File pom = this.createPom(this.root, this.basePackage, this.terminalNameArtifact(), this.conf.artifact().version());
        InvocationResult result = this.invoke(pom, goal);
        if (result != null && result.getExitCode() != 0) {
            if (result.getExecutionException() != null) {
                throw new IOException("Failed to publish accessor.", (Throwable)result.getExecutionException());
            }
            throw new IOException("Failed to publish accessor. Exit code: " + result.getExitCode());
        }
        if (result == null) {
            throw new IOException("Failed to publish accessor. Maven HOME not found");
        }
    }

    private InvocationResult invoke(File pom, String goal) throws MavenInvocationException {
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        if (!goal.isEmpty()) {
            goals.add(goal);
        }
        InvocationRequest request = new DefaultInvocationRequest().setPomFile(pom).setGoals(goals);
        this.logger.println("Maven HOME: " + this.systemProperties.mavenHome.getAbsolutePath());
        Invoker invoker = new DefaultInvoker().setMavenHome(this.systemProperties.mavenHome);
        this.log(invoker);
        this.config(request, this.systemProperties.mavenHome);
        return invoker.execute(request);
    }

    private void log(Invoker invoker) {
        invoker.setErrorHandler(this.logger::println);
        invoker.setOutputHandler(this.logger::println);
    }

    private void config(InvocationRequest request, File mavenHome) {
        File mvn = new File(mavenHome, "bin" + File.separator + "mvn");
        mvn.setExecutable(true);
        request.setJavaHome(this.systemProperties.javaHome);
    }

    private File createPom(File root, String group, String artifact, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)artifact).add("version", (Object)version);
        this.conf.repositories().stream().filter(r -> !(r instanceof Configuration.Repository.Language)).forEach(r -> this.buildRepoFrame(builder, (Configuration.Repository)r, this.conf.artifact().version().contains("SNAPSHOT")));
        builder.add("ontology", (Object)new FrameBuilder(new String[]{"ontology"}).add("group", (Object)group).add("artifact", (Object)"ontology").add("version", (Object)version));
        if (this.terminal.allowsBpmIn() != null) {
            builder.add("hasBpm", (Object)";");
        }
        File pomFile = new File(root, "pom.xml");
        Commons.write(pomFile.toPath(), new AccessorPomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r, boolean snapshot) {
        builder.add("repository", (Object)this.createRepositoryFrame(r, snapshot));
    }

    private Frame createRepositoryFrame(Configuration.Repository repository, boolean snapshot) {
        return new FrameBuilder(new String[]{"repository", this.isDistribution(repository, snapshot) ? "distribution" : "release"}).add("name", (Object)repository.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repository.url()).toFrame();
    }

    private boolean isDistribution(Configuration.Repository repository, boolean snapshot) {
        Configuration.Distribution distribution = this.conf.artifact().distribution();
        if (distribution == null) {
            return false;
        }
        Configuration.Repository repo = snapshot ? distribution.snapshot() : distribution.release();
        return repo != null && repository.identifier().equals(repo.identifier()) && repository.url().equals(repo.url());
    }
}

