package io.intino.ness.datahubterminalplugin;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class TerminalTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((type("terminal"))).output(literal("package ")).output(mark("package", "validPackage")).output(literal(";\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.Scale;\nimport io.intino.alexandria.event.Event;\nimport ")).output(mark("package", "validPackage")).output(literal(".events.*;\nimport java.util.List;\n\npublic class ")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal(" {\n\tprivate static final Scale scale = Scale.")).output(mark("scale")).output(literal(";\n\tprivate final io.intino.alexandria.event.EventHub eventHub;\n\tprivate java.util.Map<java.util.function.Consumer<?>, java.util.function.Consumer<io.intino.alexandria.event.Event>> consumers = new java.util.HashMap<>();\n\n\tpublic static String[] subscriptionChannels = new String[]{")).output(mark("subscribe", "channel")).output(literal("};\n\n\tpublic ")).output(mark("name", "snakeCaseToCamelCase", "firstUpperCase")).output(literal("(io.intino.alexandria.event.EventHub eventHub) {\n\t\tthis.eventHub = eventHub;\n\t}\n\n\tpublic void publish(Object event, String context) {\n\t\t")).output(mark("publish", "if").multiple("\n")).output(literal("\n\t}\n\n\tpublic BatchSession batch(java.io.File dataHubStageDirectory, java.io.File temporalStageDirectory) {\n\t\treturn new BatchSession(dataHubStageDirectory, temporalStageDirectory);\n\t}\n\n\t")).output(mark("publish").multiple("\n\n")).output(literal("\n\n\t")).output(mark("subscribe").multiple("\n\n")).output(literal("\n\n\tpublic void stop() {\n\t\t//eventHub.stop();\n\t}\n\n\tprivate static final Object monitor = new Object();\n\n\tpublic class BatchSession {\n\t\tprivate final java.io.File dataHubStage;\n\t\tprivate final java.io.File temporalStage;\n\t\tprivate final io.intino.alexandria.ingestion.SessionHandler sessionHandler;\n\t\tprivate final io.intino.alexandria.ingestion.EventSession eventSession;\n\n\n\t\tpublic BatchSession(java.io.File dataHubStage, java.io.File temporalStage) {\n\t\t\tthis.dataHubStage = dataHubStage;\n\t\t\tthis.temporalStage = temporalStage;\n\t\t\tthis.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);\n\t\t\tthis.eventSession = sessionHandler.createEventSession();\n\t\t}\n\n\t\tpublic void feed(Event event, String context) {\n            eventSession.put(tankOf(event, context), Timetag.of(event.ts(), scale), event);\n\t\t}\n\n\t\tpublic void push() {\n\t\t\tsessionHandler.pushTo(this.dataHubStage);\n\t\t\t//eventHub.sendEvent(\"service.ness.push\", new Event(new io.intino.alexandria.message.Message(\"Push\").set(\"stage\", temporalStage.getName())));\n\t\t}\n\n\t\tpublic synchronized void seal() {\n\t\t\tsynchronized(monitor) {\n\t\t\t\teventHub.requestResponse(\"service.ness.seal\", new Event(new io.intino.alexandria.message.Message(\"Seal\").set(\"stage\", temporalStage.getName())).ts(java.time.Instant.now()).toString(), s -> monitor.notify());\n\t\t\t\ttry {\n\t\t\t\t\tmonitor.wait();\n\t\t\t\t} catch (InterruptedException e) {\n\t\t\t\t\tio.intino.alexandria.logger.Logger.error(e);\n\t\t\t\t}\n\t\t\t}\n        }\n\n        private String tankOf(Event event, String context) {\n        \t")).output(mark("publish", "tankOf").multiple("\n")).output(literal("\n        \treturn event.toMessage().type();\n        }\n\t}\n\n\t")).output(mark("event", "interface").multiple("\n\n")).output(literal("\n}")),
			rule().condition((type("multicontext")), (trigger("if"))).output(literal("   if (event instanceof ")).output(mark("type")).output(literal(") publish((")).output(mark("type")).output(literal(") event, ")).output(mark("type", "FirstUpperCase")).output(literal(".Context.contextByQn(context));")),
			rule().condition((trigger("if"))).output(literal("   if (event instanceof ")).output(mark("type")).output(literal(") publish((")).output(mark("type")).output(literal(") event);")),
			rule().condition((type("multicontext")), (trigger("tankof"))).output(literal("   if (event instanceof ")).output(mark("type")).output(literal(") return ")).output(mark("type", "FirstUpperCase")).output(literal(".Context.contextByQn(context).qn() + \".")).output(mark("type")).output(literal("\";")),
			rule().condition((trigger("tankof"))).output(literal("   if (event instanceof ")).output(mark("type")).output(literal(") return \"")).output(mark("channel")).output(literal("\";")),
			rule().condition((type("multicontext")), (trigger("publish"))).output(literal("public void publish(")).output(mark("type")).output(literal(" ")).output(mark("typeName", "firstLowerCase")).output(literal(", ")).output(mark("type", "FirstUpperCase")).output(literal(".Context context, ")).output(mark("type", "FirstUpperCase")).output(literal(".Context... moreContexts) {\n\teventHub.sendEvent(context.qn() + \".")).output(mark("type")).output(literal("\", ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n\tfor (")).output(mark("type", "FirstUpperCase")).output(literal(".Context c : moreContexts)\n\t\teventHub.sendEvent(c.qn() + \".")).output(mark("type")).output(literal("\", ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n}")),
			rule().condition((trigger("publish"))).output(literal("public void publish(")).output(mark("type")).output(literal(" ")).output(mark("typeName", "firstLowerCase")).output(literal(") {\n\teventHub.sendEvent(\"")).output(mark("channel")).output(literal("\", ")).output(mark("typeName", "firstLowerCase")).output(literal(");\n}")),
			rule().condition((type("multiContext")), (trigger("subscribe"))).output(literal("public void subscribe(")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, String subscriberId, ")).output(mark("type", "FirstUpperCase")).output(literal(".Context context, ")).output(mark("type", "FirstUpperCase")).output(literal(".Context... moreContexts) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event)));\n\teventHub.attachListener(context.qn() + \".")).output(mark("type")).output(literal("\", subscriberId, consumers.get(onEventReceived));\n\tfor (")).output(mark("type", "FirstUpperCase")).output(literal(".Context c : moreContexts)\n\t\teventHub.attachListener(c.qn() + \".")).output(mark("type")).output(literal("\", subscriberId, consumers.get(onEventReceived));\n}\n\npublic void subscribe(")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, ")).output(mark("type", "FirstUpperCase")).output(literal(".Context context, ")).output(mark("type", "FirstUpperCase")).output(literal(".Context... moreContexts) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event)));\n\teventHub.attachListener(context.qn() + \".")).output(mark("type")).output(literal("\", consumers.get(onEventReceived));\n\tfor (")).output(mark("type", "FirstUpperCase")).output(literal(".Context c : moreContexts)\n\t\teventHub.attachListener(c.qn() + \".")).output(mark("type")).output(literal("\", consumers.get(onEventReceived));\n}\n\npublic void unsubscribe(")).output(mark("type", "FirstUpperCase")).output(literal("Consumer onEventReceived) {\n\teventHub.detachListeners(consumers.get(onEventReceived));\n}")),
			rule().condition((trigger("subscribe"))).output(literal("public void subscribe(")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived, String subscriberId) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event)));\n\teventHub.attachListener(\"")).output(mark("channel")).output(literal("\", subscriberId, consumers.get(onEventReceived));\n}\n\npublic void subscribe(")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived) {\n\tconsumers.put(onEventReceived, event -> onEventReceived.accept(new ")).output(mark("type")).output(literal("(event)));\n\teventHub.attachListener(\"")).output(mark("channel")).output(literal("\", consumers.get(onEventReceived));\n}\n\npublic void unsubscribe(")).output(mark("typeName", "FirstUpperCase")).output(literal("Consumer onEventReceived) {\n\teventHub.detachListeners(consumers.get(onEventReceived));\n}")),
			rule().condition((trigger("quoted"))).output(literal("\"")).output(mark("")).output(literal("\"")),
			rule().condition((trigger("interface"))).output(literal("public interface ")).output(mark("name")).output(literal("Consumer extends java.util.function.Consumer<")).output(mark("type")).output(literal("> {\n}"))
		);
	}
}