/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.transaction;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.graph.Data;
import io.intino.datahub.graph.WordBag;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.transaction.WordBagTemplate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class WordBagRenderer {
    private final WordBag wordBag;
    private final Configuration conf;
    private final File destination;
    private final List<File> resDirectories;
    private final String rootPackage;

    public WordBagRenderer(WordBag wordBag, Configuration conf, File destination, List<File> resDirectories, String rootPackage) {
        this.wordBag = wordBag;
        this.conf = conf;
        this.destination = destination;
        this.resDirectories = resDirectories;
        this.rootPackage = rootPackage;
    }

    public void render() {
        String rootPackage = this.wordBagPackage();
        File packageFolder = new File(this.destination, rootPackage.replace(".", File.separator));
        Frame frame = this.process(this.wordBag);
        Commons.writeFrame(packageFolder, this.wordBag.name$(), this.template().render((Object)new FrameBuilder(new String[]{"root"}).add("root", (Object)rootPackage).add("package", (Object)rootPackage).add("wordBag", (Object)frame)));
    }

    private Frame process(WordBag wordBag) {
        FrameBuilder builder = new FrameBuilder(new String[]{"wordBag"}).add("name", (Object)wordBag.name$()).add("type", (Object)(wordBag.isFromResource() ? String.class.getSimpleName() : wordBag.name$()));
        if (wordBag.isFromResource()) {
            builder.add("resource").add("resource", (Object)this.resource(wordBag));
            List columnList = wordBag.asFromResource().attributeList();
            for (int i = 0; i < columnList.size(); ++i) {
                boolean primitive = this.isPrimitive(((WordBag.FromResource.Attribute)columnList.get(i)).asType());
                FrameBuilder b = new FrameBuilder(new String[]{"column"}).add("name", (Object)((WordBag.FromResource.Attribute)columnList.get(i)).name$()).add("index", (Object)i).add("type", (Object)(primitive ? ((WordBag.FromResource.Attribute)columnList.get(i)).asType().primitive() : ((WordBag.FromResource.Attribute)columnList.get(i)).asType().type()));
                ((WordBag.FromResource.Attribute)columnList.get(i)).core$().conceptList().stream().filter(Concept::isAspect).map(Predicate::name).forEach(arg_0 -> ((FrameBuilder)b).add(arg_0));
                if (primitive) {
                    b.add("primitive");
                }
                builder.add("column", (Object)b.toFrame());
            }
        } else {
            builder.add("word", (Object)this.words(wordBag));
        }
        return builder.toFrame();
    }

    private boolean isPrimitive(Data.Type attribute) {
        Data data = attribute.asData();
        return data.isBool() || data.isInteger() || data.isLongInteger() || data.isReal();
    }

    private String resource(WordBag wordBag) {
        try {
            Path source = new File(wordBag.asFromResource().tsv().getPath()).getCanonicalFile().toPath();
            for (File resDirectory : this.resDirectories) {
                try {
                    return resDirectory.toPath().relativize(source).toFile().getPath().replace("\\", "/");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return null;
    }

    private Frame[] words(WordBag wordBag) {
        return (Frame[])wordBag.asFromCode().wordList().stream().map(w -> new FrameBuilder(new String[]{"word"}).add("name", (Object)w.name$()).add("index", (Object)w.value()).add("label", (Object)w.label()).toFrame()).toArray(Frame[]::new);
    }

    private Template template() {
        return Formatters.customize(new WordBagTemplate());
    }

    private String wordBagPackage() {
        return this.rootPackage + ".wordbag";
    }
}

