/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions.sorters;

import io.intino.alexandria.inl.Message;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zim.ZimBuilder;
import io.intino.alexandria.zim.ZimReader;
import io.intino.ness.core.sessions.sorters.MessageFileExternalSorter;
import io.intino.ness.core.sessions.sorters.MessageTimSort;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MessageSorter {
    static String SEPARATOR = "\n";
    private final File file;

    public MessageSorter(File file) {
        this.file = file;
    }

    public File sort() {
        if (this.inMb(this.file.length()) > 3L) {
            new MessageFileExternalSorter(this.file).sort();
        } else {
            this.overwrite(this.file, new MessageTimSort<Message>().doSort(this.loadMessages().toArray(new Message[0]), this.messageComparator()));
        }
        return this.file;
    }

    private void overwrite(File file, Message[] messages) {
        file.delete();
        new ZimBuilder(file).put(messages);
    }

    private List<Message> loadMessages() {
        Message message;
        ArrayList<Message> list = new ArrayList<Message>();
        ZimReader inlReader = new ZimReader(this.file);
        while ((message = inlReader.next()) != null) {
            list.add(message);
        }
        return list;
    }

    private long inMb(long length) {
        return length / 0x100000L;
    }

    private Comparator<Message> messageComparator() {
        return Comparator.comparing(m -> {
            String text = m.get("ts");
            if (text == null) {
                Logger.error((String)("ts is null for message: " + m.toString()));
            }
            return Instant.parse(text);
        });
    }
}

