/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions.sorters;

import io.intino.alexandria.inl.Message;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zim.ZimBuilder;
import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;

public class MessageFileExternalSorter {
    private static final String ZIM = ".zim";
    private static String SEPARATOR = "\n";
    private final File tankDirectory;
    private final File tempDirectory;
    private File file;

    public MessageFileExternalSorter(File file) {
        this.file = file;
        this.tankDirectory = this.file.getParentFile();
        this.tempDirectory = this.createTemporalFolder();
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                MessageFileExternalSorter.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }

    private File createTemporalFolder() {
        try {
            return Files.createTempDirectory("externalsorter", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            File externalSorter = new File("externalsorter");
            externalSorter.mkdirs();
            return externalSorter;
        }
    }

    public File sort() {
        ZimReader stream = new ZimReader(this.file);
        List<File> files = this.processBatches((ZimStream)stream);
        this.replace(this.sortAndMerge(files));
        return this.file;
    }

    private List<File> processBatches(ZimStream stream) {
        Message next;
        ArrayList<File> batches = new ArrayList<File>();
        ArrayList<Message> current = new ArrayList<Message>();
        int i = 0;
        int batch = 1;
        while ((next = stream.next()) != null) {
            current.add(next);
            if (++i != 50000) continue;
            batches.add(this.processBatch(current, batch++));
            i = 0;
        }
        if (!current.isEmpty()) {
            batches.add(this.processBatch(current, batch));
        }
        return batches;
    }

    private File processBatch(List<Message> messages, int batch) {
        File batchFile = new File(this.tempDirectory, batch + ZIM);
        messages.sort(this.messageComparator());
        new ZimBuilder(batchFile).put(messages);
        messages.clear();
        return batchFile;
    }

    private File sortAndMerge(List<File> files) {
        File temp = new File(this.tankDirectory, "temp.zim");
        try (BufferedWriter writer = new BufferedWriter(this.zipWriter(temp));){
            List<TemporalFile> temporalFiles = files.stream().map(TemporalFile::new).collect(Collectors.toList());
            TemporalFile temporalFile = this.temporalFileWithOldestMessage(temporalFiles);
            while (this.tempsAreActive(temporalFiles)) {
                writer.write(temporalFile.message.toString() + SEPARATOR);
                temporalFile.next();
                temporalFile = this.temporalFileWithOldestMessage(temporalFiles);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return temp;
    }

    private OutputStreamWriter zipWriter(File temp) throws IOException {
        return new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(temp)));
    }

    private void replace(File temp) {
        if (this.file.delete()) {
            temp.renameTo(this.file.getAbsoluteFile());
            MessageFileExternalSorter.deleteDirectory(this.tempDirectory);
        }
    }

    private TemporalFile temporalFileWithOldestMessage(List<TemporalFile> managers) {
        if (managers.isEmpty()) {
            return null;
        }
        Instant reference = this.instantOf(managers.get(0).message);
        TemporalFile temporalFile = managers.get(0);
        for (int i = 1; i < managers.size(); ++i) {
            Instant comparable = this.instantOf(managers.get(i).message);
            if (!comparable.isBefore(reference)) continue;
            reference = comparable;
            temporalFile = managers.get(i);
        }
        return temporalFile;
    }

    private Comparator<Message> messageComparator() {
        return Comparator.comparing(m -> m.asEvent().instant());
    }

    private Instant instantOf(Message message) {
        return message != null ? message.asEvent().instant() : Instant.MAX;
    }

    private boolean tempsAreActive(List<TemporalFile> files) {
        for (TemporalFile file : files) {
            if (file.message == null) continue;
            return true;
        }
        return false;
    }

    static class TemporalFile {
        final String source;
        private ZimStream stream;
        private Message message;

        TemporalFile(File file) {
            this.source = file.getName();
            this.stream = new ZimReader(file);
            this.next();
        }

        private void next() {
            this.message = this.stream.next();
        }
    }
}

