/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.triplestore.FileTripleStore;
import io.intino.alexandria.triplestore.MemoryTripleStore;
import io.intino.alexandria.triplestore.TripleStore;
import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import io.intino.ness.core.Blob;
import io.intino.ness.core.fs.FS;
import io.intino.ness.core.sessions.Fingerprint;
import io.intino.ness.core.sessions.SetSessionFileReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SetSessionManager {
    private final List<File> files;
    private final File storeFolder;

    private SetSessionManager(List<File> files, File storeFolder) {
        this.files = files;
        this.storeFolder = storeFolder;
    }

    public static void push(Blob blob, File stageFolder) {
        FS.copyInto(SetSessionManager.fileFor(blob, stageFolder), blob.inputStream());
    }

    public static void seal(File stageFolder, File storeFolder) {
        new SetSessionManager(SetSessionManager.blobsOf(stageFolder), storeFolder).seal();
    }

    private static List<File> blobsOf(File stageFolder) {
        File[] files = stageFolder.listFiles(f -> f.getName().endsWith(".blob"));
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    private static File fileFor(Blob blob, File parentFolder) {
        return new File(parentFolder, SetSessionManager.filename(blob));
    }

    private static String filename(Blob blob) {
        return blob.name() + ".blob";
    }

    private static String extensionOf(Blob.Type type) {
        return "." + type.name() + ".blob";
    }

    private void seal() {
        this.sealSetSessions();
        this.sealSetMetadataSessions();
    }

    private void sealSetMetadataSessions() {
        HashMap map = new HashMap();
        this.loadSetMetadataSessions().flatMap(TripleStore::all).forEach(s -> this.processTriple((String[])s, map));
        map.values().forEach(FileTripleStore::save);
    }

    private void processTriple(String[] triple, Map<String, FileTripleStore> map) {
        Fingerprint fingerprint = new Fingerprint(triple[0]);
        this.tripleStoreFor(this.metadataPathOf(fingerprint), map).put(fingerprint.set(), triple[1], (Object)triple[2]);
    }

    private String metadataPathOf(Fingerprint fingerprint) {
        return fingerprint.tank() + "/" + fingerprint.timetag();
    }

    private TripleStore tripleStoreFor(String path, Map<String, FileTripleStore> map) {
        if (!map.containsKey(path)) {
            map.put(path, new FileTripleStore(this.metadataFileOf(path)));
        }
        return (TripleStore)map.get(path);
    }

    private File metadataFileOf(String path) {
        return new File(this.storeFolder, path + "/" + ".metadata");
    }

    private Stream<MemoryTripleStore> loadSetMetadataSessions() {
        return this.files.parallelStream().filter(f -> f.getName().endsWith(SetSessionManager.extensionOf(Blob.Type.setMetadata))).map(f -> new MemoryTripleStore(this.zipStreamOf((File)f)));
    }

    private InputStream zipStreamOf(File file) {
        try {
            return new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private void sealSetSessions() {
        List<SetSessionFileReader> readers = this.loadSetSessions();
        Set<Fingerprint> distinctChunks = this.distinctChunks(readers);
        Logger.trace((String)("Sets to seal " + distinctChunks.size()));
        distinctChunks.parallelStream().forEach(distinctChunk -> this.process((Fingerprint)distinctChunk, readers));
    }

    private void process(Fingerprint fingerprint, List<SetSessionFileReader> readers) {
        try {
            List<ZetStream> streams = this.chunksOf(readers, fingerprint);
            File setFile = this.filepath(fingerprint);
            File tempFile = File.createTempFile(fingerprint.toString(), ".zet");
            if (setFile.exists()) {
                streams.add((ZetStream)new ZetReader(setFile));
            }
            int count = this.write(new ZetStream.Union(streams), tempFile);
            this.writeSizeInMetadata(fingerprint, count);
            Files.move(tempFile.toPath(), setFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void writeSizeInMetadata(Fingerprint fingerprint, int count) throws FileNotFoundException {
        TripleStore.Builder builder = new TripleStore.Builder((OutputStream)new FileOutputStream(this.metadataFileOf(this.metadataPathOf(fingerprint)), true));
        builder.put(fingerprint.set(), "_size_", (Object)count);
        builder.close();
    }

    private int write(ZetStream.Union stream, File file) throws IOException {
        file.getParentFile().mkdirs();
        DataOutputStream dataStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        int count = 0;
        while (stream.hasNext()) {
            dataStream.writeLong(stream.next());
            ++count;
        }
        dataStream.close();
        return count;
    }

    private List<SetSessionFileReader> loadSetSessions() {
        return this.files.parallelStream().filter(f -> f.getName().endsWith(SetSessionManager.extensionOf(Blob.Type.set))).map(f -> {
            try {
                return new SetSessionFileReader((File)f);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
    }

    private File filepath(Fingerprint fingerprint) {
        File output = new File(this.storeFolder, fingerprint + ".zet");
        output.getParentFile().mkdirs();
        return output;
    }

    private List<ZetStream> chunksOf(List<SetSessionFileReader> readers, Fingerprint fingerprint) {
        return readers.stream().map(r -> r.chunks(fingerprint)).flatMap(r -> r).map(SetSessionFileReader.Chunk::stream).collect(Collectors.toList());
    }

    private Set<Fingerprint> distinctChunks(List<SetSessionFileReader> readers) {
        return readers.stream().map(SetSessionFileReader::chunks).flatMap(r -> r).map(SetSessionFileReader.Chunk::fingerprint).collect(Collectors.toSet());
    }
}

