/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions;

import io.intino.alexandria.logger.Logger;
import io.intino.ness.core.Timetag;
import io.intino.ness.core.sessions.Fingerprint;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SetSessionFileWriter {
    private final Map<Fingerprint, List<Long>> chunks = new LinkedHashMap<Fingerprint, List<Long>>();
    private final DataOutputStream stream;

    public SetSessionFileWriter(OutputStream outputStream) {
        this.stream = new DataOutputStream(new BufferedOutputStream(outputStream));
    }

    public void add(String tank, Timetag timetag, String set, long id) {
        this.check(tank, timetag, set);
        this.add(Fingerprint.of(tank, timetag, set), id);
    }

    private void check(String tank, Timetag timetag, String set) {
        if (tank == null || tank.isEmpty() || timetag == null || set == null || set.isEmpty()) {
            throw new RuntimeException("SetStore: tank, timetag or set is not valid or is empty");
        }
    }

    private void add(Fingerprint fingerprint, long id) {
        if (!this.chunks.containsKey(fingerprint)) {
            this.chunks.put(fingerprint, new ArrayList());
        }
        this.chunks.get(fingerprint).add(id);
    }

    public void flush() {
        try {
            this.chunks.forEach(this::write);
            this.chunks.clear();
            this.stream.flush();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void write(Fingerprint fingerprint, List<Long> ids) {
        try {
            this.stream.writeInt(fingerprint.size());
            this.stream.writeBytes(fingerprint.toString());
            this.stream.writeInt(ids.size());
            Collections.sort(ids);
            for (long id : ids) {
                this.stream.writeLong(id);
            }
            this.stream.flush();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void close() {
        try {
            this.chunks.forEach(this::write);
            this.chunks.clear();
            this.stream.close();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

