/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZetStream;
import io.intino.ness.core.Timetag;
import io.intino.ness.core.sessions.Fingerprint;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;

public class SetSessionFileReader {
    private static final int LONG_SIZE = 8;
    private static final int INT_SIZE = 4;
    private final File file;
    private final List<Chunk> chunks = new ArrayList<Chunk>();

    public SetSessionFileReader(File file) throws IOException {
        this.file = this.unzip(file);
        this.readStructure(this.file);
    }

    private File unzip(File file) throws IOException {
        File target = this.tempFile();
        Files.copy(this.inputStreamOf(file), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return target;
    }

    private File tempFile() throws IOException {
        File temp = File.createTempFile("blob", "blob");
        temp.deleteOnExit();
        return temp;
    }

    private BufferedOutputStream outputStreamOf(File temp) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(temp));
    }

    private GZIPInputStream inputStreamOf(File file) throws IOException {
        return new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    private void readStructure(File file) throws IOException {
        try {
            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            Throwable throwable = null;
            try {
                try {
                    long pos = 0L;
                    while (true) {
                        Fingerprint fingerprint = new Fingerprint(this.readString(stream));
                        int idSize = stream.readInt();
                        stream.skipBytes(idSize * 8);
                        this.chunks.add(new Chunk(fingerprint, idSize, pos += (long)(4 + fingerprint.size() + 4)));
                        pos += (long)(idSize * 8);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        stream.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private String readString(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        byte[] bytes = new byte[size];
        stream.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public Stream<Chunk> chunks() {
        return this.chunks.stream();
    }

    public Stream<Chunk> chunks(Fingerprint fingerprint) {
        return this.chunks.stream().filter(c -> ((Chunk)c).fingerprint.equals(fingerprint));
    }

    public class Chunk {
        private final Fingerprint fingerprint;
        long position;
        private int idSize;

        Chunk(Fingerprint fingerprint, int idSize, long position) {
            this.fingerprint = fingerprint;
            this.idSize = idSize;
            this.position = position;
        }

        public Fingerprint fingerprint() {
            return this.fingerprint;
        }

        public String tank() {
            return this.fingerprint.tank();
        }

        public Timetag timetag() {
            return this.fingerprint.timetag();
        }

        public String set() {
            return this.fingerprint.set();
        }

        public ZetStream stream() {
            try {
                final RandomAccessFile access = new RandomAccessFile(SetSessionFileReader.this.file, "r");
                access.seek(this.position);
                final DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(access.getFD())));
                return new ZetStream(){
                    int count = 0;
                    long current = -1L;

                    public long current() {
                        return this.current;
                    }

                    public long next() {
                        try {
                            if (!this.hasNext()) {
                                this.current = -1L;
                                return -1L;
                            }
                            ++this.count;
                            this.current = stream.readLong();
                            return this.current;
                        }
                        catch (EOFException e) {
                            return -1L;
                        }
                        catch (IOException e) {
                            Logger.error((Throwable)e);
                            return -1L;
                        }
                    }

                    public boolean hasNext() {
                        boolean hasNext;
                        boolean bl = hasNext = this.count < Chunk.this.idSize;
                        if (!hasNext) {
                            try {
                                access.close();
                                stream.close();
                            }
                            catch (IOException e) {
                                Logger.error((Throwable)e);
                            }
                        }
                        return hasNext;
                    }
                };
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }
    }
}

