/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.triplestore.TripleStore;
import io.intino.ness.core.Blob;
import io.intino.ness.core.Datalake;
import io.intino.ness.core.Stage;
import io.intino.ness.core.Timetag;
import io.intino.ness.core.sessions.Fingerprint;
import io.intino.ness.core.sessions.SetSessionFileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;

public class SetSession {
    private final SetSessionFileWriter writer;
    private final TripleStore.Builder tripleStore;
    private final int maxSize;
    private int count = 0;

    public SetSession(Stage stage) {
        this(stage, 1000000);
    }

    public SetSession(Stage stage, int autoFlushSize) {
        this.writer = new SetSessionFileWriter(this.zipStream(stage.start(Blob.Type.set)));
        this.tripleStore = new TripleStore.Builder(this.zipStream(stage.start(Blob.Type.setMetadata)));
        this.maxSize = autoFlushSize;
    }

    private OutputStream zipStream(OutputStream outputStream) {
        try {
            return new GZIPOutputStream(outputStream);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public void put(String tank, Timetag timetag, String set, Stream<Long> ids) {
        ids.forEach(i -> this.writer.add(tank, timetag, set, (long)i));
        if (this.count++ >= this.maxSize) {
            this.doFlush();
        }
    }

    public void put(String tank, Timetag timetag, String set, long ... ids) {
        this.put(tank, timetag, set, Arrays.stream(ids).boxed());
    }

    public void define(String tank, Timetag timetag, String set, Datalake.SetStore.Variable variable) {
        this.tripleStore.put(Fingerprint.of(tank, timetag, set).toString(), variable.name, (Object)variable.value);
    }

    private void doFlush() {
        this.flush();
    }

    public void flush() {
        this.writer.flush();
        this.count = 0;
    }

    public void close() {
        this.writer.close();
        this.tripleStore.close();
    }
}

