/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions;

import io.intino.alexandria.zim.ZimBuilder;
import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import io.intino.ness.core.Blob;
import io.intino.ness.core.fs.FS;
import io.intino.ness.core.sessions.Fingerprint;
import io.intino.ness.core.sessions.sorters.MessageSorter;
import java.io.File;
import java.util.stream.Stream;

public class EventSessionManager {
    public static void push(File stageFolder, Blob blob) {
        FS.copyInto(EventSessionManager.fileFor(blob, stageFolder), blob.inputStream());
    }

    private static File fileFor(Blob blob, File stageFolder) {
        return new File(stageFolder, EventSessionManager.filename(blob));
    }

    private static String filename(Blob blob) {
        return blob.name() + ".blob";
    }

    public static void seal(File eventStageFolder, File eventStoreFolder) {
        EventSessionManager.eventSessionBlobs(eventStageFolder).forEach(f -> new Sealer(eventStoreFolder).seal((File)f));
    }

    private static Stream<File> eventSessionBlobs(File eventStageFolder) {
        return FS.filesIn(eventStageFolder, f -> f.getName().endsWith(".event.blob"));
    }

    private static ZimReader reader(File zimFile) {
        return new ZimReader(zimFile);
    }

    private static class Sealer {
        private File eventStoreFolder;

        public Sealer(File eventStoreFolder) {
            this.eventStoreFolder = eventStoreFolder;
        }

        public void seal(File file) {
            this.seal(this.datalakeFile(file), this.sessionFile(file));
        }

        private File sessionFile(File file) {
            return Sealer.sort(file);
        }

        private void seal(File datalakeFile, File sessionFile) {
            new ZimBuilder(datalakeFile).put((ZimStream)EventSessionManager.reader(sessionFile));
        }

        private File datalakeFile(File file) {
            File zimFile = new File(this.eventStoreFolder, this.fingerprintOf(file).toString() + ".zim");
            zimFile.getParentFile().mkdirs();
            return zimFile;
        }

        private Fingerprint fingerprintOf(File file) {
            return new Fingerprint(this.cleanedNameOf(file));
        }

        private String cleanedNameOf(File file) {
            return file.getName().substring(0, file.getName().indexOf("#")).replace("-", "/").replace(".event.blob", "");
        }

        private static File sort(File file) {
            return new MessageSorter(file).sort();
        }
    }
}

