/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.sessions;

import io.intino.alexandria.inl.Message;
import io.intino.alexandria.logger.Logger;
import io.intino.ness.core.Blob;
import io.intino.ness.core.Stage;
import io.intino.ness.core.Timetag;
import io.intino.ness.core.sessions.Fingerprint;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;

public class EventSession {
    private final Map<Fingerprint, BufferedWriter> writers = new HashMap<Fingerprint, BufferedWriter>();
    private Stage stage;

    public EventSession(Stage stage) {
        this.stage = stage;
    }

    public void put(String tank, Timetag timetag, Stream<Message> messages) {
        this.put(this.writerOf(tank, timetag), messages);
    }

    private void put(BufferedWriter writer, Stream<Message> messages) {
        messages.forEach(m -> this.write(writer, (Message)m));
    }

    private BufferedWriter writerOf(String tank, Timetag timetag) {
        return this.writerOf(Fingerprint.of(tank, timetag));
    }

    private BufferedWriter writerOf(Fingerprint fingerprint) {
        if (!this.writers.containsKey(fingerprint)) {
            this.writers.put(fingerprint, this.createWriter(fingerprint));
        }
        return this.writers.get(fingerprint);
    }

    private BufferedWriter createWriter(Fingerprint fingerprint) {
        return new BufferedWriter(new OutputStreamWriter(this.zipStream(this.stage.start(fingerprint.name(), Blob.Type.event))));
    }

    private GZIPOutputStream zipStream(OutputStream outputStream) {
        try {
            return new GZIPOutputStream(outputStream);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public void put(String tank, Timetag timetag, Message ... messages) {
        this.put(tank, timetag, Arrays.stream(messages));
    }

    public void close() {
        try {
            for (BufferedWriter w : this.writers.values()) {
                w.close();
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void write(BufferedWriter writer, Message message) {
        try {
            writer.write(message.toString() + "\n\n");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }
}

