/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.core.fs;

import io.intino.alexandria.logger.Logger;
import io.intino.ness.core.Blob;
import io.intino.ness.core.Stage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.stream.Stream;

public class FSStage
implements Stage {
    private static final String BlobExtension = ".blob";
    private final File root;

    public FSStage(File root) {
        this.root = root;
        this.root.mkdirs();
    }

    private static String extensionOf(Blob.Type type) {
        return "." + type.name() + BlobExtension;
    }

    @Override
    public OutputStream start(Blob.Type type) {
        return this.start("", type);
    }

    @Override
    public OutputStream start(String prefix, Blob.Type type) {
        try {
            return new FileOutputStream(this.fileOf(prefix, type));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Stream<Blob> blobs() {
        return this.files().map(FileBlob::new);
    }

    @Override
    public void clear() {
        this.files().forEach(File::delete);
    }

    private Stream<File> files() {
        File[] files = this.root.listFiles(this::blobs);
        return files == null ? Stream.empty() : Arrays.stream(files);
    }

    private File fileOf(String name, Blob.Type type) {
        return new File(this.root, this.withExtension(this.name(name), type));
    }

    private String withExtension(String name, Blob.Type type) {
        return name + FSStage.extensionOf(type);
    }

    private boolean blobs(File dir, String name) {
        return name.endsWith(BlobExtension);
    }

    private static class FileBlob
    implements Blob {
        private final File file;
        private final Blob.Type type;

        public FileBlob(File file) {
            this.file = file;
            this.type = this.typeOf(file.getName());
        }

        @Override
        public String name() {
            String name = this.file.getName();
            return name.substring(0, name.lastIndexOf("."));
        }

        private Blob.Type typeOf(String filename) {
            return Arrays.stream(Blob.Type.values()).filter(type -> filename.endsWith(FSStage.extensionOf(type))).findFirst().orElse(null);
        }

        @Override
        public Blob.Type type() {
            return this.type;
        }

        @Override
        public InputStream inputStream() {
            return new BufferedInputStream(this.inputStreamOfFile());
        }

        private InputStream inputStreamOfFile() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                Logger.error((Throwable)e);
                return new ByteArrayInputStream(new byte[0]);
            }
        }
    }
}

